/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.api;

import io.servicetalk.transport.api.AbstractSslConfig;
import io.servicetalk.transport.api.AbstractSslConfigBuilder;
import io.servicetalk.transport.api.CertificateCompressionAlgorithm;
import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.api.SslConfig;
import io.servicetalk.transport.api.SslProvider;
import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public final class ClientSslConfigBuilder
extends AbstractSslConfigBuilder<ClientSslConfigBuilder> {
    @Nullable
    private String hostnameVerificationAlgorithm = "HTTPS";
    @Nullable
    private String peerHost;
    private int peerPort = -1;
    @Nullable
    private String sniHostname;

    public ClientSslConfigBuilder() {
    }

    public ClientSslConfigBuilder(TrustManagerFactory tmf) {
        this.trustManager(Objects.requireNonNull(tmf));
    }

    public ClientSslConfigBuilder(Supplier<InputStream> trustCertChainSupplier) {
        this.trustManager(trustCertChainSupplier);
    }

    public ClientSslConfigBuilder hostnameVerificationAlgorithm(String algorithm) {
        this.hostnameVerificationAlgorithm = Objects.requireNonNull(algorithm);
        return this;
    }

    public ClientSslConfigBuilder peerHost(@Nullable String peerHost) {
        this.peerHost = peerHost;
        return this;
    }

    public ClientSslConfigBuilder peerPort(int peerPort) {
        if (peerPort < -1) {
            throw new IllegalArgumentException("peerPort: " + peerPort + "(expected >=-1)");
        }
        this.peerPort = peerPort;
        return this;
    }

    public ClientSslConfigBuilder sniHostname(String sniHostname) {
        if (sniHostname.isEmpty()) {
            throw new IllegalArgumentException("sniHostname cannot be empty");
        }
        this.sniHostname = sniHostname;
        return this;
    }

    public ClientSslConfig build() {
        return new DefaultClientSslConfig(this.hostnameVerificationAlgorithm, this.peerHost, this.peerPort, this.sniHostname, this.trustManager(), this.trustCertChainSupplier(), this.keyManager(), this.keyCertChainSupplier(), this.keySupplier(), this.keyPassword(), this.sslProtocols(), this.alpnProtocols(), this.ciphers(), this.cipherSuiteFilter(), this.sessionCacheSize(), this.sessionTimeout(), this.maxCertificateListBytes(), this.provider(), this.certificateCompressionAlgorithms(), this.handshakeTimeout());
    }

    @Override
    protected ClientSslConfigBuilder thisT() {
        return this;
    }

    private static final class DefaultClientSslConfig
    extends AbstractSslConfig
    implements ClientSslConfig {
        @Nullable
        private final String hostnameVerificationAlgorithm;
        @Nullable
        private final String peerHost;
        private final int peerPort;
        @Nullable
        private final String sniHostname;

        DefaultClientSslConfig(@Nullable String hostnameVerificationAlgorithm, @Nullable String peerHost, int peerPort, @Nullable String sniHostname, @Nullable TrustManagerFactory trustManagerFactory, @Nullable Supplier<InputStream> trustCertChainSupplier, @Nullable KeyManagerFactory keyManagerFactory, @Nullable Supplier<InputStream> keyCertChainSupplier, @Nullable Supplier<InputStream> keySupplier, @Nullable String keyPassword, @Nullable List<String> sslProtocols, @Nullable List<String> alpnProtocols, @Nullable List<String> ciphers, SslConfig.CipherSuiteFilter cipherSuiteFilter, long sessionCacheSize, long sessionTimeout, int maxCertificateListBytes, @Nullable SslProvider provider, @Nullable List<CertificateCompressionAlgorithm> certificateCompressionAlgorithms, Duration handshakeTimeout) {
            super(trustManagerFactory, trustCertChainSupplier, keyManagerFactory, keyCertChainSupplier, keySupplier, keyPassword, sslProtocols, alpnProtocols, ciphers, cipherSuiteFilter, sessionCacheSize, sessionTimeout, maxCertificateListBytes, provider, certificateCompressionAlgorithms, handshakeTimeout);
            this.hostnameVerificationAlgorithm = hostnameVerificationAlgorithm;
            this.peerHost = peerHost;
            this.peerPort = peerPort;
            this.sniHostname = sniHostname;
        }

        @Override
        @Nullable
        public String hostnameVerificationAlgorithm() {
            return this.hostnameVerificationAlgorithm;
        }

        @Override
        @Nullable
        public String peerHost() {
            return this.peerHost;
        }

        @Override
        public int peerPort() {
            return this.peerPort;
        }

        @Override
        @Nullable
        public String sniHostname() {
            return this.sniHostname;
        }
    }
}

