/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.api;

import io.servicetalk.transport.api.CertificateCompressionAlgorithm;
import io.servicetalk.transport.api.SslConfig;
import io.servicetalk.transport.api.SslProvider;
import io.servicetalk.utils.internal.DurationUtils;
import io.servicetalk.utils.internal.NumberUtils;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

abstract class AbstractSslConfigBuilder<T extends AbstractSslConfigBuilder<T>> {
    static final Duration DEFAULT_HANDSHAKE_TIMEOUT = Duration.ofSeconds(5L);
    private static final int DEFAULT_MAX_CERTIFICATE_LIST_BYTES = 32768;
    @Nullable
    private TrustManagerFactory trustManagerFactory;
    @Nullable
    private Supplier<InputStream> trustCertChainSupplier;
    @Nullable
    private KeyManagerFactory keyManagerFactory;
    @Nullable
    private Supplier<InputStream> keyCertChainSupplier;
    @Nullable
    private Supplier<InputStream> keySupplier;
    @Nullable
    private String keyPassword;
    @Nullable
    private List<String> sslProtocols;
    @Nullable
    private List<String> alpnProtocols;
    @Nullable
    private List<String> ciphers;
    private SslConfig.CipherSuiteFilter cipherSuiteFilter = SslConfig.CipherSuiteFilter.PROVIDED;
    private long sessionCacheSize;
    private long sessionTimeout;
    private int maxCertificateListBytes = 32768;
    @Nullable
    private SslProvider provider;
    @Nullable
    private List<CertificateCompressionAlgorithm> certificateCompressionAlgorithms;
    private Duration handshakeTimeout = DEFAULT_HANDSHAKE_TIMEOUT;

    AbstractSslConfigBuilder() {
    }

    public final T trustManager(TrustManagerFactory tmf) {
        this.trustManagerFactory = Objects.requireNonNull(tmf);
        this.trustCertChainSupplier = null;
        return this.thisT();
    }

    @Nullable
    final TrustManagerFactory trustManager() {
        return this.trustManagerFactory;
    }

    public final T trustManager(Supplier<InputStream> trustCertChainSupplier) {
        this.trustCertChainSupplier = Objects.requireNonNull(trustCertChainSupplier);
        this.trustManagerFactory = null;
        return this.thisT();
    }

    @Nullable
    final Supplier<InputStream> trustCertChainSupplier() {
        return this.trustCertChainSupplier;
    }

    public final T keyManager(KeyManagerFactory kmf) {
        this.keyManagerFactory = Objects.requireNonNull(kmf);
        this.keyCertChainSupplier = null;
        this.keySupplier = null;
        this.keyPassword = null;
        return this.thisT();
    }

    @Nullable
    final KeyManagerFactory keyManager() {
        return this.keyManagerFactory;
    }

    public final T keyManager(Supplier<InputStream> keyCertChainSupplier, Supplier<InputStream> keySupplier) {
        this.keyCertChainSupplier = Objects.requireNonNull(keyCertChainSupplier);
        this.keySupplier = Objects.requireNonNull(keySupplier);
        this.keyPassword = null;
        this.keyManagerFactory = null;
        return this.thisT();
    }

    public final T keyManager(Supplier<InputStream> keyCertChainSupplier, Supplier<InputStream> keySupplier, @Nullable String keyPassword) {
        this.keyCertChainSupplier = Objects.requireNonNull(keyCertChainSupplier);
        this.keySupplier = Objects.requireNonNull(keySupplier);
        this.keyPassword = keyPassword;
        this.keyManagerFactory = null;
        return this.thisT();
    }

    @Nullable
    final Supplier<InputStream> keyCertChainSupplier() {
        return this.keyCertChainSupplier;
    }

    @Nullable
    final Supplier<InputStream> keySupplier() {
        return this.keySupplier;
    }

    @Nullable
    final String keyPassword() {
        return this.keyPassword;
    }

    public final T sslProtocols(List<String> protocols) {
        if (protocols.isEmpty()) {
            throw new IllegalArgumentException("protocols cannot be empty");
        }
        this.sslProtocols = protocols;
        return this.thisT();
    }

    public final T sslProtocols(String ... protocols) {
        return this.sslProtocols(Arrays.asList(protocols));
    }

    @Nullable
    final List<String> sslProtocols() {
        return this.sslProtocols;
    }

    public final T alpnProtocols(List<String> protocols) {
        if (protocols.isEmpty()) {
            throw new IllegalArgumentException("protocols cannot be empty");
        }
        this.alpnProtocols = protocols;
        return this.thisT();
    }

    public final T alpnProtocols(String ... protocols) {
        return this.alpnProtocols(Arrays.asList(protocols));
    }

    @Nullable
    final List<String> alpnProtocols() {
        return this.alpnProtocols;
    }

    public final T ciphers(List<String> ciphers) {
        if (ciphers.isEmpty()) {
            throw new IllegalArgumentException("ciphers cannot be empty");
        }
        this.ciphers = ciphers;
        return this.thisT();
    }

    public final T ciphers(String ... ciphers) {
        return this.ciphers(Arrays.asList(ciphers));
    }

    @Nullable
    final List<String> ciphers() {
        return this.ciphers;
    }

    public final T cipherSuiteFilter(SslConfig.CipherSuiteFilter cipherSuiteFilter) {
        this.cipherSuiteFilter = Objects.requireNonNull(cipherSuiteFilter);
        return this.thisT();
    }

    final SslConfig.CipherSuiteFilter cipherSuiteFilter() {
        return this.cipherSuiteFilter;
    }

    public final T sessionCacheSize(long sessionCacheSize) {
        this.sessionCacheSize = NumberUtils.ensureNonNegative(sessionCacheSize, "sessionCacheSize");
        return this.thisT();
    }

    final long sessionCacheSize() {
        return this.sessionCacheSize;
    }

    public final T sessionTimeout(long sessionTimeout) {
        this.sessionTimeout = NumberUtils.ensureNonNegative(sessionTimeout, "sessionTimeout");
        return this.thisT();
    }

    final long sessionTimeout() {
        return this.sessionTimeout;
    }

    public final T provider(SslProvider provider) {
        this.provider = Objects.requireNonNull(provider);
        return this.thisT();
    }

    @Nullable
    final SslProvider provider() {
        return this.provider;
    }

    public final T certificateCompressionAlgorithms(List<CertificateCompressionAlgorithm> algorithms) {
        if (algorithms.isEmpty()) {
            throw new IllegalArgumentException("algorithms cannot be empty");
        }
        this.certificateCompressionAlgorithms = algorithms;
        return this.thisT();
    }

    public final T certificateCompressionAlgorithms(CertificateCompressionAlgorithm ... algorithms) {
        return this.certificateCompressionAlgorithms(Arrays.asList(algorithms));
    }

    @Nullable
    final List<CertificateCompressionAlgorithm> certificateCompressionAlgorithms() {
        return this.certificateCompressionAlgorithms;
    }

    public final T handshakeTimeout(Duration handshakeTimeout) {
        this.handshakeTimeout = DurationUtils.ensureNonNegative(handshakeTimeout, "handshakeTimeout");
        return this.thisT();
    }

    final Duration handshakeTimeout() {
        return this.handshakeTimeout;
    }

    public final T maxCertificateListBytes(int maxBytes) {
        this.maxCertificateListBytes = NumberUtils.ensureNonNegative(maxBytes, "maxBytes");
        return this.thisT();
    }

    final int maxCertificateListBytes() {
        return this.maxCertificateListBytes;
    }

    abstract T thisT();
}

