/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.tcp.netty.internal;

import io.netty.channel.ChannelOption;
import io.servicetalk.tcp.netty.internal.AbstractTcpConfig;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpServerConfig;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import io.servicetalk.transport.netty.internal.SocketOptionUtils;
import io.servicetalk.utils.internal.DurationUtils;
import java.net.SocketOption;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TcpServerConfig
extends AbstractTcpConfig {
    static final int MAX_CLIENT_HELLO_LENGTH = 0xFFFFFF;
    static final Duration DEFAULT_CLIENT_HELLO_TIMEOUT = Duration.ofSeconds(10L);
    static final boolean DEFAULT_ACCEPT_INSECURE_CONNECTIONS = false;
    @Nullable
    private Map<ChannelOption, Object> listenOptions;
    private TransportObserver transportObserver = NoopTransportObserver.INSTANCE;
    @Nullable
    private Map<String, ServerSslConfig> sniConfig;
    @Nullable
    private ServerSslConfig sslConfig;
    private int sniMaxClientHelloLength = 0xFFFFFF;
    private Duration sniClientHelloTimeout = DEFAULT_CLIENT_HELLO_TIMEOUT;
    private boolean acceptInsecureConnections;

    public TcpServerConfig() {
    }

    public TcpServerConfig(TcpServerConfig from) {
        super(from);
        this.sslConfig = from.sslConfig;
        this.listenOptions = from.listenOptions;
        this.transportObserver = from.transportObserver;
        this.sniConfig = from.sniConfig;
        this.sniMaxClientHelloLength = from.sniMaxClientHelloLength;
        this.sniClientHelloTimeout = from.sniClientHelloTimeout;
        this.acceptInsecureConnections = from.acceptInsecureConnections;
    }

    @Nullable
    Map<ChannelOption, Object> listenOptions() {
        return this.listenOptions;
    }

    TransportObserver transportObserver() {
        return this.transportObserver;
    }

    @Nullable
    public Map<String, ServerSslConfig> sniConfig() {
        return this.sniConfig;
    }

    public int sniMaxClientHelloLength() {
        return this.sniMaxClientHelloLength;
    }

    public Duration sniClientHelloTimeout() {
        return this.sniClientHelloTimeout;
    }

    public boolean acceptInsecureConnections() {
        return this.acceptInsecureConnections;
    }

    @Nullable
    public ServerSslConfig sslConfig() {
        return this.sslConfig;
    }

    public void transportObserver(TransportObserver transportObserver) {
        this.transportObserver = Objects.requireNonNull(transportObserver);
    }

    public TcpServerConfig sslConfig(@Nullable ServerSslConfig sslConfig) {
        return this.sslConfig(sslConfig, false);
    }

    public TcpServerConfig sslConfig(@Nullable ServerSslConfig config, boolean acceptInsecureConnections) {
        return this.sslConfig(config, null, 0xFFFFFF, DEFAULT_CLIENT_HELLO_TIMEOUT, acceptInsecureConnections);
    }

    public TcpServerConfig sslConfig(@Nullable ServerSslConfig defaultSslConfig, @Nullable Map<String, ServerSslConfig> sniConfig) {
        return this.sslConfig(defaultSslConfig, sniConfig, 0xFFFFFF, DEFAULT_CLIENT_HELLO_TIMEOUT);
    }

    public TcpServerConfig sslConfig(@Nullable ServerSslConfig defaultSslConfig, @Nullable Map<String, ServerSslConfig> sniConfig, int maxClientHelloLength, Duration clientHelloTimeout) {
        return this.sslConfig(defaultSslConfig, sniConfig, maxClientHelloLength, clientHelloTimeout, false);
    }

    public TcpServerConfig sslConfig(@Nullable ServerSslConfig defaultSslConfig, @Nullable Map<String, ServerSslConfig> sniConfig, int maxClientHelloLength, Duration clientHelloTimeout, boolean acceptInsecureConnections) {
        if (defaultSslConfig == null && sniConfig != null) {
            throw new IllegalArgumentException("If the defaultSslConfig is null (disabled), the sniConfig must also be null.");
        }
        if (maxClientHelloLength < 0 || maxClientHelloLength > 0xFFFFFF) {
            throw new IllegalArgumentException("maxClientHelloLength: " + maxClientHelloLength + "(expected [0, " + 0xFFFFFF + ']');
        }
        this.sslConfig = defaultSslConfig;
        this.sniConfig = sniConfig;
        this.sniMaxClientHelloLength = maxClientHelloLength;
        this.sniClientHelloTimeout = DurationUtils.ensureNonNegative(clientHelloTimeout, "clientHelloTimeout");
        this.acceptInsecureConnections = acceptInsecureConnections;
        return this;
    }

    public <T> void listenSocketOption(SocketOption<T> option, T value) {
        if (this.listenOptions == null) {
            this.listenOptions = new HashMap<ChannelOption, Object>();
        }
        SocketOptionUtils.addOption(this.listenOptions, option, value);
    }

    public ReadOnlyTcpServerConfig asReadOnly() {
        return new ReadOnlyTcpServerConfig(this);
    }
}

