/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.tcp.netty.internal;

import io.netty.handler.ssl.SslContext;
import io.servicetalk.tcp.netty.internal.AbstractReadOnlyTcpConfig;
import io.servicetalk.tcp.netty.internal.TcpClientConfig;
import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.api.DelegatingClientSslConfig;
import io.servicetalk.transport.netty.internal.SslContextFactory;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ReadOnlyTcpClientConfig
extends AbstractReadOnlyTcpConfig {
    @Nullable
    private final SslContext sslContext;
    @Nullable
    private final ClientSslConfig sslConfig;

    ReadOnlyTcpClientConfig(TcpClientConfig from) {
        super(from);
        this.sslConfig = from.sslConfig();
        this.sslContext = this.sslConfig == null ? null : SslContextFactory.forClient(this.sslConfig);
    }

    private ReadOnlyTcpClientConfig(ReadOnlyTcpClientConfig config, String peerHost, int peerPort, @Nullable String sniHostname, @Nullable String hostnameVerificationAlgorithm) {
        super(config);
        this.sslConfig = new PeerHostNameOverrideClientSslConfig(Objects.requireNonNull(config.sslConfig), peerHost, peerPort, sniHostname, hostnameVerificationAlgorithm);
        this.sslContext = config.sslContext;
    }

    @Override
    @Nullable
    public SslContext sslContext() {
        return this.sslContext;
    }

    @Nullable
    public String preferredAlpnProtocol() {
        if (this.sslConfig == null) {
            return null;
        }
        List<String> alpnProtocols = this.sslConfig.alpnProtocols();
        return alpnProtocols != null && !alpnProtocols.isEmpty() ? alpnProtocols.get(0) : null;
    }

    @Override
    @Nullable
    public ClientSslConfig sslConfig() {
        return this.sslConfig;
    }

    public ReadOnlyTcpClientConfig withSslConfigPeerHost(String peerHost, int peerPort, @Nullable String sniHostname, @Nullable String hostnameVerificationAlgorithm) {
        return new ReadOnlyTcpClientConfig(this, peerHost, peerPort, sniHostname, hostnameVerificationAlgorithm);
    }

    private static final class PeerHostNameOverrideClientSslConfig
    extends DelegatingClientSslConfig {
        private final String peerHost;
        private final int peerPort;
        @Nullable
        private final String sniHostname;
        @Nullable
        private final String hostnameVerificationAlgorithm;

        PeerHostNameOverrideClientSslConfig(ClientSslConfig delegate, String peerHost, int peerPort, @Nullable String sniHostname, @Nullable String hostnameVerificationAlgorithm) {
            super(delegate);
            this.peerHost = peerHost;
            this.peerPort = peerPort;
            this.sniHostname = sniHostname;
            this.hostnameVerificationAlgorithm = hostnameVerificationAlgorithm;
        }

        @Override
        public String peerHost() {
            return this.peerHost;
        }

        @Override
        public int peerPort() {
            return this.peerPort;
        }

        @Override
        public String sniHostname() {
            return this.sniHostname;
        }

        @Override
        public String hostnameVerificationAlgorithm() {
            return this.hostnameVerificationAlgorithm;
        }
    }
}

