/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.tcp.netty.internal;

import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContext;
import io.servicetalk.logging.api.UserDataLoggerConfig;
import io.servicetalk.tcp.netty.internal.AbstractTcpConfig;
import io.servicetalk.transport.api.SslConfig;
import io.servicetalk.transport.netty.internal.FlushStrategy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

abstract class AbstractReadOnlyTcpConfig {
    private final Map<ChannelOption, Object> options;
    private final long idleTimeoutMs;
    private final FlushStrategy flushStrategy;
    @Nullable
    private final UserDataLoggerConfig wireLoggerConfig;

    protected AbstractReadOnlyTcpConfig(AbstractTcpConfig from) {
        this.options = AbstractReadOnlyTcpConfig.nonNullOptions(from.options());
        this.idleTimeoutMs = from.idleTimeoutMs();
        this.flushStrategy = from.flushStrategy();
        this.wireLoggerConfig = from.wireLoggerConfig();
    }

    AbstractReadOnlyTcpConfig(AbstractReadOnlyTcpConfig from) {
        this.options = from.options();
        this.idleTimeoutMs = from.idleTimeoutMs();
        this.flushStrategy = from.flushStrategy();
        this.wireLoggerConfig = from.wireLoggerConfig();
    }

    static Map<ChannelOption, Object> nonNullOptions(@Nullable Map<ChannelOption, Object> options) {
        return options == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<ChannelOption, Object>(options));
    }

    public final Map<ChannelOption, Object> options() {
        return this.options;
    }

    public final long idleTimeoutMs() {
        return this.idleTimeoutMs;
    }

    public final FlushStrategy flushStrategy() {
        return this.flushStrategy;
    }

    @Nullable
    public final UserDataLoggerConfig wireLoggerConfig() {
        return this.wireLoggerConfig;
    }

    @Nullable
    public abstract SslContext sslContext();

    @Nullable
    public abstract SslConfig sslConfig();
}

