/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer.experimental;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.loadbalancer.LoadBalancingPolicies;
import io.servicetalk.loadbalancer.LoadBalancingPolicy;
import io.servicetalk.loadbalancer.OutlierDetectorConfig;
import io.servicetalk.loadbalancer.experimental.DefaultHttpLoadBalancerProvider;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultLoadBalancerProviderConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHttpLoadBalancerProvider.class);
    private static final String PROPERTY_PREFIX = "io.servicetalk.loadbalancer.experimental.";
    private static final String PROP_CLIENTS_ENABLED_FOR = "clientsEnabledFor";
    private static final String PROP_EWMA_ERROR_PENALTY = "ewmaErrorPenalty";
    private static final String PROP_EWMA_CANCELLATION_PENALTY = "ewmaCancellationPenalty";
    private static final String PROP_CANCELLATION_IS_ERROR = "cancellationIsError";
    private static final String PROP_FAILED_CONNECTIONS_THRESHOLD = "healthCheckFailedConnectionsThreshold";
    private static final String PROP_LOAD_BALANCING_POLICY = "policy";
    private static final String PROP_EWMA_HALF_LIFE_MS = "ewmaHalfLifeMs";
    private static final String PROP_CONSECUTIVE_5XX = "consecutive5xx";
    private static final String PROP_INTERVAL_MS = "intervalMs";
    private static final String PROP_BASE_EJECTION_TIME_MS = "baseEjectionTimeMs";
    private static final String PROP_MAX_EJECTION_PERCENT = "maxEjectionPercent";
    private static final String PROP_ENFORCING_CONSECUTIVE_5XX = "enforcingConsecutive5xx";
    private static final String PROP_ENFORCING_SUCCESS_RATE = "enforcingSuccessRate";
    private static final String PROP_SUCCESS_RATE_MIN_HOSTS = "successRateMinimumHosts";
    private static final String PROP_SUCCESS_RATE_REQUEST_VOL = "successRateRequestVolume";
    private static final String PROP_SUCCESS_RATE_STDEV_FACTOR = "successRateStdevFactor";
    private static final String PROP_FAILURE_PERCENTAGE_THRESHOLD = "failurePercentageThreshold";
    private static final String PROP_ENFORCING_FAILURE_PERCENTAGE = "enforcingFailurePercentage";
    private static final String PROP_FAILURE_PERCENTAGE_MIN_HOSTS = "failurePercentageMinimumHosts";
    private static final String PROP_FAILURE_PERCENTAGE_REQUEST_VOL = "failurePercentageRequestVolume";
    private static final String PROP_MAX_EJECTION_TIME_MS = "maxEjectionTimeMs";
    private static final String PROP_EJECTION_TIME_JITTER_MS = "ejectionTimeJitterMs";
    private final String rawClientsEnabledFor = DefaultLoadBalancerProviderConfig.getString("clientsEnabledFor", "").trim();
    private final Set<String> clientsEnabledFor = DefaultLoadBalancerProviderConfig.getClientsEnabledFor(this.rawClientsEnabledFor);
    private final int failedConnectionsThreshold = DefaultLoadBalancerProviderConfig.getInt("healthCheckFailedConnectionsThreshold", 5);
    private final LBPolicy lbPolicy = this.getLBPolicy();
    private final Duration ewmaHalfLife = Duration.ofMillis(DefaultLoadBalancerProviderConfig.getLong("ewmaHalfLifeMs", Duration.ofSeconds(10L).toMillis()));
    private final int ewmaErrorPenalty = DefaultLoadBalancerProviderConfig.getInt("ewmaErrorPenalty", 10);
    private final int ewmaCancellationPenalty = DefaultLoadBalancerProviderConfig.getInt("ewmaCancellationPenalty", 5);
    private final boolean cancellationIsError = DefaultLoadBalancerProviderConfig.getBool("cancellationIsError", true);
    private final int consecutive5xx = DefaultLoadBalancerProviderConfig.getInt("consecutive5xx", 5);
    private final Duration interval = Duration.ofMillis(DefaultLoadBalancerProviderConfig.getLong("intervalMs", Duration.ofSeconds(10L).toMillis()));
    private final Duration baseEjectionTime = Duration.ofMillis(DefaultLoadBalancerProviderConfig.getLong("baseEjectionTimeMs", Duration.ofSeconds(30L).toMillis()));
    private final int maxEjectionPercentage = DefaultLoadBalancerProviderConfig.getInt("maxEjectionPercent", 20);
    private final int enforcingConsecutive5xx = DefaultLoadBalancerProviderConfig.getInt("enforcingConsecutive5xx", 100);
    private final int enforcingSuccessRate = DefaultLoadBalancerProviderConfig.getInt("enforcingSuccessRate", 100);
    private final int successRateMinimumHosts = DefaultLoadBalancerProviderConfig.getInt("successRateMinimumHosts", 5);
    private final int successRateRequestVolume = DefaultLoadBalancerProviderConfig.getInt("successRateRequestVolume", 100);
    private final int successRateStdevFactor = DefaultLoadBalancerProviderConfig.getInt("successRateStdevFactor", 1900);
    private final int failurePercentageThreshold = DefaultLoadBalancerProviderConfig.getInt("failurePercentageThreshold", 85);
    private final int enforcingFailurePercentage = DefaultLoadBalancerProviderConfig.getInt("enforcingFailurePercentage", 0);
    private final int failurePercentageMinimumHosts = DefaultLoadBalancerProviderConfig.getInt("failurePercentageMinimumHosts", 5);
    private final int failurePercentageRequestVolume = DefaultLoadBalancerProviderConfig.getInt("failurePercentageRequestVolume", 50);
    private final Duration maxEjectionTime = Duration.ofMillis(DefaultLoadBalancerProviderConfig.getLong("maxEjectionTimeMs", Duration.ofSeconds(90L).toMillis()));
    private final Duration ejectionTimeJitter = Duration.ofMillis(DefaultLoadBalancerProviderConfig.getLong("ejectionTimeJitterMs", Duration.ZERO.toMillis()));

    private DefaultLoadBalancerProviderConfig() {
    }

    private LBPolicy getLBPolicy() {
        String configuredLbName = DefaultLoadBalancerProviderConfig.getString(PROP_LOAD_BALANCING_POLICY, LBPolicy.P2C.name());
        if (configuredLbName.equalsIgnoreCase(LBPolicy.P2C.name())) {
            return LBPolicy.P2C;
        }
        if (configuredLbName.equalsIgnoreCase(LBPolicy.RoundRobin.name())) {
            return LBPolicy.RoundRobin;
        }
        LOGGER.warn("Unrecognized load balancer policy name: {}. Defaulting to P2C.", (Object)configuredLbName);
        return LBPolicy.P2C;
    }

    <U, C extends LoadBalancedConnection> LoadBalancingPolicy<U, C> getLoadBalancingPolicy() {
        return this.lbPolicy == LBPolicy.P2C ? LoadBalancingPolicies.p2c().build() : LoadBalancingPolicies.roundRobin().build();
    }

    boolean enabledForServiceName(String serviceName) {
        return "*".equals(this.rawClientsEnabledFor) || this.clientsEnabledFor.contains(serviceName);
    }

    OutlierDetectorConfig outlierDetectorConfig() {
        return new OutlierDetectorConfig.Builder().failedConnectionsThreshold(this.failedConnectionsThreshold).ewmaHalfLife(this.ewmaHalfLife).ewmaErrorPenalty(this.ewmaErrorPenalty).ewmaCancellationPenalty(this.ewmaCancellationPenalty).cancellationIsError(this.cancellationIsError).consecutive5xx(this.consecutive5xx).failureDetectorInterval(this.interval).baseEjectionTime(this.baseEjectionTime).ejectionTimeJitter(this.ejectionTimeJitter).maxEjectionPercentage(this.maxEjectionPercentage).enforcingConsecutive5xx(this.enforcingConsecutive5xx).enforcingSuccessRate(this.enforcingSuccessRate).successRateMinimumHosts(this.successRateMinimumHosts).successRateRequestVolume(this.successRateRequestVolume).successRateStdevFactor(this.successRateStdevFactor).failurePercentageThreshold(this.failurePercentageThreshold).enforcingFailurePercentage(this.enforcingFailurePercentage).failurePercentageMinimumHosts(this.failurePercentageMinimumHosts).failurePercentageRequestVolume(this.failurePercentageRequestVolume).maxEjectionTime(this.maxEjectionTime).build();
    }

    public String toString() {
        return "ExperimentalOutlierDetectorConfig{clientsEnabledFor=" + this.rawClientsEnabledFor + ", failedConnectionsThreshold=" + this.failedConnectionsThreshold + ", lbPolicy=" + (Object)((Object)this.lbPolicy) + ", ewmaHalfLife=" + this.ewmaHalfLife + ", ewmaErrorPenalty=" + this.ewmaErrorPenalty + ", ewmaCancellationPenalty=" + this.ewmaCancellationPenalty + ", cancellationIsError=" + this.cancellationIsError + ", consecutive5xx=" + this.consecutive5xx + ", interval=" + this.interval + ", baseEjectionTime=" + this.baseEjectionTime + ", ejectionTimeJitter=" + this.ejectionTimeJitter + ", maxEjectionPercentage=" + this.maxEjectionPercentage + ", enforcingConsecutive5xx=" + this.enforcingConsecutive5xx + ", enforcingSuccessRate=" + this.enforcingSuccessRate + ", successRateMinimumHosts=" + this.successRateMinimumHosts + ", successRateRequestVolume=" + this.successRateRequestVolume + ", successRateStdevFactor=" + this.successRateStdevFactor + ", failurePercentageThreshold=" + this.failurePercentageThreshold + ", enforcingFailurePercentage=" + this.enforcingFailurePercentage + ", failurePercentageMinimumHosts=" + this.failurePercentageMinimumHosts + ", failurePercentageRequestVolume=" + this.failurePercentageRequestVolume + ", maxEjectionTime=" + this.maxEjectionTime + '}';
    }

    static DefaultLoadBalancerProviderConfig instance() {
        return new DefaultLoadBalancerProviderConfig();
    }

    private static String getString(String name, String defaultValue) {
        return System.getProperty(PROPERTY_PREFIX + name, defaultValue);
    }

    private static long getLong(String name, long defaultValue) {
        String propertyValue = System.getProperty(PROPERTY_PREFIX + name);
        if (propertyValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(propertyValue.trim());
        }
        catch (Exception ex) {
            LOGGER.warn("Exception parsing property {} with value {} to an integral value. Using the default of {}.", name, propertyValue, defaultValue, ex);
            return defaultValue;
        }
    }

    private static boolean getBool(String name, boolean defaultValue) {
        String stringValue = System.getProperty(PROPERTY_PREFIX + name);
        return stringValue == null ? defaultValue : Boolean.parseBoolean(stringValue);
    }

    private static int getInt(String name, int defaultValue) {
        long value = DefaultLoadBalancerProviderConfig.getLong(name, defaultValue);
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Integer overflow for value " + name + ": " + value);
        }
        return (int)value;
    }

    private static Set<String> getClientsEnabledFor(String propertyValue) {
        HashSet<String> result = new HashSet<String>();
        if (!"*".equals(propertyValue)) {
            for (String serviceName : propertyValue.split(",")) {
                String trimmed = serviceName.trim();
                if (trimmed.isEmpty()) continue;
                result.add(trimmed);
            }
        }
        return result;
    }

    private static enum LBPolicy {
        P2C,
        RoundRobin;

    }
}

