/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer.experimental;

import io.servicetalk.client.api.NoActiveHostException;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.loadbalancer.LoadBalancerObserver;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultLoadBalancerObserver
implements LoadBalancerObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLoadBalancerObserver.class);
    private final String lbDescription;

    DefaultLoadBalancerObserver(String lbDescription) {
        this.lbDescription = Objects.requireNonNull(lbDescription, "lbDescription");
    }

    @Override
    public LoadBalancerObserver.HostObserver hostObserver(Object resolvedAddress) {
        return new HostObserverImpl(resolvedAddress);
    }

    @Override
    public void onNoHostsAvailable() {
        LOGGER.debug("{}- onNoHostsAvailable()", (Object)this.lbDescription);
    }

    @Override
    public void onServiceDiscoveryEvent(Collection<? extends ServiceDiscovererEvent<?>> events, int oldHostSetSize, int newHostSetSize) {
        LOGGER.debug("{}- onServiceDiscoveryEvent(events: {}, oldHostSetSize: {}, newHostSetSize: {})", this.lbDescription, events, oldHostSetSize, newHostSetSize);
    }

    @Override
    public void onNoActiveHostsAvailable(int hostSetSize, NoActiveHostException exception) {
        LOGGER.debug("{}- No active hosts available. Host set size: {}.", this.lbDescription, hostSetSize, exception);
    }

    @Override
    public void onHostSetChanged(Collection<? extends LoadBalancerObserver.Host> newHosts) {
        if (LOGGER.isDebugEnabled()) {
            int healthyCount = 0;
            for (LoadBalancerObserver.Host host : newHosts) {
                if (!host.isHealthy()) continue;
                ++healthyCount;
            }
            LOGGER.debug("{}- onHostSetChanged(host set size: {}, healthy: {}). New hosts: {}", this.lbDescription, newHosts.size(), healthyCount, newHosts);
        }
    }

    private final class HostObserverImpl
    implements LoadBalancerObserver.HostObserver {
        private final Object resolvedAddress;

        HostObserverImpl(Object resolvedAddress) {
            this.resolvedAddress = resolvedAddress;
        }

        @Override
        public void onHostMarkedExpired(int connectionCount) {
            LOGGER.debug("{}:{}- onHostMarkedExpired(connectionCount: {})", DefaultLoadBalancerObserver.this.lbDescription, this.resolvedAddress, connectionCount);
        }

        @Override
        public void onActiveHostRemoved(int connectionCount) {
            LOGGER.debug("{}:{}- onActiveHostRemoved(connectionCount: {})", DefaultLoadBalancerObserver.this.lbDescription, this.resolvedAddress, connectionCount);
        }

        @Override
        public void onExpiredHostRevived(int connectionCount) {
            LOGGER.debug("{}:{}- onExpiredHostRevived(connectionCount: {})", DefaultLoadBalancerObserver.this.lbDescription, this.resolvedAddress, connectionCount);
        }

        @Override
        public void onExpiredHostRemoved(int connectionCount) {
            LOGGER.debug("{}:{}- onExpiredHostRemoved(connectionCount: {})", DefaultLoadBalancerObserver.this.lbDescription, this.resolvedAddress, connectionCount);
        }

        @Override
        public void onHostMarkedUnhealthy(@Nullable Throwable cause) {
            LOGGER.debug("{}:{}- onHostMarkedUnhealthy(ex)", DefaultLoadBalancerObserver.this.lbDescription, this.resolvedAddress, cause);
        }

        @Override
        public void onHostRevived() {
            LOGGER.debug("{}:{}- onHostRevived()", (Object)DefaultLoadBalancerObserver.this.lbDescription, this.resolvedAddress);
        }
    }
}

