/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer.experimental;

import io.servicetalk.client.api.LoadBalancerFactory;
import io.servicetalk.http.api.DefaultHttpLoadBalancerFactory;
import io.servicetalk.http.api.DelegatingSingleAddressHttpClientBuilder;
import io.servicetalk.http.api.FilterableStreamingHttpLoadBalancedConnection;
import io.servicetalk.http.api.HttpLoadBalancerFactory;
import io.servicetalk.http.api.HttpProviders;
import io.servicetalk.http.api.SingleAddressHttpClientBuilder;
import io.servicetalk.loadbalancer.LoadBalancers;
import io.servicetalk.loadbalancer.experimental.DefaultLoadBalancerObserver;
import io.servicetalk.loadbalancer.experimental.DefaultLoadBalancerProviderConfig;
import io.servicetalk.transport.api.HostAndPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpLoadBalancerProvider
implements HttpProviders.SingleAddressHttpClientBuilderProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHttpLoadBalancerProvider.class);

    @Override
    public final <U, R> SingleAddressHttpClientBuilder<U, R> newBuilder(U address, SingleAddressHttpClientBuilder<U, R> builder) {
        String serviceName = this.clientNameFromAddress(address);
        DefaultLoadBalancerProviderConfig config = DefaultLoadBalancerProviderConfig.instance();
        LOGGER.debug("Property based config for client to service name {} at address {}: {}", serviceName, address, config);
        if (config.enabledForServiceName(serviceName)) {
            try {
                DefaultHttpLoadBalancerFactory<R> loadBalancerFactory = new DefaultHttpLoadBalancerFactory<R>(this.defaultLoadBalancer(config));
                builder = builder.loadBalancerFactory(loadBalancerFactory);
                builder = new LoadBalancerIgnoringBuilder(builder, serviceName);
                LOGGER.info("Enabled DefaultLoadBalancer for service with name {}", (Object)serviceName);
            }
            catch (Throwable ex) {
                LOGGER.warn("Failed to enabled DefaultLoadBalancer for client to address {}.", (Object)address, (Object)ex);
            }
        }
        return builder;
    }

    private <R> LoadBalancerFactory<R, FilterableStreamingHttpLoadBalancedConnection> defaultLoadBalancer(DefaultLoadBalancerProviderConfig config) {
        return LoadBalancers.builder("experimental-load-balancer").loadBalancerObserver(DefaultLoadBalancerObserver::new).outlierDetectorConfig(config.outlierDetectorConfig()).loadBalancingPolicy(config.getLoadBalancingPolicy()).build();
    }

    protected <U> String clientNameFromAddress(U address) {
        String serviceName;
        if (address instanceof HostAndPort) {
            serviceName = ((HostAndPort)address).hostName();
        } else if (address instanceof String) {
            serviceName = (String)address;
        } else {
            LOGGER.debug("Unknown service address type={} was provided, default 'toString()' will be used as serviceName", (Object)address.getClass());
            serviceName = address.toString();
        }
        return serviceName;
    }

    public static final class LoadBalancerIgnoringBuilder<U, R>
    extends DelegatingSingleAddressHttpClientBuilder<U, R> {
        private final String serviceName;

        private LoadBalancerIgnoringBuilder(SingleAddressHttpClientBuilder<U, R> delegate, String serviceName) {
            super(delegate);
            this.serviceName = serviceName;
        }

        @Override
        public SingleAddressHttpClientBuilder<U, R> loadBalancerFactory(HttpLoadBalancerFactory<R> loadBalancerFactory) {
            LOGGER.info("Ignoring http load balancer factory of type {} for client to {} which has DefaultLoadBalancer enabled.", (Object)loadBalancerFactory.getClass(), (Object)this.serviceName);
            return this;
        }
    }
}

