/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Processors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.loadbalancer.FailurePercentageXdsOutlierDetectorAlgorithm;
import io.servicetalk.loadbalancer.HealthIndicator;
import io.servicetalk.loadbalancer.LoadBalancerObserver;
import io.servicetalk.loadbalancer.OutlierDetector;
import io.servicetalk.loadbalancer.OutlierDetectorConfig;
import io.servicetalk.loadbalancer.SequentialExecutor;
import io.servicetalk.loadbalancer.SuccessRateXdsOutlierDetectorAlgorithm;
import io.servicetalk.loadbalancer.XdsHealthIndicator;
import io.servicetalk.loadbalancer.XdsOutlierDetectorAlgorithm;
import io.servicetalk.utils.internal.RandomUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class XdsOutlierDetector<ResolvedAddress, C extends LoadBalancedConnection>
implements OutlierDetector<ResolvedAddress, C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XdsOutlierDetector.class);
    private final OutlierDetectorConfig outlierDetectorConfig;
    private final SequentialExecutor sequentialExecutor;
    private final Executor executor;
    private final String lbDescription;
    private final PublisherSource.Processor<Void, Void> healthStatusChangeProcessor = Processors.newPublisherProcessorDropHeadOnOverflow(1);
    private final Kernel kernel;
    private final AtomicInteger indicatorCount = new AtomicInteger();
    private final Set<XdsHealthIndicatorImpl> indicators = new HashSet<XdsHealthIndicatorImpl>();
    private int ejectedHostCount;

    XdsOutlierDetector(Executor executor, OutlierDetectorConfig outlierDetectorConfig, String lbDescription, SequentialExecutor.ExceptionHandler exceptionHandler) {
        this.sequentialExecutor = new SequentialExecutor(exceptionHandler);
        this.outlierDetectorConfig = Objects.requireNonNull(outlierDetectorConfig, "outlierDetectorConfig");
        this.executor = Objects.requireNonNull(executor, "executor");
        this.lbDescription = Objects.requireNonNull(lbDescription, "lbDescription");
        this.kernel = new Kernel(outlierDetectorConfig);
    }

    XdsOutlierDetector(Executor executor, OutlierDetectorConfig config, String lbDescription) {
        this(executor, config, lbDescription, uncaughtException -> LOGGER.error("{}: Uncaught exception in {}", lbDescription, XdsOutlierDetector.class.getSimpleName(), uncaughtException));
    }

    @Override
    public HealthIndicator<ResolvedAddress, C> newHealthIndicator(ResolvedAddress address, LoadBalancerObserver.HostObserver hostObserver) {
        XdsHealthIndicatorImpl result = new XdsHealthIndicatorImpl(address, this.kernel.config, hostObserver);
        this.sequentialExecutor.execute(() -> this.indicators.add(result));
        this.indicatorCount.incrementAndGet();
        return result;
    }

    @Override
    public void cancel() {
        this.kernel.cancel();
        this.sequentialExecutor.execute(() -> {
            ArrayList<XdsHealthIndicatorImpl> indicatorList = new ArrayList<XdsHealthIndicatorImpl>(this.indicators);
            for (XdsHealthIndicator xdsHealthIndicator : indicatorList) {
                xdsHealthIndicator.sequentialCancel();
            }
            assert (this.indicators.isEmpty());
            assert (this.indicatorCount.get() == 0);
            this.healthStatusChangeProcessor.onComplete();
        });
    }

    @Override
    public Publisher<Void> healthStatusChanged() {
        return SourceAdapters.fromSource(this.healthStatusChangeProcessor);
    }

    int ejectedHostCount() {
        return this.ejectedHostCount;
    }

    public String toString() {
        return "XdsOutlierDetector{lbDescription=" + this.lbDescription + ", outlierDetectorConfig=" + this.outlierDetectorConfig + ", executor=" + this.executor + '}';
    }

    private List<XdsOutlierDetectorAlgorithm<ResolvedAddress, C>> getAlgorithms(OutlierDetectorConfig config) {
        ArrayList<XdsOutlierDetectorAlgorithm<ResolvedAddress, C>> detectors = new ArrayList<XdsOutlierDetectorAlgorithm<ResolvedAddress, C>>(2);
        if (config.enforcingFailurePercentage() > 0) {
            detectors.add(new FailurePercentageXdsOutlierDetectorAlgorithm());
        }
        if (config.enforcingSuccessRate() > 0) {
            detectors.add(new SuccessRateXdsOutlierDetectorAlgorithm());
        }
        if (detectors.isEmpty()) {
            detectors.add(new AlwaysHealthyOutlierDetectorAlgorithm());
        }
        return detectors;
    }

    private static final class AlwaysHealthyOutlierDetectorAlgorithm<ResolvedAddress, C extends LoadBalancedConnection>
    implements XdsOutlierDetectorAlgorithm<ResolvedAddress, C> {
        private AlwaysHealthyOutlierDetectorAlgorithm() {
        }

        @Override
        public void detectOutliers(OutlierDetectorConfig config, Collection<? extends XdsHealthIndicator<ResolvedAddress, C>> indicators) {
            int unhealthy = 0;
            for (XdsHealthIndicator<ResolvedAddress, C> indicator : indicators) {
                boolean isHealthy = indicator.isHealthy();
                if (isHealthy) {
                    indicator.updateOutlierStatus(config, false);
                    continue;
                }
                ++unhealthy;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("NoopOutlierDetector found {} unhealthy instances out of a total of {}.", (Object)unhealthy, (Object)indicators.size());
            }
        }
    }

    private final class Kernel {
        private final SequentialCancellable cancellable;
        private final List<XdsOutlierDetectorAlgorithm<ResolvedAddress, C>> algorithms;
        private final OutlierDetectorConfig config;

        Kernel(OutlierDetectorConfig config) {
            this.config = Objects.requireNonNull(config, "config");
            this.algorithms = XdsOutlierDetector.this.getAlgorithms(config);
            this.cancellable = new SequentialCancellable(this.scheduleNextOutliersCheck(config));
        }

        public void cancel() {
            this.cancellable.cancel();
        }

        private Cancellable scheduleNextOutliersCheck(OutlierDetectorConfig currentConfig) {
            Runnable checkOutliers = () -> XdsOutlierDetector.this.sequentialExecutor.execute(this::sequentialCheckOutliers);
            long minIntervalNanos = currentConfig.failureDetectorInterval().toNanos() - currentConfig.failureDetectorIntervalJitter().toNanos();
            long maxIntervalNanos = FlowControlUtils.addWithOverflowProtection(currentConfig.failureDetectorInterval().toNanos(), currentConfig.failureDetectorIntervalJitter().toNanos());
            return XdsOutlierDetector.this.executor.schedule(checkOutliers, RandomUtils.nextLongInclusive(minIntervalNanos, maxIntervalNanos), TimeUnit.NANOSECONDS);
        }

        private void sequentialCheckOutliers() {
            assert (XdsOutlierDetector.this.sequentialExecutor.isCurrentThreadDraining());
            for (XdsOutlierDetectorAlgorithm outlierDetector : this.algorithms) {
                outlierDetector.detectOutliers(this.config, XdsOutlierDetector.this.indicators);
            }
            this.cancellable.nextCancellable(this.scheduleNextOutliersCheck(this.config));
            boolean emitChange = false;
            for (XdsHealthIndicatorImpl indicator : XdsOutlierDetector.this.indicators) {
                boolean currentlyIsHealthy = indicator.isHealthy();
                if (indicator.lastObservedHealthy == currentlyIsHealthy) continue;
                indicator.lastObservedHealthy = currentlyIsHealthy;
                emitChange = true;
            }
            if (emitChange) {
                LOGGER.debug("Health status change observed. Emitting event.");
                XdsOutlierDetector.this.healthStatusChangeProcessor.onNext(null);
            }
        }
    }

    private final class XdsHealthIndicatorImpl
    extends XdsHealthIndicator<ResolvedAddress, C> {
        private boolean lastObservedHealthy;

        XdsHealthIndicatorImpl(ResolvedAddress address, OutlierDetectorConfig outlierDetectorConfig, LoadBalancerObserver.HostObserver hostObserver) {
            super(XdsOutlierDetector.this.sequentialExecutor, XdsOutlierDetector.this.executor, outlierDetectorConfig.ewmaHalfLife(), outlierDetectorConfig.ewmaCancellationPenalty(), outlierDetectorConfig.ewmaErrorPenalty(), outlierDetectorConfig.concurrentRequestPenalty(), outlierDetectorConfig.cancellationIsError(), address, XdsOutlierDetector.this.lbDescription, hostObserver);
            this.lastObservedHealthy = true;
        }

        @Override
        protected OutlierDetectorConfig currentConfig() {
            return XdsOutlierDetector.this.kernel.config;
        }

        @Override
        public boolean tryEjectHost() {
            assert (XdsOutlierDetector.this.sequentialExecutor.isCurrentThreadDraining());
            int maxEjected = Math.max(1, XdsOutlierDetector.this.indicatorCount.get() * this.currentConfig().maxEjectionPercentage() / 100);
            if (XdsOutlierDetector.this.ejectedHostCount >= maxEjected) {
                return false;
            }
            XdsOutlierDetector.this.ejectedHostCount++;
            return true;
        }

        @Override
        public void hostRevived() {
            assert (XdsOutlierDetector.this.sequentialExecutor.isCurrentThreadDraining());
            XdsOutlierDetector.this.ejectedHostCount--;
        }

        @Override
        public void doCancel() {
            assert (XdsOutlierDetector.this.sequentialExecutor.isCurrentThreadDraining());
            if (XdsOutlierDetector.this.indicators.remove(this)) {
                XdsOutlierDetector.this.indicatorCount.decrementAndGet();
            }
        }
    }
}

