/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.loadbalancer.ConnectTracker;
import io.servicetalk.loadbalancer.DefaultRequestTracker;
import io.servicetalk.loadbalancer.HealthIndicator;
import io.servicetalk.loadbalancer.Host;
import io.servicetalk.loadbalancer.LoadBalancerObserver;
import io.servicetalk.loadbalancer.NormalizedTimeSourceExecutor;
import io.servicetalk.loadbalancer.OutlierDetectorConfig;
import io.servicetalk.loadbalancer.RequestTracker;
import io.servicetalk.loadbalancer.SequentialExecutor;
import io.servicetalk.utils.internal.NumberUtils;
import io.servicetalk.utils.internal.RandomUtils;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class XdsHealthIndicator<ResolvedAddress, C extends LoadBalancedConnection>
extends DefaultRequestTracker
implements HealthIndicator<ResolvedAddress, C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XdsHealthIndicator.class);
    private static final Throwable CONSECUTIVE_5XX_CAUSE = new EjectedCause("consecutive 5xx");
    private static final Throwable OUTLIER_DETECTOR_CAUSE = new EjectedCause("outlier detector");
    private final SequentialExecutor sequentialExecutor;
    private final Executor executor;
    private final LoadBalancerObserver.HostObserver hostObserver;
    private final boolean cancellationIsError;
    private final ResolvedAddress address;
    private final String lbDescription;
    private final AtomicInteger consecutive5xx = new AtomicInteger();
    private final AtomicLong successes = new AtomicLong();
    private final AtomicLong failures = new AtomicLong();
    @Nullable
    private Host<ResolvedAddress, C> host;
    private boolean cancelled;
    private int failureMultiplier;
    @Nullable
    private volatile Long evictedUntilNanos;

    XdsHealthIndicator(SequentialExecutor sequentialExecutor, Executor executor, Duration ewmaHalfLife, int cancellationPenalty, int errorPenalty, int pendingRequestPenalty, boolean cancellationIsError, ResolvedAddress address, String lbDescription, LoadBalancerObserver.HostObserver hostObserver) {
        super(Objects.requireNonNull(ewmaHalfLife, "ewmaHalfLife").toNanos(), NumberUtils.ensureNonNegative(cancellationPenalty, "cancellationPenalty"), NumberUtils.ensureNonNegative(errorPenalty, "errorPenalty"), NumberUtils.ensureNonNegative(pendingRequestPenalty, "pendingRequestPenalty"));
        this.cancellationIsError = cancellationIsError;
        this.sequentialExecutor = Objects.requireNonNull(sequentialExecutor, "sequentialExecutor");
        this.executor = Objects.requireNonNull(executor, "executor");
        assert (executor instanceof NormalizedTimeSourceExecutor);
        this.address = Objects.requireNonNull(address, "address");
        this.lbDescription = Objects.requireNonNull(lbDescription, "lbDescription");
        this.hostObserver = Objects.requireNonNull(hostObserver, "hostObserver");
    }

    protected abstract OutlierDetectorConfig currentConfig();

    protected abstract boolean tryEjectHost();

    protected abstract void hostRevived();

    protected abstract void doCancel();

    @Override
    protected final long currentTimeNanos() {
        return this.executor.currentTime(TimeUnit.NANOSECONDS);
    }

    @Override
    public final void setHost(Host<ResolvedAddress, C> host) {
        this.host = Objects.requireNonNull(host, "host");
    }

    @Override
    public final boolean isHealthy() {
        Long evictedUntilNanos = this.evictedUntilNanos;
        if (evictedUntilNanos == null) {
            return true;
        }
        if (evictedUntilNanos <= this.currentTimeNanos()) {
            this.sequentialExecutor.execute(() -> {
                Long innerEvictedUntilNanos = this.evictedUntilNanos;
                if (!this.cancelled && innerEvictedUntilNanos != null && innerEvictedUntilNanos <= this.currentTimeNanos()) {
                    this.sequentialRevive();
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public final void onRequestSuccess(long beforeStartTimeNs) {
        super.onRequestSuccess(beforeStartTimeNs);
        this.successes.incrementAndGet();
        this.consecutive5xx.set(0);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}-{}: observed request success", (Object)this.lbDescription, (Object)this.address);
        }
    }

    @Override
    public final void onRequestError(long beforeStartTimeNs, RequestTracker.ErrorClass errorClass) {
        super.onRequestError(beforeStartTimeNs, errorClass);
        this.doOnError(errorClass == RequestTracker.ErrorClass.CANCELLED);
    }

    @Override
    public long beforeConnectStart() {
        return this.currentTimeNanos();
    }

    @Override
    public void onConnectError(long beforeConnectStart, ConnectTracker.ErrorClass errorClass) {
        this.doOnError(errorClass == ConnectTracker.ErrorClass.CANCELLED);
    }

    @Override
    public void onConnectSuccess(long beforeConnectStart) {
    }

    private void doOnError(boolean isCancellation) {
        if (!this.cancellationIsError && isCancellation) {
            return;
        }
        this.failures.incrementAndGet();
        int consecutiveFailures = this.consecutive5xx.incrementAndGet();
        OutlierDetectorConfig localConfig = this.currentConfig();
        if (consecutiveFailures >= localConfig.consecutive5xx() && OutlierDetectorConfig.enforcing(localConfig.enforcingConsecutive5xx())) {
            this.sequentialExecutor.execute(() -> {
                if (!this.cancelled && this.evictedUntilNanos == null && this.sequentialTryEject(this.currentConfig(), CONSECUTIVE_5XX_CAUSE) && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{}-{}: observed error which did result in consecutive 5xx ejection. Consecutive 5xx: {}, limit: {}.", this.lbDescription, this.address, consecutiveFailures, localConfig.consecutive5xx());
                }
            });
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}-{}: observed error which didn't result in ejection. Consecutive 5xx: {}, limit: {}", this.lbDescription, this.address, consecutiveFailures, localConfig.consecutive5xx());
        }
    }

    public final void forceRevival() {
        assert (this.sequentialExecutor.isCurrentThreadDraining());
        if (!this.cancelled && this.evictedUntilNanos != null) {
            this.sequentialRevive();
        }
    }

    public final boolean updateOutlierStatus(OutlierDetectorConfig config, boolean isOutlier) {
        assert (this.sequentialExecutor.isCurrentThreadDraining());
        if (this.cancelled) {
            return false;
        }
        Long evictedUntilNanos = this.evictedUntilNanos;
        if (evictedUntilNanos != null) {
            if (evictedUntilNanos <= this.currentTimeNanos()) {
                this.sequentialRevive();
            }
            LOGGER.trace("{}-{}: markAsOutlier(..) resulted in host revival.", (Object)this.lbDescription, (Object)this.address);
            return false;
        }
        if (isOutlier) {
            boolean result = this.sequentialTryEject(config, OUTLIER_DETECTOR_CAUSE);
            if (result) {
                LOGGER.debug("{}-{}: markAsOutlier(isOutlier = true) resulted in ejection. Failure multiplier: {}.", this.lbDescription, this.address, this.failureMultiplier);
            } else {
                LOGGER.trace("{}-{}: markAsOutlier(isOutlier = true) did not result in ejection. Failure multiplier: {}.", this.lbDescription, this.address, this.failureMultiplier);
            }
            return result;
        }
        this.failureMultiplier = Math.max(0, this.failureMultiplier - 1);
        LOGGER.trace("{}-{}: markAsOutlier(isOutlier = false). Failure multiplier: {}", this.lbDescription, this.address, this.failureMultiplier);
        return false;
    }

    public final void resetCounters() {
        this.successes.set(0L);
        this.failures.set(0L);
    }

    public final long getSuccesses() {
        return this.successes.get();
    }

    public final long getFailures() {
        return this.failures.get();
    }

    @Override
    public final void cancel() {
        this.sequentialExecutor.execute(this::sequentialCancel);
    }

    void sequentialCancel() {
        assert (this.sequentialExecutor.isCurrentThreadDraining());
        if (this.cancelled) {
            return;
        }
        if (this.evictedUntilNanos != null) {
            this.sequentialRevive();
        }
        this.cancelled = true;
        this.doCancel();
    }

    private boolean sequentialTryEject(OutlierDetectorConfig config, Throwable cause) {
        assert (this.sequentialExecutor.isCurrentThreadDraining());
        assert (this.evictedUntilNanos == null);
        if (!this.tryEjectHost()) {
            return false;
        }
        long baseEjectNanos = config.baseEjectionTime().toNanos();
        long ejectTimeNanos = baseEjectNanos * (long)(1 + this.failureMultiplier);
        if (ejectTimeNanos >= config.maxEjectionTime().toNanos()) {
            ejectTimeNanos = config.maxEjectionTime().toNanos();
        } else {
            ++this.failureMultiplier;
        }
        long jitterNanos = RandomUtils.nextLongInclusive(config.ejectionTimeJitter().toNanos());
        this.evictedUntilNanos = this.currentTimeNanos() + ejectTimeNanos + jitterNanos;
        this.hostObserver.onHostMarkedUnhealthy(cause);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}-{}: ejecting indicator for {} milliseconds", this.lbDescription, this.address, (ejectTimeNanos + jitterNanos) / 1000000L);
        }
        return true;
    }

    private void sequentialRevive() {
        assert (this.sequentialExecutor.isCurrentThreadDraining());
        assert (!this.cancelled);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}-{}: host revived", (Object)this.lbDescription, (Object)this.address);
        }
        this.evictedUntilNanos = null;
        this.hostRevived();
        this.hostObserver.onHostRevived();
    }

    private static final class EjectedCause
    extends Exception {
        private static final long serialVersionUID = 7474789866778792264L;

        EjectedCause(String reason) {
            super(reason);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

