/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.loadbalancer.OutlierDetectorConfig;
import io.servicetalk.loadbalancer.XdsHealthIndicator;
import io.servicetalk.loadbalancer.XdsOutlierDetectorAlgorithm;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SuccessRateXdsOutlierDetectorAlgorithm<ResolvedAddress, C extends LoadBalancedConnection>
implements XdsOutlierDetectorAlgorithm<ResolvedAddress, C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SuccessRateXdsOutlierDetectorAlgorithm.class);
    private static final double NOT_EVALUATED = Double.MAX_VALUE;

    SuccessRateXdsOutlierDetectorAlgorithm() {
    }

    @Override
    public void detectOutliers(OutlierDetectorConfig config, Collection<? extends XdsHealthIndicator<ResolvedAddress, C>> indicators) {
        LOGGER.debug("Started outlier detection.");
        double[] successRates = new double[indicators.size()];
        int i = 0;
        int enoughVolumeHosts = 0;
        int alreadyEjectedHosts = 0;
        for (XdsHealthIndicator<ResolvedAddress, C> indicator : indicators) {
            if (!indicator.isHealthy()) {
                successRates[i] = Double.MAX_VALUE;
                ++alreadyEjectedHosts;
            } else {
                long failures;
                long successes = indicator.getSuccesses();
                long totalRequests = successes + (failures = indicator.getFailures());
                if (totalRequests >= (long)config.successRateRequestVolume()) {
                    ++enoughVolumeHosts;
                }
                successRates[i] = totalRequests > 0L ? (double)successes / (double)totalRequests : 1.0;
            }
            ++i;
            indicator.resetCounters();
        }
        if (enoughVolumeHosts < config.successRateMinimumHosts()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Not enough hosts  with sufficient volume to perform ejection: {} total hosts and {} had sufficient volume. Minimum {} required.", indicators.size(), enoughVolumeHosts, config.successRateMinimumHosts());
            }
            return;
        }
        double mean = this.mean(successRates);
        double stdev = this.stdev(successRates, mean);
        double requiredSuccessRate = mean - stdev * ((double)config.successRateStdevFactor() / 1000.0);
        int ejectedCount = 0;
        i = 0;
        for (XdsHealthIndicator<ResolvedAddress, C> indicator : indicators) {
            double successRate;
            if (!indicator.updateOutlierStatus(config, (successRate = successRates[i++]) == Double.MAX_VALUE || successRate < requiredSuccessRate && OutlierDetectorConfig.enforcing(config.enforcingSuccessRate()))) continue;
            ++ejectedCount;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished host ejection. of {} total hosts {} hosts were already ejected and {} were newly ejected.", indicators.size(), alreadyEjectedHosts, ejectedCount);
        }
    }

    private double mean(double[] values) {
        double result = 0.0;
        int count = 0;
        for (double l : values) {
            if (l == Double.MAX_VALUE) continue;
            result += l;
            ++count;
        }
        return (double)count > 0.0 ? result / (double)count : 1.0;
    }

    private double stdev(double[] values, double mean) {
        double accumulator = 0.0;
        int count = 0;
        for (double value : values) {
            if (value == Double.MAX_VALUE) continue;
            double diff = value - mean;
            accumulator += diff * diff;
            ++count;
        }
        double variance = count > 0 ? accumulator / (double)count : 0.0;
        return Math.sqrt(variance);
    }
}

