/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.concurrent.api.AsyncContext;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

final class SequentialExecutor
implements Executor {
    private final ExceptionHandler exceptionHandler;
    private final AtomicReference<Cell> tail = new AtomicReference();
    @Nullable
    private Thread currentDrainingThread;

    SequentialExecutor(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler, "exceptionHandler");
    }

    public boolean isCurrentThreadDraining() {
        return this.currentDrainingThread != null && this.currentDrainingThread == Thread.currentThread();
    }

    @Override
    public void execute(Runnable command) {
        Cell next = new Cell(command = AsyncContext.wrapRunnable(Objects.requireNonNull(command, "command")));
        Cell prev = this.tail.getAndSet(next);
        if (prev != null) {
            prev.next = next;
        } else {
            this.drain(next);
        }
    }

    private void drain(Cell next) {
        Thread thisThread;
        this.currentDrainingThread = thisThread = Thread.currentThread();
        while (true) {
            try {
                next.runnable.run();
            }
            catch (Throwable ex) {
                this.exceptionHandler.onException(ex);
            }
            Cell n = next.next;
            if (n == null) {
                this.currentDrainingThread = null;
                if (this.tail.compareAndSet(next, null)) break;
                this.currentDrainingThread = thisThread;
                while ((n = next.next) == null) {
                    Thread.yield();
                }
            }
            next = n;
        }
    }

    private static final class Cell {
        final Runnable runnable;
        @Nullable
        volatile Cell next;

        Cell(Runnable runnable) {
            this.runnable = runnable;
        }
    }

    @FunctionalInterface
    static interface ExceptionHandler {
        public void onException(Throwable var1);
    }
}

