/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.client.api.LoadBalancerFactory;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.loadbalancer.ConnectionPoolConfig;
import io.servicetalk.loadbalancer.HealthCheckConfig;
import io.servicetalk.loadbalancer.LoadBalancerBuilder;
import io.servicetalk.loadbalancer.LoadBalancers;
import io.servicetalk.loadbalancer.LoadBalancingPolicies;
import io.servicetalk.loadbalancer.LoadBalancingPolicy;
import io.servicetalk.loadbalancer.OutlierDetectorConfig;
import io.servicetalk.loadbalancer.RoundRobinLoadBalancerBuilder;
import io.servicetalk.loadbalancer.RoundRobinLoadBalancerBuilderProvider;
import io.servicetalk.utils.internal.NumberUtils;
import java.time.Duration;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoundRobinToDefaultLBMigrationProvider
implements RoundRobinLoadBalancerBuilderProvider {
    static final String PROPERTY_NAME = "io.servicetalk.loadbalancer.roundRobinUsesDefaultLoadBalancer";
    private static final Logger LOGGER = LoggerFactory.getLogger(RoundRobinToDefaultLBMigrationProvider.class);

    @Override
    public <ResolvedAddress, C extends LoadBalancedConnection> RoundRobinLoadBalancerBuilder<ResolvedAddress, C> newBuilder(String id, RoundRobinLoadBalancerBuilder<ResolvedAddress, C> builder) {
        if (RoundRobinToDefaultLBMigrationProvider.isEnabled()) {
            LOGGER.info("Enabling DefaultLoadBalancer in place of RoundRobinLoadBalancer for load balancer id {}", (Object)id);
            return new DefaultLoadBalancerRoundRobinBuilder(id);
        }
        LOGGER.debug("Not enabling DefaultLoadBalancer in place of RoundRobinLoadBalancer for load balancer id {}", (Object)id);
        return builder;
    }

    private static boolean isEnabled() {
        return Boolean.getBoolean(PROPERTY_NAME);
    }

    private static final class DefaultLoadBalancerRoundRobinBuilder<ResolvedAddress, C extends LoadBalancedConnection>
    implements RoundRobinLoadBalancerBuilder<ResolvedAddress, C> {
        private final String id;
        private int linearSearchSpace = 16;
        @Nullable
        private Executor backgroundExecutor;
        private Duration healthCheckInterval = HealthCheckConfig.DEFAULT_HEALTH_CHECK_INTERVAL;
        private Duration healthCheckJitter = HealthCheckConfig.DEFAULT_HEALTH_CHECK_JITTER;
        private int healthCheckFailedConnectionsThreshold = 5;
        private Duration healthCheckResubscribeInterval = HealthCheckConfig.DEFAULT_HEALTH_CHECK_RESUBSCRIBE_INTERVAL;
        private Duration healthCheckResubscribeJitter = HealthCheckConfig.DEFAULT_HEALTH_CHECK_JITTER;

        DefaultLoadBalancerRoundRobinBuilder(String id) {
            this.id = id;
        }

        @Override
        public RoundRobinLoadBalancerBuilder<ResolvedAddress, C> linearSearchSpace(int linearSearchSpace) {
            this.linearSearchSpace = NumberUtils.ensureNonNegative(linearSearchSpace, "linearSearchSpace");
            return this;
        }

        @Override
        public RoundRobinLoadBalancerBuilder<ResolvedAddress, C> backgroundExecutor(Executor backgroundExecutor) {
            this.backgroundExecutor = backgroundExecutor;
            return this;
        }

        @Override
        public RoundRobinLoadBalancerBuilder<ResolvedAddress, C> healthCheckInterval(Duration interval, Duration jitter) {
            HealthCheckConfig.validateHealthCheckIntervals(interval, jitter);
            this.healthCheckInterval = interval;
            this.healthCheckJitter = jitter;
            return this;
        }

        @Override
        public RoundRobinLoadBalancerBuilder<ResolvedAddress, C> healthCheckResubscribeInterval(Duration interval, Duration jitter) {
            HealthCheckConfig.validateHealthCheckIntervals(interval, jitter);
            this.healthCheckResubscribeInterval = interval;
            this.healthCheckResubscribeJitter = jitter;
            return this;
        }

        @Override
        public RoundRobinLoadBalancerBuilder<ResolvedAddress, C> healthCheckFailedConnectionsThreshold(int threshold) {
            if (threshold == 0) {
                throw new IllegalArgumentException("Health check failed connections threshold should not be 0");
            }
            this.healthCheckFailedConnectionsThreshold = threshold;
            return this;
        }

        @Override
        public LoadBalancerFactory<ResolvedAddress, C> build() {
            OutlierDetectorConfig outlierDetectorConfig = new OutlierDetectorConfig.Builder().enforcingFailurePercentage(0).enforcingSuccessRate(0).enforcingConsecutive5xx(0).failedConnectionsThreshold(this.healthCheckFailedConnectionsThreshold).failureDetectorInterval(this.healthCheckInterval, this.healthCheckJitter).serviceDiscoveryResubscribeInterval(this.healthCheckResubscribeInterval, this.healthCheckResubscribeJitter).build();
            LoadBalancingPolicy loadBalancingPolicy = LoadBalancingPolicies.roundRobin().failOpen(false).ignoreWeights(true).build();
            LoadBalancerBuilder builder = LoadBalancers.builder(this.id);
            if (this.backgroundExecutor != null) {
                builder = builder.backgroundExecutor(this.backgroundExecutor);
            }
            return builder.outlierDetectorConfig(outlierDetectorConfig).loadBalancingPolicy(loadBalancingPolicy).connectionPoolConfig(ConnectionPoolConfig.linearSearch(this.linearSearchSpace)).build();
        }
    }
}

