/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.loadbalancer.BaseHostSelector;
import io.servicetalk.loadbalancer.Host;
import io.servicetalk.loadbalancer.HostSelector;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class RoundRobinSelector<ResolvedAddress, C extends LoadBalancedConnection>
extends BaseHostSelector<ResolvedAddress, C> {
    private static final int MAX_WEIGHT = 65535;
    private final AtomicInteger index;
    private final Scheduler scheduler;
    private final boolean failOpen;
    private final boolean ignoreWeights;

    RoundRobinSelector(List<? extends Host<ResolvedAddress, C>> hosts, String lbDescription, boolean failOpen, boolean ignoreWeights) {
        this(new AtomicInteger(), hosts, lbDescription, failOpen, ignoreWeights);
    }

    private RoundRobinSelector(AtomicInteger index, List<? extends Host<ResolvedAddress, C>> hosts, String targetResource, boolean failOpen, boolean ignoreWeights) {
        super(hosts, targetResource);
        this.index = index;
        this.scheduler = ignoreWeights ? new ConstantScheduler(index, hosts.size()) : RoundRobinSelector.buildScheduler(index, this.hosts());
        this.failOpen = failOpen;
        this.ignoreWeights = ignoreWeights;
    }

    @Override
    protected Single<C> selectConnection0(Predicate<C> selector, @Nullable ContextMap context, boolean forceNewConnectionAndReserve) {
        Single<C> result;
        int cursor = this.scheduler.nextHost();
        Host failOpenHost = null;
        for (int i = 0; i < this.hosts().size(); ++i) {
            Single result2;
            int localCursor = (cursor + i) % this.hosts().size();
            Host host = this.hosts().get(localCursor);
            if (host.isHealthy() && (result2 = this.selectFromHost(host, selector, forceNewConnectionAndReserve, context)) != null) {
                return result2;
            }
            if (!this.failOpen || failOpenHost != null || !host.canMakeNewConnections()) continue;
            failOpenHost = host;
        }
        if (failOpenHost != null && (result = this.selectFromHost(failOpenHost, selector, forceNewConnectionAndReserve, context)) != null) {
            return result;
        }
        return this.noActiveHostsFailure(this.hosts());
    }

    @Override
    public HostSelector<ResolvedAddress, C> rebuildWithHosts(@Nonnull List<? extends Host<ResolvedAddress, C>> hosts) {
        return new RoundRobinSelector<ResolvedAddress, C>(this.index, hosts, this.lbDescription(), this.failOpen, this.ignoreWeights);
    }

    private static Scheduler buildScheduler(AtomicInteger index, List<? extends Host<?, ?>> hosts) {
        boolean allEqualWeights = true;
        double maxWeight = 0.0;
        for (Host<?, ?> host : hosts) {
            double hostWeight = host.weight();
            maxWeight = Math.max(maxWeight, hostWeight);
            allEqualWeights = allEqualWeights && RoundRobinSelector.approxEqual(hosts.get(0).weight(), hostWeight);
        }
        if (allEqualWeights) {
            return new ConstantScheduler(index, hosts.size());
        }
        double scaleFactor = 65535.0 / maxWeight;
        int[] scaledWeights = new int[hosts.size()];
        for (int i = 0; i < scaledWeights.length; ++i) {
            scaledWeights[i] = Math.min(65535, (int)Math.ceil(hosts.get(i).weight() * scaleFactor));
        }
        return new StrideScheduler(index, scaledWeights);
    }

    private static final class StrideScheduler
    extends Scheduler {
        private final AtomicInteger index;
        private final int[] weights;

        StrideScheduler(AtomicInteger index, int[] weights) {
            this.index = index;
            this.weights = weights;
        }

        @Override
        int nextHost() {
            int offset;
            long pass;
            long counter;
            int i;
            while (((long)this.weights[i = (int)(counter = Integer.toUnsignedLong(this.index.getAndIncrement())) % this.weights.length] * (pass = counter / (long)this.weights.length) + (long)(offset = Short.MAX_VALUE * i)) % 65535L < (long)(65535 - this.weights[i])) {
            }
            return i;
        }
    }

    private static final class ConstantScheduler
    extends Scheduler {
        private final AtomicInteger index;
        private final int hostsSize;

        ConstantScheduler(AtomicInteger index, int hostsSize) {
            this.index = index;
            this.hostsSize = hostsSize;
        }

        @Override
        int nextHost() {
            return (int)(Integer.toUnsignedLong(this.index.getAndIncrement()) % (long)this.hostsSize);
        }
    }

    private static abstract class Scheduler {
        private Scheduler() {
        }

        abstract int nextHost();
    }
}

