/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.loadbalancer.Host;
import io.servicetalk.loadbalancer.HostSelector;
import io.servicetalk.loadbalancer.LoadBalancingPolicy;
import io.servicetalk.loadbalancer.RoundRobinSelector;
import java.util.List;

final class RoundRobinLoadBalancingPolicy<ResolvedAddress, C extends LoadBalancedConnection>
extends LoadBalancingPolicy<ResolvedAddress, C> {
    private final boolean failOpen;
    private final boolean ignoreWeights;

    RoundRobinLoadBalancingPolicy(boolean failOpen, boolean ignoreWeights) {
        this.failOpen = failOpen;
        this.ignoreWeights = ignoreWeights;
    }

    @Override
    HostSelector<ResolvedAddress, C> buildSelector(List<Host<ResolvedAddress, C>> hosts, String lbDescription) {
        return new RoundRobinSelector<ResolvedAddress, C>(hosts, lbDescription, this.failOpen, this.ignoreWeights);
    }

    @Override
    public String name() {
        return "RoundRobin";
    }

    @Override
    public String toString() {
        return "RoundRobinLoadBalancingPolicy{failOpen=" + this.failOpen + ", ignoreWeights=" + this.ignoreWeights + '}';
    }
}

