/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.client.api.LoadBalancer;
import io.servicetalk.client.api.LoadBalancerFactory;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.api.DefaultThreadFactory;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.loadbalancer.HealthCheckConfig;
import io.servicetalk.loadbalancer.NormalizedTimeSourceExecutor;
import io.servicetalk.loadbalancer.RoundRobinLoadBalancer;
import io.servicetalk.loadbalancer.RoundRobinLoadBalancerBuilder;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.utils.internal.NumberUtils;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@Deprecated
public final class RoundRobinLoadBalancerFactory<ResolvedAddress, C extends LoadBalancedConnection>
implements LoadBalancerFactory<ResolvedAddress, C> {
    private final String id;
    private final int linearSearchSpace;
    @Nullable
    private final HealthCheckConfig healthCheckConfig;

    private RoundRobinLoadBalancerFactory(String id, int linearSearchSpace, @Nullable HealthCheckConfig healthCheckConfig) {
        this.id = id;
        this.linearSearchSpace = linearSearchSpace;
        this.healthCheckConfig = healthCheckConfig;
    }

    @Override
    @Deprecated
    public <T extends C> LoadBalancer<T> newLoadBalancer(String targetResource, Publisher<? extends Collection<? extends ServiceDiscovererEvent<ResolvedAddress>>> eventPublisher, ConnectionFactory<ResolvedAddress, T> connectionFactory) {
        return new RoundRobinLoadBalancer<ResolvedAddress, T>(this.id, targetResource, eventPublisher, connectionFactory, this.linearSearchSpace, this.healthCheckConfig);
    }

    @Override
    public LoadBalancer<C> newLoadBalancer(Publisher<? extends Collection<? extends ServiceDiscovererEvent<ResolvedAddress>>> eventPublisher, ConnectionFactory<ResolvedAddress, C> connectionFactory, String targetResource) {
        return new RoundRobinLoadBalancer<ResolvedAddress, C>(this.id, targetResource, eventPublisher, connectionFactory, this.linearSearchSpace, this.healthCheckConfig);
    }

    @Override
    public ExecutionStrategy requiredOffloads() {
        return ExecutionStrategy.offloadNone();
    }

    public String toString() {
        return "RoundRobinLoadBalancerFactory{id='" + this.id + '\'' + ", linearSearchSpace=" + this.linearSearchSpace + ", healthCheckConfig=" + this.healthCheckConfig + '}';
    }

    static final class SharedExecutor {
        private static final Executor INSTANCE = new NormalizedTimeSourceExecutor(Executors.from(new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory("round-robin-load-balancer-executor"))));

        private SharedExecutor() {
        }

        static Executor getInstance() {
            return INSTANCE;
        }
    }

    @Deprecated
    public static final class Builder<ResolvedAddress, C extends LoadBalancedConnection>
    implements RoundRobinLoadBalancerBuilder<ResolvedAddress, C> {
        private final String id;
        private int linearSearchSpace = 16;
        @Nullable
        private Executor backgroundExecutor;
        private Duration healthCheckInterval = HealthCheckConfig.DEFAULT_HEALTH_CHECK_INTERVAL;
        private Duration healthCheckJitter = HealthCheckConfig.DEFAULT_HEALTH_CHECK_JITTER;
        private int healthCheckFailedConnectionsThreshold = 5;
        private Duration healthCheckResubscribeInterval = HealthCheckConfig.DEFAULT_HEALTH_CHECK_RESUBSCRIBE_INTERVAL;
        private Duration healthCheckResubscribeJitter = HealthCheckConfig.DEFAULT_HEALTH_CHECK_JITTER;

        @Deprecated
        public Builder() {
            this("undefined");
        }

        Builder(String id) {
            if (id.isEmpty()) {
                throw new IllegalArgumentException("ID can not be empty");
            }
            this.id = id;
        }

        @Override
        public Builder<ResolvedAddress, C> linearSearchSpace(int linearSearchSpace) {
            this.linearSearchSpace = NumberUtils.ensureNonNegative(linearSearchSpace, "linearSearchSpace");
            return this;
        }

        @Override
        public Builder<ResolvedAddress, C> backgroundExecutor(Executor backgroundExecutor) {
            this.backgroundExecutor = new NormalizedTimeSourceExecutor(backgroundExecutor);
            return this;
        }

        @Deprecated
        public Builder<ResolvedAddress, C> healthCheckInterval(Duration interval) {
            return this.healthCheckInterval(interval, interval.compareTo(HealthCheckConfig.DEFAULT_HEALTH_CHECK_INTERVAL) < 0 ? interval.dividedBy(2L) : HealthCheckConfig.DEFAULT_HEALTH_CHECK_JITTER);
        }

        @Override
        public Builder<ResolvedAddress, C> healthCheckInterval(Duration interval, Duration jitter) {
            HealthCheckConfig.validateHealthCheckIntervals(interval, jitter);
            this.healthCheckInterval = interval;
            this.healthCheckJitter = jitter;
            return this;
        }

        @Override
        public Builder<ResolvedAddress, C> healthCheckResubscribeInterval(Duration interval, Duration jitter) {
            HealthCheckConfig.validateHealthCheckIntervals(interval, jitter);
            this.healthCheckResubscribeInterval = interval;
            this.healthCheckResubscribeJitter = jitter;
            return this;
        }

        @Override
        public Builder<ResolvedAddress, C> healthCheckFailedConnectionsThreshold(int threshold) {
            if (threshold == 0) {
                throw new IllegalArgumentException("Health check failed connections threshold should not be 0");
            }
            this.healthCheckFailedConnectionsThreshold = threshold;
            return this;
        }

        @Override
        public RoundRobinLoadBalancerFactory<ResolvedAddress, C> build() {
            if (this.healthCheckFailedConnectionsThreshold < 0) {
                return new RoundRobinLoadBalancerFactory(this.id, this.linearSearchSpace, null);
            }
            HealthCheckConfig healthCheckConfig = new HealthCheckConfig(this.backgroundExecutor == null ? SharedExecutor.getInstance() : this.backgroundExecutor, this.healthCheckInterval, this.healthCheckJitter, this.healthCheckFailedConnectionsThreshold, this.healthCheckResubscribeInterval, this.healthCheckResubscribeJitter);
            return new RoundRobinLoadBalancerFactory(this.id, this.linearSearchSpace, healthCheckConfig);
        }
    }
}

