/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.utils.internal.NumberUtils;
import java.util.Objects;

public final class RichServiceDiscovererEvent<ResolvedAddress>
implements ServiceDiscovererEvent<ResolvedAddress> {
    private final ResolvedAddress address;
    private final ServiceDiscovererEvent.Status status;
    private final double weight;
    private final int priority;

    public RichServiceDiscovererEvent(ResolvedAddress address, ServiceDiscovererEvent.Status status, double weight, int priority) {
        if (weight < 0.0) {
            throw new IllegalArgumentException("Illegal weight: " + weight);
        }
        this.address = Objects.requireNonNull(address, "address");
        this.status = Objects.requireNonNull(status, "status");
        this.weight = weight;
        this.priority = NumberUtils.ensureNonNegative(priority, "priority");
    }

    @Override
    public ResolvedAddress address() {
        return this.address;
    }

    @Override
    public ServiceDiscovererEvent.Status status() {
        return this.status;
    }

    public double loadBalancingWeight() {
        return this.weight;
    }

    public int priority() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RichServiceDiscovererEvent that = (RichServiceDiscovererEvent)o;
        return Double.compare(that.weight, this.weight) == 0 && this.priority == that.priority && this.address.equals(that.address) && this.status.equals(that.status);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.status, this.weight, this.priority);
    }

    public String toString() {
        return "RichServiceDiscovererEvent{address=" + this.address + ", status=" + this.status + ", weight=" + this.weight + ", priority=" + this.priority + '}';
    }
}

