/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.loadbalancer.BaseHostSelector;
import io.servicetalk.loadbalancer.Host;
import io.servicetalk.loadbalancer.HostSelector;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class P2CSelector<ResolvedAddress, C extends LoadBalancedConnection>
extends BaseHostSelector<ResolvedAddress, C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(P2CSelector.class);
    private static final EntrySelector EMPTY_SELECTOR = new EqualWeightEntrySelector(0);
    @Nullable
    private final Random random;
    private final boolean ignoreWeights;
    private final EntrySelector entrySelector;
    private final int maxEffort;
    private final boolean failOpen;

    P2CSelector(List<? extends Host<ResolvedAddress, C>> hosts, String lbDescription, boolean ignoreWeights, int maxEffort, boolean failOpen, @Nullable Random random) {
        super(hosts, lbDescription);
        this.ignoreWeights = ignoreWeights;
        this.entrySelector = ignoreWeights ? new EqualWeightEntrySelector(hosts.size()) : this.buildAliasTable(hosts);
        this.maxEffort = maxEffort;
        this.failOpen = failOpen;
        this.random = random;
    }

    @Override
    public HostSelector<ResolvedAddress, C> rebuildWithHosts(List<? extends Host<ResolvedAddress, C>> hosts) {
        return new P2CSelector<ResolvedAddress, C>(hosts, this.lbDescription(), this.ignoreWeights, this.maxEffort, this.failOpen, this.random);
    }

    @Override
    protected Single<C> selectConnection0(Predicate<C> selector, @Nullable ContextMap context, boolean forceNewConnectionAndReserve) {
        int size = this.hostSetSize();
        switch (size) {
            case 0: {
                throw new AssertionError((Object)(this.lbDescription() + ": Selector received an empty host set"));
            }
            case 1: {
                Single result;
                Host host = this.hosts().get(0);
                if ((this.failOpen || host.isHealthy()) && (result = this.selectFromHost(host, selector, forceNewConnectionAndReserve, context)) != null) {
                    return result;
                }
                return this.noActiveHostsFailure(this.hosts());
            }
        }
        return this.p2c(this.hosts(), this.getRandom(), selector, forceNewConnectionAndReserve, context);
    }

    private Single<C> p2c(List<? extends Host<ResolvedAddress, C>> hosts, Random random, Predicate<C> selector, boolean forceNewConnectionAndReserve, @Nullable ContextMap contextMap) {
        Single<C> result;
        int j;
        Host<ResolvedAddress, C> failOpenHost = null;
        int n = j = hosts.size() == 2 ? 1 : this.maxEffort;
        while (j > 0) {
            Single<C> result2;
            int i1 = this.entrySelector.firstEntry(random);
            int i2 = this.entrySelector.secondEntry(random, i1);
            Host<ResolvedAddress, C> t1 = hosts.get(i1);
            Host<ResolvedAddress, C> t2 = hosts.get(i2);
            boolean t1Healthy = t1.isHealthy();
            boolean t2Healthy = t2.isHealthy();
            if (t1Healthy && t2Healthy) {
                if (t1.score() < t2.score()) {
                    Host<ResolvedAddress, C> tmp = t1;
                    t1 = t2;
                    t2 = tmp;
                }
                if ((result2 = this.selectFromHost(t1, selector, forceNewConnectionAndReserve, contextMap)) == null) {
                    result2 = this.selectFromHost(t2, selector, forceNewConnectionAndReserve, contextMap);
                }
                if (result2 != null) {
                    return result2;
                }
            } else if (t2Healthy) {
                result2 = this.selectFromHost(t2, selector, forceNewConnectionAndReserve, contextMap);
                if (result2 != null) {
                    return result2;
                }
            } else if (t1Healthy) {
                result2 = this.selectFromHost(t1, selector, forceNewConnectionAndReserve, contextMap);
                if (result2 != null) {
                    return result2;
                }
            } else if (this.failOpen && failOpenHost == null) {
                if (t1.canMakeNewConnections()) {
                    failOpenHost = t1;
                } else if (t2.canMakeNewConnections()) {
                    failOpenHost = t2;
                }
            }
            --j;
        }
        if (failOpenHost != null && (result = this.selectFromHost(failOpenHost, selector, forceNewConnectionAndReserve, contextMap)) != null) {
            return result;
        }
        return this.noActiveHostsFailure(hosts);
    }

    private Random getRandom() {
        return this.random == null ? ThreadLocalRandom.current() : this.random;
    }

    private EntrySelector buildAliasTable(List<? extends Host<?, ?>> hosts) {
        if (hosts.isEmpty()) {
            return EMPTY_SELECTOR;
        }
        double[] probs = new double[hosts.size()];
        boolean allSameProbability = true;
        double pTotal = 0.0;
        for (int i = 0; i < hosts.size(); ++i) {
            double pi = hosts.get(i).weight();
            if (pi < 0.0) {
                LOGGER.warn("{}: host at address {} has negative weight ({}). Using unweighted selection.", this.lbDescription(), hosts.get(i).address(), pi);
                return new EqualWeightEntrySelector(hosts.size());
            }
            probs[i] = pi;
            pTotal += pi;
            allSameProbability = allSameProbability && P2CSelector.approxEqual(pi, probs[0]);
        }
        if (allSameProbability) {
            return new EqualWeightEntrySelector(hosts.size());
        }
        if (!P2CSelector.approxEqual(pTotal, 1.0)) {
            double invPTotal = 1.0 / pTotal;
            int i = 0;
            while (i < probs.length) {
                int n = i++;
                probs[n] = probs[n] * invPTotal;
            }
        }
        return this.buildAliasTable(probs);
    }

    private AliasTableEntrySelector buildAliasTable(double[] pin) {
        assert (P2CSelector.isNormalized(pin));
        double[] pout = new double[pin.length];
        int[] aliases = new int[pin.length];
        int[] small = new int[pin.length];
        int[] large = new int[pin.length];
        int s = 0;
        int l = 0;
        for (int i = 0; i < pin.length; ++i) {
            int n = i;
            pin[n] = pin[n] * (double)pin.length;
            if (pin[i] > 1.0) {
                large[l++] = i;
                continue;
            }
            small[s++] = i;
        }
        while (s != 0 && l != 0) {
            int j = small[--s];
            int k = large[--l];
            pout[j] = pin[j];
            aliases[j] = k;
            pin[k] = pin[k] + pin[j] - 1.0;
            if (pin[k] > 1.0) {
                large[l++] = k;
                continue;
            }
            small[s++] = k;
        }
        while (s != 0) {
            pout[small[--s]] = 1.0;
        }
        while (l != 0) {
            pout[large[--l]] = 1.0;
        }
        return new AliasTableEntrySelector(pout, aliases);
    }

    private final class AliasTableEntrySelector
    extends EntrySelector {
        private final double[] aliasProbabilities;
        private final int[] aliases;

        AliasTableEntrySelector(double[] aliasProbabilities, int[] aliases) {
            this.aliasProbabilities = aliasProbabilities;
            this.aliases = aliases;
        }

        @Override
        int secondEntry(Random random, int firstPick) {
            int result;
            int iteration = 0;
            while ((result = this.pick(random)) == firstPick && iteration++ < P2CSelector.this.maxEffort) {
            }
            if (firstPick == result) {
                LOGGER.debug("{}: failed to pick two unique indices after {} selection attempts", (Object)P2CSelector.this.lbDescription(), (Object)P2CSelector.this.maxEffort);
            }
            return 0;
        }

        @Override
        int firstEntry(Random random) {
            return this.pick(random);
        }

        private int pick(Random random) {
            int i = random.nextInt(this.aliases.length);
            double pp = this.aliasProbabilities[i];
            if (pp != 1.0 && random.nextDouble() > pp) {
                i = this.aliases[i];
            }
            return i;
        }
    }

    private static final class EqualWeightEntrySelector
    extends EntrySelector {
        private final int size;

        EqualWeightEntrySelector(int size) {
            this.size = size;
        }

        @Override
        int firstEntry(Random random) {
            return random.nextInt(this.size);
        }

        @Override
        int secondEntry(Random random, int firstEntry) {
            assert (this.size >= 2);
            int result = random.nextInt(this.size - 1);
            if (result >= firstEntry) {
                ++result;
            }
            return result;
        }
    }

    private static abstract class EntrySelector {
        private EntrySelector() {
        }

        abstract int firstEntry(Random var1);

        abstract int secondEntry(Random var1, int var2);
    }
}

