/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.loadbalancer.LoadBalancingPolicy;
import io.servicetalk.loadbalancer.P2CLoadBalancingPolicy;
import io.servicetalk.utils.internal.NumberUtils;
import java.util.Random;
import javax.annotation.Nullable;

public final class P2CLoadBalancingPolicyBuilder {
    private static final boolean DEFAULT_IGNORE_WEIGHTS = false;
    private static final int DEFAULT_MAX_EFFORT = 5;
    private static final boolean DEFAULT_FAIL_OPEN_POLICY = false;
    private boolean ignoreWeights = false;
    private int maxEffort = 5;
    private boolean failOpen = false;
    @Nullable
    private Random random;

    P2CLoadBalancingPolicyBuilder() {
    }

    public P2CLoadBalancingPolicyBuilder maxEffort(int maxEffort) {
        this.maxEffort = NumberUtils.ensurePositive(maxEffort, "maxEffort");
        return this;
    }

    public P2CLoadBalancingPolicyBuilder failOpen(boolean failOpen) {
        this.failOpen = failOpen;
        return this;
    }

    public P2CLoadBalancingPolicyBuilder ignoreWeights(boolean ignoreWeights) {
        this.ignoreWeights = ignoreWeights;
        return this;
    }

    P2CLoadBalancingPolicyBuilder random(Random random) {
        this.random = random;
        return this;
    }

    public <ResolvedAddress, C extends LoadBalancedConnection> LoadBalancingPolicy<ResolvedAddress, C> build() {
        return new P2CLoadBalancingPolicy(this.ignoreWeights, this.maxEffort, this.failOpen, this.random);
    }
}

