/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.loadbalancer.Host;
import io.servicetalk.loadbalancer.HostSelector;
import io.servicetalk.loadbalancer.LoadBalancingPolicy;
import io.servicetalk.loadbalancer.P2CSelector;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;

final class P2CLoadBalancingPolicy<ResolvedAddress, C extends LoadBalancedConnection>
extends LoadBalancingPolicy<ResolvedAddress, C> {
    private final boolean ignoreWeights;
    private final int maxEffort;
    private final boolean failOpen;
    @Nullable
    private final Random random;

    P2CLoadBalancingPolicy(boolean ignoreWeights, int maxEffort, boolean failOpen, @Nullable Random random) {
        this.ignoreWeights = ignoreWeights;
        this.maxEffort = maxEffort;
        this.failOpen = failOpen;
        this.random = random;
    }

    @Override
    HostSelector<ResolvedAddress, C> buildSelector(List<Host<ResolvedAddress, C>> hosts, String lbDescription) {
        return new P2CSelector<ResolvedAddress, C>(hosts, lbDescription, this.ignoreWeights, this.maxEffort, this.failOpen, this.random);
    }

    @Override
    public String name() {
        return "P2C";
    }

    @Override
    public String toString() {
        return "P2CLoadBalancingPolicy{ignoreWeights=" + this.ignoreWeights + ", maxEffort=" + this.maxEffort + ", failOpen=" + this.failOpen + ", random=" + this.random + '}';
    }
}

