/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.loadbalancer.ConnectionPoolStrategy;
import io.servicetalk.utils.internal.NumberUtils;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class P2CConnectionPoolStrategy<C extends LoadBalancedConnection>
implements ConnectionPoolStrategy<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(P2CConnectionPoolStrategy.class);
    private final String lbDescription;
    private final int maxEffort;
    private final int corePoolSize;
    private final boolean forceCorePool;

    private P2CConnectionPoolStrategy(String lbDescription, int maxEffort, int corePoolSize, boolean forceCorePool) {
        this.lbDescription = Objects.requireNonNull(lbDescription, "lbDescription");
        this.maxEffort = NumberUtils.ensureNonNegative(maxEffort, "maxEffort");
        this.corePoolSize = NumberUtils.ensureNonNegative(corePoolSize, "corePoolSize");
        this.forceCorePool = forceCorePool;
    }

    @Override
    @Nullable
    public C select(List<C> connections, Predicate<C> selector) {
        LoadBalancedConnection connection;
        int connectionCount = connections.size();
        if (this.forceCorePool && connectionCount < this.corePoolSize) {
            return null;
        }
        int randomSearchSpace = Math.min(connectionCount, this.corePoolSize);
        if (randomSearchSpace == 1 ? selector.test(connection = (LoadBalancedConnection)connections.get(0)) : randomSearchSpace > 1 && (connection = this.p2CLoop(randomSearchSpace, connections, selector)) != null) {
            return (C)connection;
        }
        for (int i = randomSearchSpace; i < connectionCount; ++i) {
            LoadBalancedConnection connection2 = (LoadBalancedConnection)connections.get(i);
            if (!selector.test(connection2)) continue;
            return (C)connection2;
        }
        return null;
    }

    @Nullable
    private C p2CLoop(int randomSearchSpace, List<C> connections, Predicate<C> selector) {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        boolean singleIteration = randomSearchSpace == 2;
        int attempts = singleIteration ? 1 : this.maxEffort;
        for (int i = 0; i < attempts; ++i) {
            C candidate = this.p2cPick(rnd, randomSearchSpace, connections, selector);
            if (candidate == null) continue;
            return candidate;
        }
        if (!singleIteration && LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}: max effort ({}) exhausted while searching through {} candidates.", this.lbDescription, this.maxEffort, randomSearchSpace);
        }
        return null;
    }

    @Nullable
    private C p2cPick(ThreadLocalRandom rnd, int randomSearchSpace, List<C> connections, Predicate<C> selector) {
        int i1 = rnd.nextInt(randomSearchSpace);
        int i2 = rnd.nextInt(randomSearchSpace - 1);
        if (i2 >= i1) {
            ++i2;
        }
        LoadBalancedConnection c1 = (LoadBalancedConnection)connections.get(i1);
        LoadBalancedConnection c2 = (LoadBalancedConnection)connections.get(i2);
        if (c2.score() > c1.score()) {
            LoadBalancedConnection tmp = c1;
            c1 = c2;
            c2 = tmp;
        }
        if (selector.test(c1)) {
            return (C)c1;
        }
        if (selector.test(c2)) {
            return (C)c2;
        }
        return null;
    }

    static <C extends LoadBalancedConnection> ConnectionPoolStrategy.ConnectionPoolStrategyFactory<C> factory(int maxEffort, int corePoolSize, boolean forceCorePool) {
        return new P2CConnectionPoolStrategyFactory(maxEffort, corePoolSize, forceCorePool);
    }

    private static final class P2CConnectionPoolStrategyFactory<C extends LoadBalancedConnection>
    implements ConnectionPoolStrategy.ConnectionPoolStrategyFactory<C> {
        private final int maxEffort;
        private final int corePoolSize;
        private final boolean forceCorePool;

        P2CConnectionPoolStrategyFactory(int maxEffort, int corePoolSize, boolean forceCorePool) {
            this.maxEffort = NumberUtils.ensurePositive(maxEffort, " maxEffort");
            this.corePoolSize = NumberUtils.ensureNonNegative(corePoolSize, "corePoolSize");
            this.forceCorePool = forceCorePool;
        }

        @Override
        public ConnectionPoolStrategy<C> buildStrategy(String lbDescription) {
            return new P2CConnectionPoolStrategy(lbDescription, this.maxEffort, this.corePoolSize, this.forceCorePool);
        }

        public String toString() {
            return "P2CConnectionPoolStrategyFactory{maxEffort=" + this.maxEffort + ", corePoolSize=" + this.corePoolSize + ", forceCorePool=" + this.forceCorePool + '}';
        }
    }
}

