/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.loadbalancer.HealthCheckConfig;
import io.servicetalk.utils.internal.NumberUtils;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

public final class OutlierDetectorConfig {
    static final OutlierDetectorConfig DEFAULT_CONFIG = new Builder().build();
    private final Duration ewmaHalfLife;
    private final int ewmaCancellationPenalty;
    private final int ewmaErrorPenalty;
    private final int concurrentRequestPenalty;
    private final boolean cancellationIsError;
    private final int failedConnectionsThreshold;
    private final Duration failureDetectorIntervalJitter;
    private final Duration serviceDiscoveryResubscribeInterval;
    private final Duration serviceDiscoveryResubscribeJitter;
    private final int consecutive5xx;
    private final Duration failureDetectorInterval;
    private final Duration baseEjectionTime;
    private final Duration ejectionTimeJitter;
    private final int maxEjectionPercentage;
    private final int enforcingConsecutive5xx;
    private final int enforcingSuccessRate;
    private final int successRateMinimumHosts;
    private final int successRateRequestVolume;
    private final int successRateStdevFactor;
    private final int failurePercentageThreshold;
    private final int enforcingFailurePercentage;
    private final int failurePercentageMinimumHosts;
    private final int failurePercentageRequestVolume;
    private final Duration maxEjectionTime;

    private OutlierDetectorConfig(Duration ewmaHalfLife, int ewmaCancellationPenalty, int ewmaErrorPenalty, int concurrentRequestPenalty, boolean cancellationIsError, int failedConnectionsThreshold, Duration failureDetectorIntervalJitter, Duration serviceDiscoveryResubscribeInterval, Duration serviceDiscoveryResubscribeJitter, int consecutive5xx, Duration failureDetectorInterval, Duration baseEjectionTime, int maxEjectionPercentage, int enforcingConsecutive5xx, int enforcingSuccessRate, int successRateMinimumHosts, int successRateRequestVolume, int successRateStdevFactor, int failurePercentageThreshold, int enforcingFailurePercentage, int failurePercentageMinimumHosts, int failurePercentageRequestVolume, Duration maxEjectionTime, Duration ejectionTimeJitter) {
        this.ewmaHalfLife = Objects.requireNonNull(ewmaHalfLife, "ewmaHalfLife");
        this.ewmaCancellationPenalty = NumberUtils.ensureNonNegative(ewmaCancellationPenalty, "ewmaCancellationPenalty");
        this.ewmaErrorPenalty = NumberUtils.ensureNonNegative(ewmaErrorPenalty, "ewmaErrorPenalty");
        this.concurrentRequestPenalty = NumberUtils.ensureNonNegative(concurrentRequestPenalty, "concurrentRequestPenalty");
        this.cancellationIsError = cancellationIsError;
        this.failedConnectionsThreshold = failedConnectionsThreshold;
        this.failureDetectorIntervalJitter = Objects.requireNonNull(failureDetectorIntervalJitter, "failureDetectorIntervalJitter");
        this.serviceDiscoveryResubscribeInterval = Objects.requireNonNull(serviceDiscoveryResubscribeInterval, "serviceDiscoveryResubscribeInterval");
        this.serviceDiscoveryResubscribeJitter = Objects.requireNonNull(serviceDiscoveryResubscribeJitter, "serviceDiscoveryResubscribeJitter");
        this.consecutive5xx = consecutive5xx;
        this.failureDetectorInterval = Objects.requireNonNull(failureDetectorInterval, "failureDetectorInterval");
        this.baseEjectionTime = Objects.requireNonNull(baseEjectionTime, "baseEjectionTime");
        this.ejectionTimeJitter = Objects.requireNonNull(ejectionTimeJitter, "ejectionTimeJitter");
        this.maxEjectionPercentage = maxEjectionPercentage;
        this.enforcingConsecutive5xx = enforcingConsecutive5xx;
        this.enforcingSuccessRate = enforcingSuccessRate;
        this.successRateMinimumHosts = successRateMinimumHosts;
        this.successRateRequestVolume = successRateRequestVolume;
        this.successRateStdevFactor = successRateStdevFactor;
        this.failurePercentageThreshold = failurePercentageThreshold;
        this.enforcingFailurePercentage = enforcingFailurePercentage;
        this.failurePercentageMinimumHosts = failurePercentageMinimumHosts;
        this.failurePercentageRequestVolume = failurePercentageRequestVolume;
        this.maxEjectionTime = Objects.requireNonNull(maxEjectionTime, "maxEjectionTime");
    }

    public Duration ewmaHalfLife() {
        return this.ewmaHalfLife;
    }

    public int ewmaCancellationPenalty() {
        return this.ewmaCancellationPenalty;
    }

    public boolean cancellationIsError() {
        return this.cancellationIsError;
    }

    public int ewmaErrorPenalty() {
        return this.ewmaErrorPenalty;
    }

    public int concurrentRequestPenalty() {
        return this.concurrentRequestPenalty;
    }

    public int failedConnectionsThreshold() {
        return this.failedConnectionsThreshold;
    }

    public Duration failureDetectorIntervalJitter() {
        return this.failureDetectorIntervalJitter;
    }

    public Duration serviceDiscoveryResubscribeInterval() {
        return this.serviceDiscoveryResubscribeInterval;
    }

    public Duration serviceDiscoveryResubscribeJitter() {
        return this.serviceDiscoveryResubscribeJitter;
    }

    public int consecutive5xx() {
        return this.consecutive5xx;
    }

    public Duration failureDetectorInterval() {
        return this.failureDetectorInterval;
    }

    public Duration baseEjectionTime() {
        return this.baseEjectionTime;
    }

    public int maxEjectionPercentage() {
        return this.maxEjectionPercentage;
    }

    public int enforcingConsecutive5xx() {
        return this.enforcingConsecutive5xx;
    }

    public int enforcingSuccessRate() {
        return this.enforcingSuccessRate;
    }

    public int successRateMinimumHosts() {
        return this.successRateMinimumHosts;
    }

    public int successRateRequestVolume() {
        return this.successRateRequestVolume;
    }

    public int successRateStdevFactor() {
        return this.successRateStdevFactor;
    }

    public int failurePercentageThreshold() {
        return this.failurePercentageThreshold;
    }

    public int enforcingFailurePercentage() {
        return this.enforcingFailurePercentage;
    }

    public int failurePercentageMinimumHosts() {
        return this.failurePercentageMinimumHosts;
    }

    public int failurePercentageRequestVolume() {
        return this.failurePercentageRequestVolume;
    }

    public Duration maxEjectionTime() {
        return this.maxEjectionTime;
    }

    public Duration ejectionTimeJitter() {
        return this.ejectionTimeJitter;
    }

    public String toString() {
        return "OutlierDetectorConfig{ewmaHalfLife=" + this.ewmaHalfLife + ", ewmaCancellationPenalty=" + this.ewmaCancellationPenalty + ", ewmaErrorPenalty=" + this.ewmaErrorPenalty + ", cancellationIsError=" + this.cancellationIsError + ", failedConnectionsThreshold=" + this.failedConnectionsThreshold + ", failureDetectorIntervalJitter=" + this.failureDetectorIntervalJitter + ", serviceDiscoveryResubscribeInterval=" + this.serviceDiscoveryResubscribeInterval + ", serviceDiscoveryResubscribeJitter=" + this.serviceDiscoveryResubscribeJitter + ", consecutive5xx=" + this.consecutive5xx + ", failureDetectorInterval=" + this.failureDetectorInterval + ", baseEjectionTime=" + this.baseEjectionTime + ", ejectionTimeJitter=" + this.ejectionTimeJitter + ", maxEjectionPercentage=" + this.maxEjectionPercentage + ", enforcingConsecutive5xx=" + this.enforcingConsecutive5xx + ", enforcingSuccessRate=" + this.enforcingSuccessRate + ", successRateMinimumHosts=" + this.successRateMinimumHosts + ", successRateRequestVolume=" + this.successRateRequestVolume + ", successRateStdevFactor=" + this.successRateStdevFactor + ", failurePercentageThreshold=" + this.failurePercentageThreshold + ", enforcingFailurePercentage=" + this.enforcingFailurePercentage + ", failurePercentageMinimumHosts=" + this.failurePercentageMinimumHosts + ", failurePercentageRequestVolume=" + this.failurePercentageRequestVolume + ", maxEjectionTime=" + this.maxEjectionTime + '}';
    }

    static boolean enforcing(int enforcingPercentage) {
        if (enforcingPercentage <= 0) {
            return false;
        }
        if (enforcingPercentage >= 100) {
            return true;
        }
        return enforcingPercentage >= ThreadLocalRandom.current().nextInt(100) + 1;
    }

    static boolean allDisabled(OutlierDetectorConfig outlierDetectorConfig) {
        return outlierDetectorConfig.failedConnectionsThreshold() < 0 && OutlierDetectorConfig.xDSDisabled(outlierDetectorConfig);
    }

    static boolean xDSDisabled(OutlierDetectorConfig outlierDetectorConfig) {
        return outlierDetectorConfig.enforcingConsecutive5xx() == 0 && outlierDetectorConfig.enforcingSuccessRate() == 0 && outlierDetectorConfig.enforcingFailurePercentage() == 0;
    }

    public static final class Builder {
        static final Duration DEFAULT_EWMA_HALF_LIFE = Duration.ofSeconds(10L);
        static final int DEFAULT_CANCEL_PENALTY = 5;
        static final int DEFAULT_ERROR_PENALTY = 10;
        static final int DEFAULT_CONCURRENT_REQUEST_PENALTY = 1;
        private boolean cancellationIsError = true;
        private static final int DEFAULT_CONSECUTIVE_5XX = 5;
        private static final Duration DEFAULT_FAILURE_DETECTOR_INTERVAL = Duration.ofSeconds(10L);
        private static final Duration DEFAULT_BASE_EJECTION_TIME = Duration.ofSeconds(30L);
        private static final int DEFAULT_MAX_EJECTION_PERCENTAGE = 10;
        private static final int DEFAULT_ENFORCING_CONSECUTIVE_5XX = 100;
        private static final int DEFAULT_ENFORCING_SUCCESS_RATE = 100;
        private static final int DEFAULT_SUCCESS_RATE_MINIMUM_HOSTS = 5;
        private static final int DEFAULT_SUCCESS_RATE_REQUEST_VOLUME = 100;
        private static final int DEFAULT_SUCCESS_RATE_STDEV_FACTOR = 1900;
        private static final int DEFAULT_FAILURE_PERCENTAGE_THRESHOLD = 85;
        private static final int DEFAULT_ENFORCING_FAILURE_PERCENTAGE = 0;
        private static final int DEFAULT_FAILURE_PERCENTAGE_MINIMUM_HOSTS = 5;
        private static final int DEFAULT_FAILURE_PERCENTAGE_REQUEST_VOLUME = 50;
        private static final Duration DEFAULT_MAX_EJECTION_TIME = Duration.ofSeconds(300L);
        private Duration ewmaHalfLife = DEFAULT_EWMA_HALF_LIFE;
        private int ewmaCancellationPenalty = 5;
        private int ewmaErrorPenalty = 10;
        private int concurrentRequestPenalty = 1;
        private int failedConnectionsThreshold = 5;
        private Duration intervalJitter = HealthCheckConfig.DEFAULT_HEALTH_CHECK_JITTER;
        private Duration serviceDiscoveryResubscribeInterval = HealthCheckConfig.DEFAULT_HEALTH_CHECK_RESUBSCRIBE_INTERVAL;
        private Duration serviceDiscoveryResubscribeJitter = HealthCheckConfig.DEFAULT_HEALTH_CHECK_JITTER;
        private int consecutive5xx = 5;
        private Duration failureDetectorInterval = DEFAULT_FAILURE_DETECTOR_INTERVAL;
        private Duration baseEjectionTime = DEFAULT_BASE_EJECTION_TIME;
        private int maxEjectionPercentage = 10;
        private int enforcingConsecutive5xx = 100;
        private int enforcingSuccessRate = 100;
        private int successRateMinimumHosts = 5;
        private int successRateRequestVolume = 100;
        private int successRateStdevFactor = 1900;
        private int failurePercentageThreshold = 85;
        private int enforcingFailurePercentage = 0;
        private int failurePercentageMinimumHosts = 5;
        private int failurePercentageRequestVolume = 50;
        private Duration maxEjectionTime = DEFAULT_MAX_EJECTION_TIME;
        private Duration ejectionTimeJitter = HealthCheckConfig.DEFAULT_HEALTH_CHECK_JITTER;

        Builder(OutlierDetectorConfig outlierDetectorConfig) {
            this.ewmaHalfLife = outlierDetectorConfig.ewmaHalfLife;
            this.failedConnectionsThreshold = outlierDetectorConfig.failedConnectionsThreshold;
            this.intervalJitter = outlierDetectorConfig.failureDetectorIntervalJitter;
            this.serviceDiscoveryResubscribeInterval = outlierDetectorConfig.serviceDiscoveryResubscribeInterval;
            this.serviceDiscoveryResubscribeJitter = outlierDetectorConfig.serviceDiscoveryResubscribeJitter;
            this.consecutive5xx = outlierDetectorConfig.consecutive5xx;
            this.failureDetectorInterval = outlierDetectorConfig.failureDetectorInterval;
            this.baseEjectionTime = outlierDetectorConfig.baseEjectionTime;
            this.maxEjectionPercentage = outlierDetectorConfig.maxEjectionPercentage;
            this.enforcingConsecutive5xx = outlierDetectorConfig.enforcingConsecutive5xx;
            this.enforcingSuccessRate = outlierDetectorConfig.enforcingSuccessRate;
            this.successRateMinimumHosts = outlierDetectorConfig.successRateMinimumHosts;
            this.successRateRequestVolume = outlierDetectorConfig.successRateRequestVolume;
            this.successRateStdevFactor = outlierDetectorConfig.successRateStdevFactor;
            this.failurePercentageThreshold = outlierDetectorConfig.failurePercentageThreshold;
            this.enforcingFailurePercentage = outlierDetectorConfig.enforcingFailurePercentage;
            this.failurePercentageMinimumHosts = outlierDetectorConfig.failurePercentageMinimumHosts;
            this.failurePercentageRequestVolume = outlierDetectorConfig.failurePercentageRequestVolume;
            this.maxEjectionTime = outlierDetectorConfig.maxEjectionTime;
            this.ejectionTimeJitter = outlierDetectorConfig.ejectionTimeJitter;
        }

        public Builder() {
        }

        public OutlierDetectorConfig build() {
            return new OutlierDetectorConfig(this.ewmaHalfLife, this.ewmaCancellationPenalty, this.ewmaErrorPenalty, this.concurrentRequestPenalty, this.cancellationIsError, this.failedConnectionsThreshold, this.intervalJitter, this.serviceDiscoveryResubscribeInterval, this.serviceDiscoveryResubscribeJitter, this.consecutive5xx, this.failureDetectorInterval, this.baseEjectionTime, this.maxEjectionPercentage, this.enforcingConsecutive5xx, this.enforcingSuccessRate, this.successRateMinimumHosts, this.successRateRequestVolume, this.successRateStdevFactor, this.failurePercentageThreshold, this.enforcingFailurePercentage, this.failurePercentageMinimumHosts, this.failurePercentageRequestVolume, this.maxEjectionTime, this.ejectionTimeJitter);
        }

        public Builder ewmaHalfLife(Duration ewmaHalfLife) {
            Objects.requireNonNull(ewmaHalfLife, "ewmaHalfLife");
            NumberUtils.ensureNonNegative(ewmaHalfLife.toNanos(), "ewmaHalfLife");
            this.ewmaHalfLife = ewmaHalfLife;
            return this;
        }

        public Builder ewmaCancellationPenalty(int ewmaCancellationPenalty) {
            this.ewmaCancellationPenalty = NumberUtils.ensureNonNegative(ewmaCancellationPenalty, "ewmaCancellationPenalty");
            return this;
        }

        public Builder ewmaErrorPenalty(int ewmaErrorPenalty) {
            this.ewmaErrorPenalty = NumberUtils.ensureNonNegative(ewmaErrorPenalty, "ewmaErrorPenalty");
            return this;
        }

        public Builder cancellationIsError(boolean cancellationIsError) {
            this.cancellationIsError = cancellationIsError;
            return this;
        }

        public Builder ewmaConcurrentRequestPenalty(int ewmaConcurrentRequestPenalty) {
            this.concurrentRequestPenalty = NumberUtils.ensureNonNegative(ewmaConcurrentRequestPenalty, "ewmaConcurrentRequestPenalty");
            return this;
        }

        public Builder serviceDiscoveryResubscribeInterval(Duration interval, Duration jitter) {
            HealthCheckConfig.validateHealthCheckIntervals(interval, jitter);
            this.serviceDiscoveryResubscribeInterval = interval;
            this.serviceDiscoveryResubscribeJitter = jitter;
            return this;
        }

        public Builder failedConnectionsThreshold(int failedConnectionsThreshold) {
            this.failedConnectionsThreshold = failedConnectionsThreshold;
            if (failedConnectionsThreshold == 0) {
                throw new IllegalArgumentException("Not valid value: 0");
            }
            return this;
        }

        public Builder consecutive5xx(int consecutive5xx) {
            NumberUtils.ensurePositive(consecutive5xx, "consecutive5xx");
            this.consecutive5xx = consecutive5xx;
            return this;
        }

        public Builder failureDetectorInterval(Duration interval) {
            this.failureDetectorInterval = Objects.requireNonNull(interval, "interval");
            return this.failureDetectorInterval(interval, interval.compareTo(HealthCheckConfig.DEFAULT_HEALTH_CHECK_INTERVAL) < 0 ? interval.dividedBy(2L) : HealthCheckConfig.DEFAULT_HEALTH_CHECK_JITTER);
        }

        public Builder failureDetectorInterval(Duration interval, Duration jitter) {
            HealthCheckConfig.validateHealthCheckIntervals(interval, jitter);
            this.failureDetectorInterval = Objects.requireNonNull(interval, "interval");
            this.intervalJitter = jitter;
            return this;
        }

        public Builder baseEjectionTime(Duration baseEjectionTime) {
            this.baseEjectionTime = Objects.requireNonNull(baseEjectionTime, "baseEjectionTime");
            NumberUtils.ensurePositive(baseEjectionTime.toNanos(), "baseEjectionTime");
            return this;
        }

        public Builder ejectionTimeJitter(Duration ejectionTimeJitter) {
            NumberUtils.ensureNonNegative(Objects.requireNonNull(ejectionTimeJitter, "ejectionTimeJitter").toNanos(), "ejectionTimeJitter");
            this.ejectionTimeJitter = ejectionTimeJitter;
            return this;
        }

        public Builder maxEjectionPercentage(int maxEjectionPercentage) {
            NumberUtils.ensureNonNegative(maxEjectionPercentage, "maxEjectionPercentage");
            this.maxEjectionPercentage = maxEjectionPercentage;
            return this;
        }

        public Builder enforcingConsecutive5xx(int enforcingConsecutive5xx) {
            NumberUtils.ensureNonNegative(enforcingConsecutive5xx, "enforcingConsecutive5xx");
            this.enforcingConsecutive5xx = enforcingConsecutive5xx;
            return this;
        }

        public Builder enforcingSuccessRate(int enforcingSuccessRate) {
            NumberUtils.ensureNonNegative(enforcingSuccessRate, "enforcingSuccessRate");
            this.enforcingSuccessRate = enforcingSuccessRate;
            return this;
        }

        public Builder successRateMinimumHosts(int successRateMinimumHosts) {
            NumberUtils.ensureNonNegative(successRateMinimumHosts, "successRateMinimumHosts");
            this.successRateMinimumHosts = successRateMinimumHosts;
            return this;
        }

        public Builder successRateRequestVolume(int successRateRequestVolume) {
            NumberUtils.ensurePositive(successRateRequestVolume, "successRateRequestVolume");
            this.successRateRequestVolume = successRateRequestVolume;
            return this;
        }

        public Builder successRateStdevFactor(int successRateStdevFactor) {
            NumberUtils.ensurePositive(successRateStdevFactor, "successRateStdevFactor");
            this.successRateStdevFactor = successRateStdevFactor;
            return this;
        }

        public Builder failurePercentageThreshold(int failurePercentageThreshold) {
            NumberUtils.ensurePositive(failurePercentageThreshold, "failurePercentageThreshold");
            this.failurePercentageThreshold = failurePercentageThreshold;
            return this;
        }

        public Builder enforcingFailurePercentage(int enforcingFailurePercentage) {
            NumberUtils.ensureNonNegative(enforcingFailurePercentage, "enforcingFailurePercentage");
            this.enforcingFailurePercentage = enforcingFailurePercentage;
            return this;
        }

        public Builder failurePercentageMinimumHosts(int failurePercentageMinimumHosts) {
            NumberUtils.ensureNonNegative(failurePercentageMinimumHosts, "failurePercentageMinimumHosts");
            this.failurePercentageMinimumHosts = failurePercentageMinimumHosts;
            return this;
        }

        public Builder failurePercentageRequestVolume(int failurePercentageRequestVolume) {
            NumberUtils.ensurePositive(failurePercentageRequestVolume, "failurePercentageRequestVolume");
            this.failurePercentageRequestVolume = failurePercentageRequestVolume;
            return this;
        }

        public Builder maxEjectionTime(Duration maxEjectionTime) {
            NumberUtils.ensureNonNegative(Objects.requireNonNull(maxEjectionTime, "maxEjectionTime").toNanos(), "maxEjectionTime");
            this.maxEjectionTime = maxEjectionTime;
            return this;
        }
    }
}

