/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.loadbalancer.ConnectTracker;
import io.servicetalk.loadbalancer.DefaultRequestTracker;
import io.servicetalk.loadbalancer.HealthIndicator;
import io.servicetalk.loadbalancer.Host;
import io.servicetalk.loadbalancer.LoadBalancerObserver;
import io.servicetalk.loadbalancer.OutlierDetector;
import io.servicetalk.loadbalancer.OutlierDetectorConfig;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

final class NoopOutlierDetector<ResolvedAddress, C extends LoadBalancedConnection>
implements OutlierDetector<ResolvedAddress, C> {
    private final OutlierDetectorConfig outlierDetectorConfig;
    private final Executor executor;

    NoopOutlierDetector(OutlierDetectorConfig outlierDetectorConfig, Executor executor) {
        this.outlierDetectorConfig = Objects.requireNonNull(outlierDetectorConfig, "outlierDetectorConfig");
        this.executor = Objects.requireNonNull(executor, "executor");
    }

    @Override
    public void cancel() {
    }

    @Override
    public HealthIndicator<ResolvedAddress, C> newHealthIndicator(ResolvedAddress resolvedAddress, LoadBalancerObserver.HostObserver hostObserver) {
        return new BasicHealthIndicator();
    }

    @Override
    public Publisher<Void> healthStatusChanged() {
        return Publisher.never();
    }

    public String toString() {
        return "NoopOutlierDetector{ewmaHalfLife=" + this.outlierDetectorConfig.ewmaHalfLife() + ", ewmaCancellationPenalty=" + this.outlierDetectorConfig.ewmaCancellationPenalty() + ", ewmaErrorPenalty=" + this.outlierDetectorConfig.ewmaErrorPenalty() + ", concurrentRequestPenalty=" + this.outlierDetectorConfig.concurrentRequestPenalty() + ", executor=" + this.executor + '}';
    }

    private final class BasicHealthIndicator
    extends DefaultRequestTracker
    implements HealthIndicator<ResolvedAddress, C> {
        BasicHealthIndicator() {
            super(NoopOutlierDetector.this.outlierDetectorConfig.ewmaHalfLife().toNanos(), NoopOutlierDetector.this.outlierDetectorConfig.ewmaCancellationPenalty(), NoopOutlierDetector.this.outlierDetectorConfig.ewmaErrorPenalty(), NoopOutlierDetector.this.outlierDetectorConfig.concurrentRequestPenalty());
        }

        @Override
        public void cancel() {
        }

        @Override
        public long beforeConnectStart() {
            return this.currentTimeNanos();
        }

        @Override
        public void onConnectSuccess(long beforeConnectStart) {
        }

        @Override
        public void onConnectError(long beforeConnectStart, ConnectTracker.ErrorClass errorClass) {
        }

        @Override
        protected long currentTimeNanos() {
            return NoopOutlierDetector.this.executor.currentTime(TimeUnit.NANOSECONDS);
        }

        @Override
        public boolean isHealthy() {
            return true;
        }

        @Override
        public void setHost(Host<ResolvedAddress, C> host) {
        }
    }
}

