/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.NoActiveHostException;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.loadbalancer.LoadBalancerObserver;
import io.servicetalk.loadbalancer.LoadBalancerObserverFactory;
import java.util.Collection;
import javax.annotation.Nullable;

final class NoopLoadBalancerObserver
implements LoadBalancerObserver {
    private static final LoadBalancerObserver INSTANCE = new NoopLoadBalancerObserver();
    private static final LoadBalancerObserverFactory FACTORY_INSTANCE = new NoopLoadBalancerObserverFactory();

    private NoopLoadBalancerObserver() {
    }

    @Override
    public LoadBalancerObserver.HostObserver hostObserver(Object resolvedAddress) {
        return NoopHostObserver.INSTANCE;
    }

    @Override
    public void onNoHostsAvailable() {
    }

    @Override
    public void onNoActiveHostsAvailable(int hostSetSize, NoActiveHostException exn) {
    }

    @Override
    public void onServiceDiscoveryEvent(Collection<? extends ServiceDiscovererEvent<?>> events, int oldHostSetSize, int newHostSetSize) {
    }

    @Override
    public void onHostSetChanged(Collection<? extends LoadBalancerObserver.Host> newHosts) {
    }

    static LoadBalancerObserver instance() {
        return INSTANCE;
    }

    static LoadBalancerObserverFactory factory() {
        return FACTORY_INSTANCE;
    }

    private static final class NoopLoadBalancerObserverFactory
    implements LoadBalancerObserverFactory {
        private NoopLoadBalancerObserverFactory() {
        }

        @Override
        public LoadBalancerObserver newObserver(String lbDescription) {
            return INSTANCE;
        }

        public String toString() {
            return "NoopLoadBalancerObserverFactory";
        }
    }

    private static final class NoopHostObserver
    implements LoadBalancerObserver.HostObserver {
        private static final LoadBalancerObserver.HostObserver INSTANCE = new NoopHostObserver();

        private NoopHostObserver() {
        }

        @Override
        public void onHostMarkedExpired(int connectionCount) {
        }

        @Override
        public void onExpiredHostRemoved(int connectionCount) {
        }

        @Override
        public void onExpiredHostRevived(int connectionCount) {
        }

        @Override
        public void onActiveHostRemoved(int connectionCount) {
        }

        @Override
        public void onHostMarkedUnhealthy(@Nullable Throwable cause) {
        }

        @Override
        public void onHostRevived() {
        }
    }
}

