/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.loadbalancer.DefaultLoadBalancerBuilder;
import io.servicetalk.loadbalancer.LoadBalancerBuilder;
import io.servicetalk.loadbalancer.LoadBalancerBuilderProvider;
import io.servicetalk.utils.internal.ServiceLoaderUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoadBalancers {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadBalancers.class);
    private static final List<LoadBalancerBuilderProvider> PROVIDERS;

    private LoadBalancers() {
    }

    private static <ResolvedAddress, C extends LoadBalancedConnection> LoadBalancerBuilder<ResolvedAddress, C> applyProviders(String id, LoadBalancerBuilder<ResolvedAddress, C> builder) {
        for (LoadBalancerBuilderProvider provider : PROVIDERS) {
            builder = provider.newBuilder(id, builder);
        }
        return builder;
    }

    public static <ResolvedAddress, C extends LoadBalancedConnection> LoadBalancerBuilder<ResolvedAddress, C> builder(String id) {
        return LoadBalancers.applyProviders(id, new DefaultLoadBalancerBuilder(id));
    }

    static {
        ClassLoader classLoader = LoadBalancers.class.getClassLoader();
        PROVIDERS = ServiceLoaderUtils.loadProviders(LoadBalancerBuilderProvider.class, classLoader, LOGGER);
    }
}

