/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.loadbalancer.ConnectionPoolStrategy;
import io.servicetalk.utils.internal.NumberUtils;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class LinearSearchConnectionPoolStrategy<C extends LoadBalancedConnection>
implements ConnectionPoolStrategy<C> {
    private static final int MIN_RANDOM_SEARCH_SPACE = 64;
    private static final float RANDOM_SEARCH_FACTOR = 0.75f;
    private final int linearSearchSpace;

    private LinearSearchConnectionPoolStrategy(int linearSearchSpace) {
        this.linearSearchSpace = NumberUtils.ensureNonNegative(linearSearchSpace, "linearSearchSpace");
    }

    @Override
    @Nullable
    public C select(List<C> connections, Predicate<C> selector) {
        int linearAttempts = Math.min(connections.size(), this.linearSearchSpace);
        for (int j = 0; j < linearAttempts; ++j) {
            LoadBalancedConnection connection = (LoadBalancedConnection)connections.get(j);
            if (!selector.test(connection)) continue;
            return (C)connection;
        }
        if (connections.size() > linearAttempts) {
            int diff = connections.size() - linearAttempts;
            int randomAttempts = diff < 64 ? diff : (int)((float)diff * 0.75f);
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            for (int j = 0; j < randomAttempts; ++j) {
                LoadBalancedConnection connection = (LoadBalancedConnection)connections.get(rnd.nextInt(linearAttempts, connections.size()));
                if (!selector.test(connection)) continue;
                return (C)connection;
            }
        }
        return null;
    }

    static <C extends LoadBalancedConnection> ConnectionPoolStrategy.ConnectionPoolStrategyFactory<C> factory(int linearSearchSpace) {
        return new LinearSearchConnectionPoolStrategyFactory(linearSearchSpace);
    }

    private static final class LinearSearchConnectionPoolStrategyFactory<C extends LoadBalancedConnection>
    implements ConnectionPoolStrategy.ConnectionPoolStrategyFactory<C> {
        private final int linearSearchSpace;

        LinearSearchConnectionPoolStrategyFactory(int linearSearchSpace) {
            this.linearSearchSpace = NumberUtils.ensureNonNegative(linearSearchSpace, "linearSearchSpace");
        }

        @Override
        public ConnectionPoolStrategy<C> buildStrategy(String lbDescription) {
            return new LinearSearchConnectionPoolStrategy(this.linearSearchSpace);
        }

        public String toString() {
            return "LinearSearchConnectionPoolStrategyFactory{linearSearchSpace=" + this.linearSearchSpace + '}';
        }
    }
}

