/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.utils.internal.DurationUtils;
import java.time.Duration;

final class HealthCheckConfig {
    static final Duration DEFAULT_HEALTH_CHECK_INTERVAL = Duration.ofSeconds(5L);
    static final Duration DEFAULT_HEALTH_CHECK_JITTER = Duration.ofSeconds(3L);
    static final Duration DEFAULT_HEALTH_CHECK_RESUBSCRIBE_INTERVAL = Duration.ofSeconds(10L);
    static final int DEFAULT_HEALTH_CHECK_FAILED_CONNECTIONS_THRESHOLD = 5;
    final Executor executor;
    final Duration healthCheckInterval;
    final Duration jitter;
    final int failedThreshold;
    final Duration resubscribeInterval;
    final Duration healthCheckResubscribeJitter;
    final long healthCheckResubscribeLowerBound;
    final long healthCheckResubscribeUpperBound;

    HealthCheckConfig(Executor executor, Duration healthCheckInterval, Duration healthCheckJitter, int failedThreshold, Duration resubscribeInterval, Duration healthCheckResubscribeJitter) {
        this.executor = executor;
        this.healthCheckInterval = healthCheckInterval;
        this.jitter = healthCheckJitter;
        this.failedThreshold = failedThreshold;
        this.resubscribeInterval = resubscribeInterval;
        this.healthCheckResubscribeJitter = healthCheckResubscribeJitter;
        HealthCheckConfig.validateHealthCheckIntervals(resubscribeInterval, healthCheckResubscribeJitter);
        this.healthCheckResubscribeLowerBound = resubscribeInterval.minus(healthCheckResubscribeJitter).toNanos();
        this.healthCheckResubscribeUpperBound = resubscribeInterval.plus(healthCheckResubscribeJitter).toNanos();
    }

    static void validateHealthCheckIntervals(Duration interval, Duration jitter) {
        DurationUtils.ensurePositive(interval, "interval");
        DurationUtils.ensureNonNegative(jitter, "jitter");
        Duration lowerBound = interval.minus(jitter);
        if (!DurationUtils.isPositive(lowerBound)) {
            throw new IllegalArgumentException("interval (" + interval + ") minus jitter (" + jitter + ") must be greater than 0, current=" + lowerBound);
        }
        Duration upperBound = interval.plus(jitter);
        if (!DurationUtils.isPositive(upperBound)) {
            throw new IllegalArgumentException("interval (" + interval + ") plus jitter (" + jitter + ") must not overflow, current=" + upperBound);
        }
    }

    public String toString() {
        return "HealthCheckConfig{executor=" + this.executor + ", healthCheckInterval=" + this.healthCheckInterval + ", jitter=" + this.jitter + ", failedThreshold=" + this.failedThreshold + ", resubscribeInterval=" + this.resubscribeInterval + ", healthCheckResubscribeJitter=" + this.healthCheckResubscribeJitter + '}';
    }
}

