/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.loadbalancer.OutlierDetectorConfig;
import io.servicetalk.loadbalancer.XdsHealthIndicator;
import io.servicetalk.loadbalancer.XdsOutlierDetectorAlgorithm;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FailurePercentageXdsOutlierDetectorAlgorithm<ResolvedAddress, C extends LoadBalancedConnection>
implements XdsOutlierDetectorAlgorithm<ResolvedAddress, C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FailurePercentageXdsOutlierDetectorAlgorithm.class);
    private static final long NOT_EVALUATED = Long.MAX_VALUE;

    FailurePercentageXdsOutlierDetectorAlgorithm() {
    }

    @Override
    public void detectOutliers(OutlierDetectorConfig config, Collection<? extends XdsHealthIndicator<ResolvedAddress, C>> indicators) {
        long[] failurePercentages = new long[indicators.size()];
        int i = 0;
        int enoughVolumeHosts = 0;
        int alreadyEjectedHosts = 0;
        for (XdsHealthIndicator<ResolvedAddress, C> indicator : indicators) {
            if (!indicator.isHealthy()) {
                failurePercentages[i] = Long.MAX_VALUE;
                ++alreadyEjectedHosts;
            } else {
                long failures;
                long successes = indicator.getSuccesses();
                long totalRequests = successes + (failures = indicator.getFailures());
                if (totalRequests >= (long)config.failurePercentageRequestVolume()) {
                    ++enoughVolumeHosts;
                }
                failurePercentages[i] = totalRequests == 0L ? 0L : failures * 100L / totalRequests;
            }
            ++i;
            indicator.resetCounters();
        }
        if (enoughVolumeHosts < config.failurePercentageMinimumHosts()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Not enough hosts with sufficient volume to perform ejection: {} total hosts and {} had sufficient volume. Minimum {} required.", indicators.size(), enoughVolumeHosts, config.failurePercentageMinimumHosts());
            }
            return;
        }
        double failurePercentageThreshold = config.failurePercentageThreshold();
        int ejectedCount = 0;
        i = 0;
        for (XdsHealthIndicator<ResolvedAddress, C> indicator : indicators) {
            long failurePercentage;
            if (!indicator.updateOutlierStatus(config, (failurePercentage = failurePercentages[i++]) == Long.MAX_VALUE || (double)failurePercentage >= failurePercentageThreshold && OutlierDetectorConfig.enforcing(config.enforcingFailurePercentage()))) continue;
            ++ejectedCount;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished host ejection. of {} total hosts {} hosts were already ejected and {} were newly ejected.", indicators.size(), alreadyEjectedHosts, ejectedCount);
        }
    }
}

