/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.ScoreSupplier;
import io.servicetalk.loadbalancer.RequestTracker;
import io.servicetalk.utils.internal.NumberUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;

abstract class DefaultRequestTracker
implements RequestTracker,
ScoreSupplier {
    private static final long MAX_MS_TO_NS = TimeUnit.NANOSECONDS.convert(Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
    private final StampedLock lock = new StampedLock();
    private final double invTau;
    private final int cancelPenalty;
    private final int errorPenalty;
    private final int concurrentRequestPenalty;
    private long lastTimeNanos;
    private int ewma;
    private int concurrentCount;
    private long concurrentStamp = Long.MIN_VALUE;

    DefaultRequestTracker(long halfLifeNanos, int cancelPenalty, int errorPenalty, int concurrentRequestPenalty) {
        NumberUtils.ensurePositive(halfLifeNanos, "halfLifeNanos");
        this.invTau = Math.pow((double)halfLifeNanos / Math.log(2.0), -1.0);
        this.cancelPenalty = cancelPenalty;
        this.errorPenalty = errorPenalty;
        this.concurrentRequestPenalty = concurrentRequestPenalty;
    }

    protected abstract long currentTimeNanos();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long beforeRequestStart() {
        long stamp = this.lock.writeLock();
        try {
            long timestamp = this.currentTimeNanos();
            ++this.concurrentCount;
            if (this.concurrentStamp == Long.MIN_VALUE) {
                this.concurrentStamp = timestamp;
            }
            long l = timestamp;
            return l;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    @Override
    public void onRequestSuccess(long startTimeNanos) {
        this.onComplete(startTimeNanos, 0);
    }

    @Override
    public void onRequestError(long startTimeNanos, RequestTracker.ErrorClass errorClass) {
        this.onComplete(startTimeNanos, errorClass == RequestTracker.ErrorClass.CANCELLED ? this.cancelPenalty : this.errorPenalty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onComplete(long startTimeNanos, int penalty) {
        long stamp = this.lock.writeLock();
        try {
            --this.concurrentCount;
            this.concurrentStamp = Long.MIN_VALUE;
            this.updateEwma(penalty, startTimeNanos);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int score() {
        int concurrentPenalty;
        long concurrentStamp;
        int concurrentCount;
        long lastTimeNanos;
        int currentEWMA;
        long stamp = this.lock.readLock();
        try {
            currentEWMA = this.ewma;
            lastTimeNanos = this.lastTimeNanos;
            concurrentCount = this.concurrentCount;
            concurrentStamp = this.concurrentStamp;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
        long currentTimeNanos = this.currentTimeNanos();
        if (currentEWMA != 0) {
            double tmp = (double)(currentTimeNanos - lastTimeNanos) * this.invTau;
            double w = Math.exp(-tmp);
            currentEWMA = (int)Math.ceil((double)currentEWMA * w);
        }
        if (currentEWMA == 0) {
            return concurrentCount == 0 ? 0 : Integer.MIN_VALUE;
        }
        if (concurrentCount > 0 && concurrentStamp != Long.MIN_VALUE) {
            currentEWMA = Integer.max(currentEWMA, DefaultRequestTracker.nanoToMillis(currentTimeNanos - concurrentStamp));
        }
        return Integer.MAX_VALUE - currentEWMA <= (concurrentPenalty = DefaultRequestTracker.safeMultiply(concurrentCount, DefaultRequestTracker.safeMultiply(currentEWMA, this.concurrentRequestPenalty))) ? Integer.MIN_VALUE : -(currentEWMA + concurrentPenalty);
    }

    private static int applyPenalty(int currentEWMA, int currentLatency, int penalty) {
        return (int)Long.min(Integer.MAX_VALUE, Long.max(currentEWMA, currentLatency) * (long)penalty);
    }

    private void updateEwma(int penalty, long startTimeNanos) {
        assert (this.lock.isWriteLocked());
        long currentTimeNanos = this.currentTimeNanos();
        int currentEWMA = this.ewma;
        int currentLatency = penalty > 0 ? DefaultRequestTracker.applyPenalty(currentEWMA, DefaultRequestTracker.nanoToMillis(currentTimeNanos - startTimeNanos), penalty) : DefaultRequestTracker.nanoToMillis(currentTimeNanos - startTimeNanos);
        assert (currentLatency >= 0);
        int nextEWMA = currentLatency > currentEWMA ? currentLatency : DefaultRequestTracker.calculateDecay(currentTimeNanos, this.lastTimeNanos, currentEWMA, currentLatency, this.invTau);
        this.lastTimeNanos = currentTimeNanos;
        this.ewma = nextEWMA;
    }

    private static int calculateDecay(long currentTimeNanos, long lastTimeNanos, long currentEWMA, int currentLatency, double invTau) {
        double tmp = (double)(currentTimeNanos - lastTimeNanos) * invTau;
        double w = Math.exp(-tmp);
        return (int)Math.ceil((double)currentEWMA * w + (double)currentLatency * (1.0 - w));
    }

    private static int nanoToMillis(long nanos) {
        return (int)Long.min(Integer.MAX_VALUE, TimeUnit.MILLISECONDS.convert(Long.min(nanos, MAX_MS_TO_NS), TimeUnit.NANOSECONDS));
    }

    private static int safeMultiply(int a, int b) {
        long result = (long)a * (long)b;
        return (int)Long.min(Integer.MAX_VALUE, result);
    }
}

