/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.client.api.LoadBalancer;
import io.servicetalk.client.api.LoadBalancerFactory;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.loadbalancer.ConnectionPoolConfig;
import io.servicetalk.loadbalancer.ConnectionPoolStrategy;
import io.servicetalk.loadbalancer.CorePoolConnectionPoolStrategy;
import io.servicetalk.loadbalancer.DefaultHostPriorityStrategy;
import io.servicetalk.loadbalancer.DefaultLoadBalancer;
import io.servicetalk.loadbalancer.HealthCheckConfig;
import io.servicetalk.loadbalancer.LinearSearchConnectionPoolStrategy;
import io.servicetalk.loadbalancer.LoadBalancerBuilder;
import io.servicetalk.loadbalancer.LoadBalancerObserverFactory;
import io.servicetalk.loadbalancer.LoadBalancingPolicies;
import io.servicetalk.loadbalancer.LoadBalancingPolicy;
import io.servicetalk.loadbalancer.NoopLoadBalancerObserver;
import io.servicetalk.loadbalancer.NoopOutlierDetector;
import io.servicetalk.loadbalancer.NormalizedTimeSourceExecutor;
import io.servicetalk.loadbalancer.OutlierDetectorConfig;
import io.servicetalk.loadbalancer.P2CConnectionPoolStrategy;
import io.servicetalk.loadbalancer.RoundRobinLoadBalancerFactory;
import io.servicetalk.loadbalancer.XdsOutlierDetector;
import io.servicetalk.transport.api.ExecutionStrategy;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

final class DefaultLoadBalancerBuilder<ResolvedAddress, C extends LoadBalancedConnection>
implements LoadBalancerBuilder<ResolvedAddress, C> {
    private final String id;
    private LoadBalancingPolicy<ResolvedAddress, C> loadBalancingPolicy = DefaultLoadBalancerBuilder.defaultLoadBalancingPolicy();
    @Nullable
    private Executor backgroundExecutor;
    @Nullable
    private LoadBalancerObserverFactory loadBalancerObserverFactory;
    private ConnectionPoolStrategy.ConnectionPoolStrategyFactory<C> connectionPoolStrategyFactory = DefaultLoadBalancerBuilder.defaultConnectionPoolStrategyFactory();
    private OutlierDetectorConfig outlierDetectorConfig = OutlierDetectorConfig.DEFAULT_CONFIG;

    DefaultLoadBalancerBuilder(String id) {
        this.id = Objects.requireNonNull(id, "id");
    }

    @Override
    public LoadBalancerBuilder<ResolvedAddress, C> loadBalancingPolicy(LoadBalancingPolicy<ResolvedAddress, C> loadBalancingPolicy) {
        this.loadBalancingPolicy = Objects.requireNonNull(loadBalancingPolicy, "loadBalancingPolicy");
        return this;
    }

    @Override
    public LoadBalancerBuilder<ResolvedAddress, C> loadBalancerObserver(@Nullable LoadBalancerObserverFactory loadBalancerObserverFactory) {
        this.loadBalancerObserverFactory = loadBalancerObserverFactory;
        return this;
    }

    @Override
    public LoadBalancerBuilder<ResolvedAddress, C> outlierDetectorConfig(OutlierDetectorConfig outlierDetectorConfig) {
        this.outlierDetectorConfig = Objects.requireNonNull(outlierDetectorConfig, "outlierDetectorConfig");
        return this;
    }

    @Override
    public LoadBalancerBuilder<ResolvedAddress, C> connectionPoolConfig(ConnectionPoolConfig connectionPoolConfig) {
        this.connectionPoolStrategyFactory = DefaultLoadBalancerBuilder.convertPoolStrategy(Objects.requireNonNull(connectionPoolConfig, "connectionPoolConfig"));
        return this;
    }

    @Override
    public LoadBalancerBuilder<ResolvedAddress, C> backgroundExecutor(Executor backgroundExecutor) {
        this.backgroundExecutor = new NormalizedTimeSourceExecutor(backgroundExecutor);
        return this;
    }

    @Override
    public LoadBalancerFactory<ResolvedAddress, C> build() {
        return new DefaultLoadBalancerFactory<ResolvedAddress, C>(this.id, this.loadBalancingPolicy, this.loadBalancerObserverFactory, this.connectionPoolStrategyFactory, this.outlierDetectorConfig, this.getExecutor());
    }

    private Executor getExecutor() {
        return this.backgroundExecutor == null ? RoundRobinLoadBalancerFactory.SharedExecutor.getInstance() : this.backgroundExecutor;
    }

    private static <C extends LoadBalancedConnection> ConnectionPoolStrategy.ConnectionPoolStrategyFactory<C> convertPoolStrategy(ConnectionPoolConfig connectionPoolStrategyConfig) {
        if (connectionPoolStrategyConfig instanceof ConnectionPoolConfig.P2CStrategy) {
            ConnectionPoolConfig.P2CStrategy strategy = (ConnectionPoolConfig.P2CStrategy)connectionPoolStrategyConfig;
            return P2CConnectionPoolStrategy.factory(strategy.maxEffort, strategy.corePoolSize, strategy.forceCorePool);
        }
        if (connectionPoolStrategyConfig instanceof ConnectionPoolConfig.CorePoolStrategy) {
            ConnectionPoolConfig.CorePoolStrategy strategy = (ConnectionPoolConfig.CorePoolStrategy)connectionPoolStrategyConfig;
            return CorePoolConnectionPoolStrategy.factory(strategy.corePoolSize, strategy.forceCorePool);
        }
        if (connectionPoolStrategyConfig instanceof ConnectionPoolConfig.LinearSearchStrategy) {
            ConnectionPoolConfig.LinearSearchStrategy strategy = (ConnectionPoolConfig.LinearSearchStrategy)connectionPoolStrategyConfig;
            return LinearSearchConnectionPoolStrategy.factory(strategy.linearSearchSpace);
        }
        throw new IllegalStateException("Unexpected ConnectionPoolConfig: " + connectionPoolStrategyConfig.getClass().getName());
    }

    private static <ResolvedAddress, C extends LoadBalancedConnection> LoadBalancingPolicy<ResolvedAddress, C> defaultLoadBalancingPolicy() {
        return LoadBalancingPolicies.roundRobin().build();
    }

    private static <C extends LoadBalancedConnection> ConnectionPoolStrategy.ConnectionPoolStrategyFactory<C> defaultConnectionPoolStrategyFactory() {
        return DefaultLoadBalancerBuilder.convertPoolStrategy(ConnectionPoolConfig.linearSearch());
    }

    static final class DefaultLoadBalancerFactory<ResolvedAddress, C extends LoadBalancedConnection>
    implements LoadBalancerFactory<ResolvedAddress, C> {
        private final String id;
        private final LoadBalancingPolicy<ResolvedAddress, C> loadBalancingPolicy;
        @Nullable
        private final LoadBalancerObserverFactory loadBalancerObserverFactory;
        private final ConnectionPoolStrategy.ConnectionPoolStrategyFactory<C> connectionPoolStrategyFactory;
        private final OutlierDetectorConfig outlierDetectorConfig;
        private final Executor executor;

        DefaultLoadBalancerFactory(String id, LoadBalancingPolicy<ResolvedAddress, C> loadBalancingPolicy, @Nullable LoadBalancerObserverFactory loadBalancerObserverFactory, ConnectionPoolStrategy.ConnectionPoolStrategyFactory<C> connectionPoolStrategyFactory, OutlierDetectorConfig outlierDetectorConfig, Executor executor) {
            this.id = Objects.requireNonNull(id, "id");
            this.loadBalancingPolicy = Objects.requireNonNull(loadBalancingPolicy, "loadBalancingPolicy");
            this.loadBalancerObserverFactory = loadBalancerObserverFactory;
            this.outlierDetectorConfig = Objects.requireNonNull(outlierDetectorConfig, "outlierDetectorConfig");
            this.connectionPoolStrategyFactory = Objects.requireNonNull(connectionPoolStrategyFactory, "connectionPoolStrategyFactory");
            this.executor = Objects.requireNonNull(executor, "executor");
        }

        @Override
        public <T extends C> LoadBalancer<T> newLoadBalancer(String targetResource, Publisher<? extends Collection<? extends ServiceDiscovererEvent<ResolvedAddress>>> eventPublisher, ConnectionFactory<ResolvedAddress, T> connectionFactory) {
            throw new UnsupportedOperationException("Generic constructor not supported by " + DefaultLoadBalancer.class.getSimpleName());
        }

        @Override
        public <T extends C> LoadBalancer<T> newLoadBalancer(Publisher<? extends ServiceDiscovererEvent<ResolvedAddress>> eventPublisher, ConnectionFactory<ResolvedAddress, T> connectionFactory) {
            throw new UnsupportedOperationException("Generic constructor not supported by " + DefaultLoadBalancer.class.getSimpleName());
        }

        @Override
        public LoadBalancer<C> newLoadBalancer(Publisher<? extends Collection<? extends ServiceDiscovererEvent<ResolvedAddress>>> eventPublisher, ConnectionFactory<ResolvedAddress, C> connectionFactory, String targetResource) {
            HealthCheckConfig healthCheckConfig = OutlierDetectorConfig.allDisabled(this.outlierDetectorConfig) ? null : new HealthCheckConfig(this.executor, this.outlierDetectorConfig.failureDetectorInterval(), this.outlierDetectorConfig.failureDetectorIntervalJitter(), this.outlierDetectorConfig.failedConnectionsThreshold(), this.outlierDetectorConfig.serviceDiscoveryResubscribeInterval(), this.outlierDetectorConfig.serviceDiscoveryResubscribeJitter());
            LoadBalancerObserverFactory loadBalancerObserverFactory = this.loadBalancerObserverFactory != null ? this.loadBalancerObserverFactory : NoopLoadBalancerObserver.factory();
            Function outlierDetectorFactory = OutlierDetectorConfig.xDSDisabled(this.outlierDetectorConfig) ? lbDescription -> new NoopOutlierDetector(this.outlierDetectorConfig, this.executor) : lbDescription -> new XdsOutlierDetector(this.executor, this.outlierDetectorConfig, (String)lbDescription);
            return new DefaultLoadBalancer<ResolvedAddress, C>(this.id, targetResource, eventPublisher, DefaultHostPriorityStrategy::new, this.loadBalancingPolicy, this.connectionPoolStrategyFactory, connectionFactory, loadBalancerObserverFactory, healthCheckConfig, outlierDetectorFactory);
        }

        @Override
        public ExecutionStrategy requiredOffloads() {
            return ExecutionStrategy.offloadNone();
        }

        public String toString() {
            return "DefaultLoadBalancerFactory{id='" + this.id + '\'' + ", loadBalancingPolicy=" + this.loadBalancingPolicy + ", loadBalancerObserverFactory=" + this.loadBalancerObserverFactory + ", connectionPoolStrategyFactory=" + this.connectionPoolStrategyFactory + ", outlierDetectorConfig=" + this.outlierDetectorConfig + ", executor=" + this.executor + '}';
        }
    }
}

