/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.client.api.LoadBalancerReadyEvent;
import io.servicetalk.client.api.NoActiveHostException;
import io.servicetalk.client.api.NoAvailableHostException;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Processors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.loadbalancer.ConnectionPoolStrategy;
import io.servicetalk.loadbalancer.DefaultHost;
import io.servicetalk.loadbalancer.HealthCheckConfig;
import io.servicetalk.loadbalancer.HealthIndicator;
import io.servicetalk.loadbalancer.Host;
import io.servicetalk.loadbalancer.HostPriorityStrategy;
import io.servicetalk.loadbalancer.HostSelector;
import io.servicetalk.loadbalancer.LoadBalancerObserver;
import io.servicetalk.loadbalancer.LoadBalancerObserverFactory;
import io.servicetalk.loadbalancer.LoadBalancingPolicy;
import io.servicetalk.loadbalancer.NormalizedTimeSourceExecutor;
import io.servicetalk.loadbalancer.OutlierDetector;
import io.servicetalk.loadbalancer.PrioritizedHost;
import io.servicetalk.loadbalancer.RichServiceDiscovererEvent;
import io.servicetalk.loadbalancer.SequentialExecutor;
import io.servicetalk.loadbalancer.TestableLoadBalancer;
import io.servicetalk.utils.internal.NumberUtils;
import io.servicetalk.utils.internal.RandomUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultLoadBalancer<ResolvedAddress, C extends LoadBalancedConnection>
implements TestableLoadBalancer<ResolvedAddress, C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLoadBalancer.class);
    private static final AtomicLongFieldUpdater<DefaultLoadBalancer> nextResubscribeTimeUpdater = AtomicLongFieldUpdater.newUpdater(DefaultLoadBalancer.class, "nextResubscribeTime");
    private static final long RESUBSCRIBING = -1L;
    private volatile long nextResubscribeTime = -1L;
    @Nullable
    private volatile EventSubscriber currentSubscriber;
    private volatile HostSelector<ResolvedAddress, C> hostSelector;
    private List<PrioritizedHostImpl<ResolvedAddress, C>> usedHosts = Collections.emptyList();
    private boolean isClosed;
    private final SequentialExecutor sequentialExecutor;
    private final String lbDescription;
    private final Publisher<? extends Collection<? extends ServiceDiscovererEvent<ResolvedAddress>>> eventPublisher;
    private final PublisherSource.Processor<Object, Object> eventStreamProcessor = Processors.newPublisherProcessorDropHeadOnOverflow(32);
    private final Publisher<Object> eventStream;
    private final SequentialCancellable discoveryCancellable = new SequentialCancellable();
    private final ConnectionPoolStrategy<C> connectionPoolStrategy;
    private final ConnectionFactory<ResolvedAddress, ? extends C> connectionFactory;
    @Nullable
    private final HealthCheckConfig healthCheckConfig;
    private final HostPriorityStrategy priorityStrategy;
    private final OutlierDetector<ResolvedAddress, C> outlierDetector;
    private final Cancellable outlierDetectorStatusChangeStream;
    private final LoadBalancerObserver loadBalancerObserver;
    private final ListenableAsyncCloseable asyncCloseable;

    DefaultLoadBalancer(String id, String targetResource, Publisher<? extends Collection<? extends ServiceDiscovererEvent<ResolvedAddress>>> eventPublisher, Function<String, HostPriorityStrategy> priorityStrategyFactory, LoadBalancingPolicy<ResolvedAddress, C> loadBalancingPolicy, ConnectionPoolStrategy.ConnectionPoolStrategyFactory<C> connectionPoolStrategyFactory, ConnectionFactory<ResolvedAddress, ? extends C> connectionFactory, LoadBalancerObserverFactory loadBalancerObserverFactory, @Nullable HealthCheckConfig healthCheckConfig, Function<String, OutlierDetector<ResolvedAddress, C>> outlierDetectorFactory) {
        this.lbDescription = this.makeDescription(Objects.requireNonNull(id, "id"), Objects.requireNonNull(targetResource, "targetResource"));
        this.hostSelector = Objects.requireNonNull(loadBalancingPolicy, "loadBalancingPolicy").buildSelector(Collections.emptyList(), this.lbDescription);
        this.priorityStrategy = Objects.requireNonNull(priorityStrategyFactory, "priorityStrategyFactory").apply(this.lbDescription);
        this.connectionPoolStrategy = Objects.requireNonNull(connectionPoolStrategyFactory, "connectionPoolStrategyFactory").buildStrategy(this.lbDescription);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.eventStream = SourceAdapters.fromSource(this.eventStreamProcessor).replay(1);
        this.connectionFactory = Objects.requireNonNull(connectionFactory);
        this.loadBalancerObserver = Objects.requireNonNull(loadBalancerObserverFactory, "loadBalancerObserverFactory").newObserver(this.lbDescription);
        this.healthCheckConfig = healthCheckConfig;
        this.sequentialExecutor = new SequentialExecutor(uncaughtException -> LOGGER.error("{}: Uncaught exception in {}", this, this.getClass().getSimpleName(), uncaughtException));
        this.asyncCloseable = AsyncCloseables.toAsyncCloseable(this::doClose);
        this.eventStream.ignoreElements().subscribe();
        this.outlierDetector = Objects.requireNonNull(outlierDetectorFactory, "outlierDetectorFactory").apply(this.lbDescription);
        this.outlierDetectorStatusChangeStream = this.outlierDetector.healthStatusChanged().forEach(ignored -> this.sequentialExecutor.execute(() -> this.sequentialUpdateUsedHosts(this.usedHosts)));
        this.subscribeToEvents(false);
        LOGGER.info("{}: starting load balancer. Load balancing policy: {}, outlier detection: {}", this, loadBalancingPolicy, this.outlierDetector);
    }

    private void subscribeToEvents(boolean resubscribe) {
        EventSubscriber eventSubscriber;
        assert (this.nextResubscribeTime == -1L);
        if (resubscribe) {
            assert (this.healthCheckConfig != null) : "Resubscribe can happen only when health-checking is configured";
            LOGGER.debug("{}: resubscribing to the ServiceDiscoverer event publisher.", (Object)this);
            this.discoveryCancellable.cancelCurrent();
        }
        this.currentSubscriber = eventSubscriber = new EventSubscriber(resubscribe);
        SourceAdapters.toSource(this.eventPublisher).subscribe(eventSubscriber);
        if (this.healthCheckConfig != null) {
            assert (this.healthCheckConfig.executor instanceof NormalizedTimeSourceExecutor);
            this.nextResubscribeTime = DefaultLoadBalancer.nextResubscribeTime(this.healthCheckConfig, this);
        }
    }

    private Completable doClose(boolean graceful) {
        CompletableSource.Processor processor = Processors.newCompletableProcessor();
        this.sequentialExecutor.execute(() -> {
            try {
                if (!this.isClosed) {
                    this.discoveryCancellable.cancel();
                    this.eventStreamProcessor.onComplete();
                    this.outlierDetectorStatusChangeStream.cancel();
                    this.outlierDetector.cancel();
                }
                this.isClosed = true;
                List<PrioritizedHostImpl<ResolvedAddress, C>> currentList = this.usedHosts;
                CompositeCloseable compositeCloseable = AsyncCloseables.newCompositeCloseable().appendAll(currentList).appendAll(this.connectionFactory);
                LOGGER.debug("{} is closing {}gracefully. Last seen addresses (size={}): {}.", this, graceful ? "" : "non", currentList.size(), currentList);
                SourceAdapters.toSource(graceful ? compositeCloseable.closeAsyncGracefully() : compositeCloseable.closeAsync().beforeOnError(t -> this.sequentialExecutor.execute(this::sequentialCompleteClosed)).beforeOnComplete(() -> this.sequentialExecutor.execute(this::sequentialCompleteClosed))).subscribe(processor);
            }
            catch (Throwable ex) {
                processor.onError(ex);
            }
        });
        return SourceAdapters.fromSource(processor);
    }

    private void sequentialCompleteClosed() {
        this.usedHosts = Collections.emptyList();
        this.hostSelector = new ClosedHostSelector();
    }

    private static <R, C extends LoadBalancedConnection> long nextResubscribeTime(HealthCheckConfig config, DefaultLoadBalancer<R, C> lb) {
        long lowerNanos = config.healthCheckResubscribeLowerBound;
        long upperNanos = config.healthCheckResubscribeUpperBound;
        long currentTimeNanos = config.executor.currentTime(TimeUnit.NANOSECONDS);
        long result = currentTimeNanos + RandomUtils.nextLongInclusive(lowerNanos, upperNanos);
        LOGGER.debug("{}: current time {}, next resubscribe attempt can be performed at {}.", lb, currentTimeNanos, result);
        return result;
    }

    private static <ResolvedAddress, C extends LoadBalancedConnection> boolean contains(Host<ResolvedAddress, C> host, Collection<? extends ServiceDiscovererEvent<ResolvedAddress>> events) {
        for (ServiceDiscovererEvent<ResolvedAddress> event : events) {
            if (!host.address().equals(event.address())) continue;
            return true;
        }
        return false;
    }

    private void sequentialUpdateUsedHosts(List<PrioritizedHostImpl<ResolvedAddress, C>> nextHosts) {
        this.usedHosts = nextHosts;
        for (PrioritizedHostImpl<ResolvedAddress, C> host : nextHosts) {
            host.loadBalancingWeight(host.serviceDiscoveryWeight());
        }
        nextHosts = this.priorityStrategy.prioritize(nextHosts);
        this.hostSelector = this.hostSelector.rebuildWithHosts(nextHosts);
        this.loadBalancerObserver.onHostSetChanged(Collections.unmodifiableList(nextHosts));
    }

    @Override
    public Single<C> selectConnection(Predicate<C> selector, @Nullable ContextMap context) {
        return Single.defer(() -> this.selectConnection0(selector, context, false).shareContextOnSubscribe());
    }

    @Override
    public Single<C> newConnection(@Nullable ContextMap context) {
        return Single.defer(() -> this.selectConnection0(c -> true, context, true).shareContextOnSubscribe());
    }

    private Single<C> selectConnection0(Predicate<C> selector, @Nullable ContextMap context, boolean forceNewConnectionAndReserve) {
        HostSelector<ResolvedAddress, C> currentHostSelector = this.hostSelector;
        Single<C> result = currentHostSelector.selectConnection(selector, context, forceNewConnectionAndReserve);
        return result.beforeOnError(exn -> {
            if (exn instanceof NoActiveHostException) {
                long currNextResubscribeTime;
                if (this.healthCheckConfig != null && !currentHostSelector.isHealthy() && (currNextResubscribeTime = this.nextResubscribeTime) >= 0L && this.healthCheckConfig.executor.currentTime(TimeUnit.NANOSECONDS) >= currNextResubscribeTime && nextResubscribeTimeUpdater.compareAndSet(this, currNextResubscribeTime, -1L)) {
                    this.subscribeToEvents(true);
                }
                this.loadBalancerObserver.onNoActiveHostsAvailable(currentHostSelector.hostSetSize(), (NoActiveHostException)exn);
            } else if (exn instanceof NoAvailableHostException) {
                this.loadBalancerObserver.onNoHostsAvailable();
            }
        });
    }

    @Override
    public Publisher<Object> eventStream() {
        return this.eventStream;
    }

    public String toString() {
        return this.lbDescription;
    }

    @Override
    public Completable onClose() {
        return this.asyncCloseable.onClose();
    }

    @Override
    public Completable onClosing() {
        return this.asyncCloseable.onClosing();
    }

    @Override
    public Completable closeAsync() {
        return this.asyncCloseable.closeAsync();
    }

    @Override
    public Completable closeAsyncGracefully() {
        return this.asyncCloseable.closeAsyncGracefully();
    }

    @Override
    public List<Map.Entry<ResolvedAddress, List<C>>> usedAddresses() {
        if (this.sequentialExecutor.isCurrentThreadDraining()) {
            return this.sequentialUsedAddresses();
        }
        SingleSource.Processor processor = Processors.newSingleProcessor();
        this.sequentialExecutor.execute(() -> processor.onSuccess(this.sequentialUsedAddresses()));
        try {
            return (List)SourceAdapters.fromSource(processor).toFuture().get();
        }
        catch (Exception ex) {
            throw new AssertionError("Failed to get results", ex);
        }
    }

    private List<Map.Entry<ResolvedAddress, List<C>>> sequentialUsedAddresses() {
        return this.usedHosts.stream().map(host -> ((DefaultHost)host.delegate()).asEntry()).collect(Collectors.toList());
    }

    private String makeDescription(String id, String targetResource) {
        return this.getClass().getSimpleName() + "{id=" + id + '@' + Integer.toHexString(System.identityHashCode(this)) + ", targetResource=" + targetResource + '}';
    }

    private static double eventWeight(ServiceDiscovererEvent<?> event) {
        if (event instanceof RichServiceDiscovererEvent) {
            return ((RichServiceDiscovererEvent)event).loadBalancingWeight();
        }
        return 1.0;
    }

    private static int eventPriority(ServiceDiscovererEvent<?> event) {
        if (event instanceof RichServiceDiscovererEvent) {
            return ((RichServiceDiscovererEvent)event).priority();
        }
        return 0;
    }

    List<PrioritizedHostImpl<ResolvedAddress, C>> hosts() {
        return new ArrayList<PrioritizedHostImpl<ResolvedAddress, C>>(this.usedHosts);
    }

    static final class PrioritizedHostImpl<ResolvedAddress, C extends LoadBalancedConnection>
    implements Host<ResolvedAddress, C>,
    PrioritizedHost,
    LoadBalancerObserver.Host {
        private final Host<ResolvedAddress, C> delegate;
        private int priority;
        private double serviceDiscoveryWeight;
        private double loadBalancingWeight;

        PrioritizedHostImpl(Host<ResolvedAddress, C> delegate, double serviceDiscoveryWeight, int priority) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
            this.priority = NumberUtils.ensureNonNegative(priority, "priority");
            this.serviceDiscoveryWeight = serviceDiscoveryWeight;
            this.loadBalancingWeight = serviceDiscoveryWeight;
        }

        Host<ResolvedAddress, C> delegate() {
            return this.delegate;
        }

        @Override
        public int priority() {
            return this.priority;
        }

        void priority(int priority) {
            this.priority = priority;
        }

        void serviceDiscoveryWeight(double weight) {
            this.serviceDiscoveryWeight = weight;
        }

        double serviceDiscoveryWeight() {
            return this.serviceDiscoveryWeight;
        }

        @Override
        public void loadBalancingWeight(double weight) {
            this.loadBalancingWeight = weight;
        }

        @Override
        public double loadBalancingWeight() {
            return this.loadBalancingWeight;
        }

        @Override
        public int score() {
            return this.delegate.score();
        }

        @Override
        public Completable closeAsync() {
            return this.delegate.closeAsync();
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.delegate.closeAsyncGracefully();
        }

        @Override
        public Completable onClose() {
            return this.delegate.onClose();
        }

        @Override
        public Completable onClosing() {
            return this.delegate.onClosing();
        }

        @Override
        @Nullable
        public C pickConnection(Predicate<C> selector, @Nullable ContextMap context) {
            return this.delegate.pickConnection(selector, context);
        }

        @Override
        public Single<C> newConnection(Predicate<C> selector, boolean forceNewConnectionAndReserve, @Nullable ContextMap context) {
            return this.delegate.newConnection(selector, forceNewConnectionAndReserve, context);
        }

        @Override
        public ResolvedAddress address() {
            return this.delegate.address();
        }

        @Override
        public boolean isHealthy() {
            return this.delegate.isHealthy();
        }

        @Override
        public boolean canMakeNewConnections() {
            return this.delegate.canMakeNewConnections();
        }

        @Override
        public boolean markActiveIfNotClosed() {
            return this.delegate.markActiveIfNotClosed();
        }

        @Override
        public boolean markExpired() {
            return this.delegate.markExpired();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(priority: " + this.priority + ", intrinsicWeight: " + this.serviceDiscoveryWeight + ", loadBalancedWeight: " + this.loadBalancingWeight + ", host: " + this.delegate + ")";
        }
    }

    private final class ClosedHostSelector
    implements HostSelector<ResolvedAddress, C> {
        private ClosedHostSelector() {
        }

        @Override
        public Single<C> selectConnection(Predicate<C> selector, @Nullable ContextMap context, boolean forceNewConnectionAndReserve) {
            return Single.failed(new IllegalStateException(DefaultLoadBalancer.this.lbDescription + ": LoadBalancer has closed"));
        }

        @Override
        public HostSelector<ResolvedAddress, C> rebuildWithHosts(List<? extends Host<ResolvedAddress, C>> hosts) {
            return this;
        }

        @Override
        public boolean isHealthy() {
            return false;
        }

        @Override
        public int hostSetSize() {
            return 0;
        }
    }

    private final class EventSubscriber
    implements PublisherSource.Subscriber<Collection<? extends ServiceDiscovererEvent<ResolvedAddress>>> {
        private boolean firstEventsAfterResubscribe;

        EventSubscriber(boolean resubscribe) {
            this.firstEventsAfterResubscribe = resubscribe;
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription s) {
            s.request(Long.MAX_VALUE);
            DefaultLoadBalancer.this.discoveryCancellable.nextCancellable(s);
        }

        @Override
        public void onNext(@Nullable Collection<? extends ServiceDiscovererEvent<ResolvedAddress>> events) {
            if (events == null || events.isEmpty()) {
                LOGGER.debug("{}: unexpectedly received null or empty collection instead of events: {}", (Object)DefaultLoadBalancer.this, (Object)events);
                return;
            }
            DefaultLoadBalancer.this.sequentialExecutor.execute(() -> this.sequentialOnNext(events));
        }

        private void sequentialOnNext(Collection<? extends ServiceDiscovererEvent<ResolvedAddress>> events) {
            assert (!events.isEmpty());
            if (DefaultLoadBalancer.this.isClosed) {
                return;
            }
            if (DefaultLoadBalancer.this.currentSubscriber != this) {
                LOGGER.debug("{}: received new events after cancelling previous subscription, discarding: {}", (Object)DefaultLoadBalancer.this, (Object)events);
                return;
            }
            boolean sendReadyEvent = false;
            ArrayList nextHosts = new ArrayList(DefaultLoadBalancer.this.usedHosts.size() + events.size());
            List oldUsedHosts = DefaultLoadBalancer.this.usedHosts;
            HashMap eventMap = new HashMap();
            for (ServiceDiscovererEvent event : events) {
                ServiceDiscovererEvent old = eventMap.put(event.address(), event);
                if (old == null) continue;
                LOGGER.debug("Multiple ServiceDiscoveryEvent's detected for address {}. Event: {}.", event.address(), (Object)event);
            }
            boolean hostSetChanged = false;
            for (Host host : oldUsedHosts) {
                ServiceDiscovererEvent event = (ServiceDiscovererEvent)eventMap.remove(((PrioritizedHostImpl)host).address());
                if (event == null) {
                    nextHosts.add(host);
                    continue;
                }
                double oldSDWeight = ((PrioritizedHostImpl)host).serviceDiscoveryWeight();
                int oldPriority = ((PrioritizedHostImpl)host).priority();
                ((PrioritizedHostImpl)host).serviceDiscoveryWeight(DefaultLoadBalancer.eventWeight(event));
                ((PrioritizedHostImpl)host).priority(DefaultLoadBalancer.eventPriority(event));
                hostSetChanged |= oldPriority != ((PrioritizedHostImpl)host).priority() || oldSDWeight != ((PrioritizedHostImpl)host).serviceDiscoveryWeight();
                if (ServiceDiscovererEvent.Status.AVAILABLE.equals(event.status())) {
                    sendReadyEvent = oldUsedHosts.isEmpty();
                    if (((PrioritizedHostImpl)host).markActiveIfNotClosed()) {
                        nextHosts.add(host);
                        continue;
                    }
                    hostSetChanged = true;
                    nextHosts.add(this.createHost(event));
                    continue;
                }
                if (ServiceDiscovererEvent.Status.EXPIRED.equals(event.status())) {
                    if (!((PrioritizedHostImpl)host).markExpired()) {
                        nextHosts.add(host);
                        continue;
                    }
                    hostSetChanged = true;
                    continue;
                }
                if (ServiceDiscovererEvent.Status.UNAVAILABLE.equals(event.status())) {
                    ((PrioritizedHostImpl)host).closeAsyncGracefully().beforeOnError(arg_0 -> EventSubscriber.lambda$sequentialOnNext$1((PrioritizedHostImpl)host, arg_0)).subscribe();
                    hostSetChanged = true;
                    continue;
                }
                LOGGER.warn("{}: Unsupported Status in event: {} (mapped to {}). Leaving usedHosts unchanged: {}", DefaultLoadBalancer.this, event, event.status(), nextHosts);
                nextHosts.add(host);
            }
            for (ServiceDiscovererEvent event : eventMap.values()) {
                if (!ServiceDiscovererEvent.Status.AVAILABLE.equals(event.status())) continue;
                sendReadyEvent = true;
                hostSetChanged = true;
                nextHosts.add(this.createHost(event));
            }
            DefaultLoadBalancer.this.loadBalancerObserver.onServiceDiscoveryEvent(events, DefaultLoadBalancer.this.usedHosts.size(), nextHosts.size());
            if (hostSetChanged) {
                DefaultLoadBalancer.this.sequentialUpdateUsedHosts(nextHosts);
            }
            LOGGER.debug("{}: now using addresses (size={}): {}.", DefaultLoadBalancer.this, nextHosts.size(), nextHosts);
            if (nextHosts.isEmpty()) {
                DefaultLoadBalancer.this.eventStreamProcessor.onNext(LoadBalancerReadyEvent.LOAD_BALANCER_NOT_READY_EVENT);
            } else if (sendReadyEvent) {
                DefaultLoadBalancer.this.eventStreamProcessor.onNext(LoadBalancerReadyEvent.LOAD_BALANCER_READY_EVENT);
            }
            if (this.firstEventsAfterResubscribe) {
                if (events.isEmpty()) {
                    return;
                }
                this.firstEventsAfterResubscribe = false;
                for (Host host : nextHosts) {
                    if (DefaultLoadBalancer.contains(host, events)) continue;
                    host.closeAsyncGracefully().subscribe();
                }
            }
        }

        private PrioritizedHostImpl<ResolvedAddress, C> createHost(ServiceDiscovererEvent<ResolvedAddress> event) {
            Object addr = event.address();
            LoadBalancerObserver.HostObserver hostObserver = DefaultLoadBalancer.this.loadBalancerObserver.hostObserver(addr);
            HealthIndicator indicator = DefaultLoadBalancer.this.outlierDetector.newHealthIndicator(addr, hostObserver);
            HealthCheckConfig hostHealthCheckConfig = DefaultLoadBalancer.this.healthCheckConfig == null || ((DefaultLoadBalancer)DefaultLoadBalancer.this).healthCheckConfig.failedThreshold < 0 ? null : DefaultLoadBalancer.this.healthCheckConfig;
            PrioritizedHostImpl host = new PrioritizedHostImpl(new DefaultHost(DefaultLoadBalancer.this.lbDescription, addr, DefaultLoadBalancer.this.connectionPoolStrategy, DefaultLoadBalancer.this.connectionFactory, hostObserver, hostHealthCheckConfig, indicator), DefaultLoadBalancer.eventWeight(event), DefaultLoadBalancer.eventPriority(event));
            indicator.setHost(host);
            host.onClose().afterFinally(() -> DefaultLoadBalancer.this.sequentialExecutor.execute(() -> {
                List currentHosts = DefaultLoadBalancer.this.usedHosts;
                if (currentHosts.isEmpty()) {
                    return;
                }
                List nextHosts = this.listWithHostRemoved(currentHosts, host);
                if (nextHosts.size() != currentHosts.size()) {
                    DefaultLoadBalancer.this.sequentialUpdateUsedHosts(nextHosts);
                    if (nextHosts.isEmpty()) {
                        DefaultLoadBalancer.this.eventStreamProcessor.onNext(LoadBalancerReadyEvent.LOAD_BALANCER_NOT_READY_EVENT);
                    }
                }
            })).subscribe();
            return host;
        }

        private List<PrioritizedHostImpl<ResolvedAddress, C>> listWithHostRemoved(List<PrioritizedHostImpl<ResolvedAddress, C>> oldHostsTyped, PrioritizedHostImpl<ResolvedAddress, C> toRemove) {
            int index = oldHostsTyped.indexOf(toRemove);
            if (index < 0) {
                return oldHostsTyped;
            }
            if (oldHostsTyped.size() == 1) {
                return Collections.emptyList();
            }
            ArrayList newHosts = new ArrayList(oldHostsTyped.size() - 1);
            for (int i = 0; i < oldHostsTyped.size(); ++i) {
                if (i == index) continue;
                newHosts.add(oldHostsTyped.get(i));
            }
            return newHosts;
        }

        @Override
        public void onError(Throwable t) {
            DefaultLoadBalancer.this.sequentialExecutor.execute(() -> {
                if (DefaultLoadBalancer.this.healthCheckConfig == null) {
                    DefaultLoadBalancer.this.eventStreamProcessor.onError(t);
                }
                List hosts = DefaultLoadBalancer.this.usedHosts;
                LOGGER.error("{}: service discoverer {} emitted an error. Last seen addresses (size={}): {}.", DefaultLoadBalancer.this, DefaultLoadBalancer.this.eventPublisher, hosts.size(), hosts, t);
            });
        }

        @Override
        public void onComplete() {
            DefaultLoadBalancer.this.sequentialExecutor.execute(() -> {
                List hosts = DefaultLoadBalancer.this.usedHosts;
                if (DefaultLoadBalancer.this.healthCheckConfig == null) {
                    DefaultLoadBalancer.this.eventStreamProcessor.onComplete();
                }
                LOGGER.error("{}: service discoverer completed. Last seen addresses (size={}): {}.", DefaultLoadBalancer.this, hosts.size(), hosts);
            });
        }

        private static /* synthetic */ void lambda$sequentialOnNext$1(PrioritizedHostImpl host, Throwable error) {
            LOGGER.warn("Closing host {} failed.", host.address(), (Object)error);
        }
    }
}

