/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.loadbalancer.HostPriorityStrategy;
import io.servicetalk.loadbalancer.PrioritizedHost;
import io.servicetalk.utils.internal.NumberUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultHostPriorityStrategy
implements HostPriorityStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHostPriorityStrategy.class);
    private static final int DEFAULT_OVER_PROVISION_FACTOR = 140;
    private final String lbDescription;
    private final int overProvisionPercentage;

    DefaultHostPriorityStrategy(String lbDescription) {
        this(lbDescription, 140);
    }

    DefaultHostPriorityStrategy(String lbDescription, int overProvisionPercentage) {
        this.lbDescription = Objects.requireNonNull(lbDescription, "lbDescription");
        this.overProvisionPercentage = NumberUtils.ensurePositive(overProvisionPercentage, "overProvisionPercentage");
    }

    @Override
    public <T extends PrioritizedHost> List<T> prioritize(List<T> hosts) {
        return hosts.isEmpty() ? hosts : this.rebuildWithPriorities(hosts);
    }

    private <T extends PrioritizedHost> List<T> rebuildWithPriorities(List<T> hosts) {
        assert (!hosts.isEmpty());
        TreeMap<Integer, Group> groups = new TreeMap<Integer, Group>();
        for (Object host : hosts) {
            if (host.priority() < 0) {
                LOGGER.warn("{}: Illegal priority: {} (expected priority >=0). Ignoring priority data.", (Object)this.lbDescription, (Object)host.priority());
                return hosts;
            }
            Group group = groups.computeIfAbsent(host.priority(), i -> new Group());
            if (host.isHealthy()) {
                ++group.healthyCount;
            }
            group.hosts.add(host);
        }
        if (groups.size() == 1) {
            LOGGER.debug("{}: Single priority group found.", (Object)this.lbDescription);
            return hosts;
        }
        int totalHealthPercentage = 0;
        for (Group group : groups.values()) {
            group.healthPercentage = Math.min(100, this.overProvisionPercentage * group.healthyCount / group.hosts.size());
            totalHealthPercentage = Math.min(100, totalHealthPercentage + group.healthPercentage);
        }
        if (totalHealthPercentage == 0) {
            LOGGER.warn("{}: No healthy priority groups found out of {} groups composed of {} hosts. Returning the un-prioritized set.", this.lbDescription, groups.size(), hosts.size());
            return hosts;
        }
        ArrayList weightedResults = new ArrayList();
        int activeGroups = 0;
        int remainingProbability = 100;
        for (Group group : groups.values()) {
            assert (!group.hosts.isEmpty());
            int groupProbability = Math.min(remainingProbability, group.healthPercentage * 100 / totalHealthPercentage);
            if (groupProbability > 0) {
                ++activeGroups;
                remainingProbability -= groupProbability;
                group.addToResults(groupProbability, weightedResults);
            }
            if (remainingProbability != 0) continue;
            break;
        }
        assert (!weightedResults.isEmpty());
        LOGGER.debug("{}: Host prioritization resulted in {} active groups with a total of {} active hosts.", this.lbDescription, activeGroups, weightedResults.size());
        return weightedResults;
    }

    private static double totalWeight(Iterable<? extends PrioritizedHost> hosts) {
        double sum = 0.0;
        for (PrioritizedHost prioritizedHost : hosts) {
            sum += prioritizedHost.loadBalancingWeight();
        }
        return sum;
    }

    private static class Group<H extends PrioritizedHost> {
        final List<H> hosts = new ArrayList<H>();
        int healthyCount;
        int healthPercentage;

        private Group() {
        }

        private void addToResults(int groupProbability, List<H> results) {
            double groupTotalWeight = DefaultHostPriorityStrategy.totalWeight(this.hosts);
            if (groupTotalWeight == 0.0) {
                double weight = (double)groupProbability / (double)this.hosts.size();
                for (PrioritizedHost host : this.hosts) {
                    host.loadBalancingWeight(weight);
                    results.add(host);
                }
            } else {
                double scalingFactor = (double)groupProbability / groupTotalWeight;
                for (PrioritizedHost host : this.hosts) {
                    double hostWeight = host.loadBalancingWeight() * scalingFactor;
                    host.loadBalancingWeight(hostWeight);
                    if (!(hostWeight > 0.0)) continue;
                    results.add(host);
                }
            }
        }
    }
}

