/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.loadbalancer.ConnectionPoolStrategy;
import io.servicetalk.utils.internal.NumberUtils;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class CorePoolConnectionPoolStrategy<C extends LoadBalancedConnection>
implements ConnectionPoolStrategy<C> {
    private final int corePoolSize;
    private final boolean forceCorePool;

    private CorePoolConnectionPoolStrategy(int corePoolSize, boolean forceCorePool) {
        this.corePoolSize = NumberUtils.ensurePositive(corePoolSize, "corePoolSize");
        this.forceCorePool = forceCorePool;
    }

    @Override
    @Nullable
    public C select(List<C> connections, Predicate<C> selector) {
        int i;
        int connectionCount = connections.size();
        if (this.forceCorePool && connectionCount < this.corePoolSize) {
            return null;
        }
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        int randomSearchSpace = Math.min(connectionCount, this.corePoolSize);
        int offset = rnd.nextInt(randomSearchSpace);
        for (i = 0; i < randomSearchSpace; ++i) {
            LoadBalancedConnection connection;
            int ii = offset + i;
            if (ii >= randomSearchSpace) {
                ii -= randomSearchSpace;
            }
            if (!selector.test(connection = (LoadBalancedConnection)connections.get(ii))) continue;
            return (C)connection;
        }
        for (i = randomSearchSpace; i < connectionCount; ++i) {
            LoadBalancedConnection connection = (LoadBalancedConnection)connections.get(i);
            if (!selector.test(connection)) continue;
            return (C)connection;
        }
        return null;
    }

    static <C extends LoadBalancedConnection> ConnectionPoolStrategy.ConnectionPoolStrategyFactory<C> factory(int corePoolSize, boolean forceCorePool) {
        return new CorePoolConnectionPoolStrategyFactory(corePoolSize, forceCorePool);
    }

    private static final class CorePoolConnectionPoolStrategyFactory<C extends LoadBalancedConnection>
    implements ConnectionPoolStrategy.ConnectionPoolStrategyFactory<C> {
        private final int corePoolSize;
        private final boolean forceCorePool;

        CorePoolConnectionPoolStrategyFactory(int corePoolSize, boolean forceCorePool) {
            this.corePoolSize = NumberUtils.ensurePositive(corePoolSize, "corePoolSize");
            this.forceCorePool = forceCorePool;
        }

        @Override
        public ConnectionPoolStrategy<C> buildStrategy(String lbDescription) {
            return new CorePoolConnectionPoolStrategy(this.corePoolSize, this.forceCorePool);
        }

        public String toString() {
            return "CorePoolConnectionPoolStrategyFactory{corePoolSize=" + this.corePoolSize + ", forceCorePool=" + this.forceCorePool + '}';
        }
    }
}

