/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.utils.internal.NumberUtils;

public abstract class ConnectionPoolConfig {
    static final int DEFAULT_MAX_EFFORT = 5;
    static final int DEFAULT_LINEAR_SEARCH_SPACE = 16;

    private ConnectionPoolConfig() {
    }

    public static ConnectionPoolConfig corePool(int corePoolSize, boolean forceCorePool) {
        return new CorePoolStrategy(corePoolSize, forceCorePool);
    }

    public static ConnectionPoolConfig linearSearch() {
        return ConnectionPoolConfig.linearSearch(16);
    }

    public static ConnectionPoolConfig linearSearch(int linearSearchSpace) {
        return new LinearSearchStrategy(linearSearchSpace);
    }

    public static ConnectionPoolConfig p2c(int corePoolSize, boolean forceCorePool) {
        return ConnectionPoolConfig.p2c(5, corePoolSize, forceCorePool);
    }

    public static ConnectionPoolConfig p2c(int maxEffort, int corePoolSize, boolean forceCorePool) {
        return new P2CStrategy(maxEffort, corePoolSize, forceCorePool);
    }

    static final class LinearSearchStrategy
    extends ConnectionPoolConfig {
        final int linearSearchSpace;

        LinearSearchStrategy(int linearSearchSpace) {
            this.linearSearchSpace = NumberUtils.ensurePositive(linearSearchSpace, "linearSearchSpace");
        }
    }

    static final class P2CStrategy
    extends ConnectionPoolConfig {
        final int maxEffort;
        final int corePoolSize;
        final boolean forceCorePool;

        P2CStrategy(int maxEffort, int corePoolSize, boolean forceCorePool) {
            this.maxEffort = NumberUtils.ensurePositive(maxEffort, "maxEffort");
            this.corePoolSize = NumberUtils.ensurePositive(corePoolSize, "corePoolSize");
            this.forceCorePool = forceCorePool;
        }
    }

    static final class CorePoolStrategy
    extends ConnectionPoolConfig {
        final int corePoolSize;
        final boolean forceCorePool;

        CorePoolStrategy(int corePoolSize, boolean forceCorePool) {
            this.corePoolSize = NumberUtils.ensurePositive(corePoolSize, "corePoolSize");
            this.forceCorePool = forceCorePool;
        }
    }
}

