/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.loadbalancer.Exceptions;
import io.servicetalk.loadbalancer.Host;
import io.servicetalk.loadbalancer.HostSelector;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;

abstract class BaseHostSelector<ResolvedAddress, C extends LoadBalancedConnection>
implements HostSelector<ResolvedAddress, C> {
    private static final double ACCEPTABLE_PERCENT_ERROR = 0.01;
    private final String lbDescription;
    private final List<? extends Host<ResolvedAddress, C>> hosts;

    BaseHostSelector(List<? extends Host<ResolvedAddress, C>> hosts, String lbDescription) {
        this.hosts = hosts;
        this.lbDescription = Objects.requireNonNull(lbDescription, "lbDescription");
    }

    protected abstract Single<C> selectConnection0(Predicate<C> var1, @Nullable ContextMap var2, boolean var3);

    @Override
    public final Single<C> selectConnection(Predicate<C> selector, @Nullable ContextMap context, boolean forceNewConnectionAndReserve) {
        return this.hosts.isEmpty() ? this.noHostsFailure() : this.selectConnection0(selector, context, forceNewConnectionAndReserve);
    }

    @Override
    public final int hostSetSize() {
        return this.hosts.size();
    }

    @Override
    public final boolean isHealthy() {
        return BaseHostSelector.anyHealthy(this.hosts);
    }

    protected final List<? extends Host<ResolvedAddress, C>> hosts() {
        return this.hosts;
    }

    protected final String lbDescription() {
        return this.lbDescription;
    }

    protected final Single<C> noActiveHostsFailure(List<? extends Host<ResolvedAddress, C>> usedHosts) {
        return Single.failed(Exceptions.StacklessNoActiveHostException.newInstance(this.lbDescription() + ": Failed to pick an active host. Either all are busy, expired, or unhealthy: " + usedHosts, this.getClass(), "selectConnection(...)"));
    }

    @Nullable
    protected final Single<C> selectFromHost(Host<ResolvedAddress, C> host, Predicate<C> selector, boolean forceNewConnectionAndReserve, @Nullable ContextMap contextMap) {
        C c;
        if (!forceNewConnectionAndReserve && (c = host.pickConnection(selector, contextMap)) != null) {
            return Single.succeeded(c);
        }
        return host.canMakeNewConnections() ? host.newConnection(selector, forceNewConnectionAndReserve, contextMap) : null;
    }

    private Single<C> noHostsFailure() {
        return Single.failed(Exceptions.StacklessNoAvailableHostException.newInstance(this.lbDescription() + ": No hosts are available to connect.", this.getClass(), "selectConnection(...)"));
    }

    static boolean approxEqual(double a, double b) {
        return Math.abs(a - b) < 0.01;
    }

    static boolean isNormalized(double[] probabilities) {
        double ptotal = 0.0;
        for (double p : probabilities) {
            ptotal += p;
        }
        return BaseHostSelector.approxEqual(ptotal, 1.0);
    }

    private static <ResolvedAddress, C extends LoadBalancedConnection> boolean anyHealthy(List<? extends Host<ResolvedAddress, C>> usedHosts) {
        for (Host<ResolvedAddress, C> host : usedHosts) {
            if (!host.isHealthy()) continue;
            return true;
        }
        return usedHosts.isEmpty();
    }
}

