/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.servicetalk.buffer.netty.BufferUtils;
import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.ProxyConnectException;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.netty.AbstractLBHttpConnectionFactory;
import io.servicetalk.http.netty.AlpnChannelSingle;
import io.servicetalk.http.netty.AlpnLBHttpConnectionFactory;
import io.servicetalk.http.netty.H1ProtocolConfig;
import io.servicetalk.http.netty.H2ClientParentChannelInitializer;
import io.servicetalk.http.netty.H2ClientParentConnectionContext;
import io.servicetalk.http.netty.H2ProtocolConfig;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.HttpClientChannelInitializer;
import io.servicetalk.http.netty.HttpDebugUtils;
import io.servicetalk.http.netty.HttpExecutionContextUtils;
import io.servicetalk.http.netty.HttpProtocolConfigs;
import io.servicetalk.http.netty.NoopChannelInitializer;
import io.servicetalk.http.netty.PipelinedStreamingHttpConnection;
import io.servicetalk.http.netty.ProxyConnectChannelSingle;
import io.servicetalk.http.netty.ReadOnlyHttpClientConfig;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpClientConfig;
import io.servicetalk.tcp.netty.internal.TcpClientChannelInitializer;
import io.servicetalk.tcp.netty.internal.TcpConnector;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.netty.internal.ChannelCloseUtils;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.transport.netty.internal.DefaultNettyConnection;
import io.servicetalk.transport.netty.internal.DeferSslHandler;
import io.servicetalk.transport.netty.internal.NettyConnection;
import io.servicetalk.transport.netty.internal.StacklessClosedChannelException;
import java.nio.channels.ClosedChannelException;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

final class ProxyConnectLBHttpConnectionFactory<ResolvedAddress>
extends AbstractLBHttpConnectionFactory<ResolvedAddress> {
    ProxyConnectLBHttpConnectionFactory(ReadOnlyHttpClientConfig config, HttpExecutionContext executionContext, @Nullable StreamingHttpConnectionFilterFactory connectionFilterFunction, StreamingHttpRequestResponseFactory reqRespFactory, ExecutionStrategy connectStrategy, ConnectionFactoryFilter<ResolvedAddress, FilterableStreamingHttpConnection> connectionFactoryFilter, AbstractLBHttpConnectionFactory.ProtocolBinding protocolBinding) {
        super(config, executionContext, (HttpProtocolVersion version) -> reqRespFactory, connectStrategy, connectionFactoryFilter, connectionFilterFunction, protocolBinding);
        assert (config.hasProxy()) : "Unexpected hasProxy flag";
        assert (config.tcpConfig().sslContext() != null) : "Proxy CONNECT works only for TLS connections";
        assert (config.proxyConfig() != null) : "ProxyConfig is required";
    }

    @Override
    Single<FilterableStreamingHttpConnection> newFilterableConnection(ResolvedAddress resolvedAddress, TransportObserver observer) {
        H1ProtocolConfig h1Config = this.config.h1Config() != null ? this.config.h1Config() : HttpProtocolConfigs.h1Default();
        return TcpConnector.connect(null, resolvedAddress, this.config.tcpConfig(), false, this.executionContext, (channel, connectionObserver) -> this.createConnection((Channel)channel, (ConnectionObserver)connectionObserver, h1Config), observer);
    }

    private Single<? extends FilterableStreamingHttpConnection> createConnection(Channel channel, ConnectionObserver observer, H1ProtocolConfig h1Config) {
        ChannelConfig channelConfig = channel.config();
        CloseHandler closeHandler = CloseHandler.forPipelinedRequestResponse(true, channelConfig);
        channelConfig.setOption(ChannelOption.ALLOW_HALF_CLOSURE, Boolean.FALSE);
        return new ProxyConnectChannelSingle(channel, new TcpClientChannelInitializer(this.config.tcpConfig(), observer, this.executionContext, true).andThen(new HttpClientChannelInitializer(BufferUtils.getByteBufAllocator(this.executionContext.bufferAllocator()), h1Config, closeHandler)), observer, h1Config.headersFactory(), this.config.proxyConfig()).flatMap(ProxyConnectLBHttpConnectionFactory::handshake).flatMap(protocol -> this.finishConnectionInitialization((String)protocol, channel, closeHandler, observer)).onErrorMap(cause -> ProxyConnectLBHttpConnectionFactory.handleException(cause, channel));
    }

    private static Single<String> handshake(Channel channel) {
        assert (channel.eventLoop().inEventLoop());
        DeferSslHandler deferSslHandler = channel.pipeline().get(DeferSslHandler.class);
        Single result = deferSslHandler == null ? (!channel.isActive() ? Single.failed(new ProxyConnectException(channel + " Connection is closed, either received a 'Connection: closed' header or closed by the proxy", StacklessClosedChannelException.newInstance(ProxyConnectLBHttpConnectionFactory.class, "handshake"))) : Single.failed(new ProxyConnectException(channel + " Unexpected connection state: failed to find a handler of type " + DeferSslHandler.class + " in the channel pipeline."))) : new AlpnChannelSingle(channel, NoopChannelInitializer.INSTANCE, ctx -> deferSslHandler.ready());
        return result.shareContextOnSubscribe();
    }

    private Single<? extends FilterableStreamingHttpConnection> finishConnectionInitialization(String protocol, Channel channel, CloseHandler closeHandler, ConnectionObserver connectionObserver) {
        Single<FilterableStreamingHttpConnection> result;
        assert (channel.eventLoop().inEventLoop());
        ReadOnlyTcpClientConfig tcpConfig = this.config.tcpConfig();
        switch (protocol) {
            case "http/1.1": {
                assert (this.config.h1Config() != null);
                channel.config().setOption(ChannelOption.ALLOW_HALF_CLOSURE, Boolean.TRUE);
                result = HttpDebugUtils.showPipeline(DefaultNettyConnection.initChannel(channel, HttpExecutionContextUtils.channelExecutionContext(channel, this.executionContext), closeHandler, tcpConfig.flushStrategy(), tcpConfig.idleTimeoutMs(), tcpConfig.sslConfig(), NoopChannelInitializer.INSTANCE, HttpProtocolVersion.HTTP_1_1, connectionObserver, true, HeaderUtils.OBJ_EXPECT_CONTINUE), HttpProtocolVersion.HTTP_1_1, channel).map(conn -> new PipelinedStreamingHttpConnection((NettyConnection<Object, Object>)conn, this.config.h1Config(), (StreamingHttpRequestResponseFactory)this.reqRespFactoryFunc.apply(HttpProtocolVersion.HTTP_1_1), this.config.allowDropTrailersReadFromTransport()));
                break;
            }
            case "h2": {
                ProxyConnectLBHttpConnectionFactory.removeH1Handlers(channel);
                H2ProtocolConfig h2Config = this.config.h2Config();
                assert (h2Config != null);
                result = H2ClientParentConnectionContext.initChannel(channel, this.executionContext, h2Config, (StreamingHttpRequestResponseFactory)this.reqRespFactoryFunc.apply(HttpProtocolVersion.HTTP_2_0), tcpConfig.flushStrategy(), tcpConfig.idleTimeoutMs(), tcpConfig.sslConfig(), new H2ClientParentChannelInitializer(h2Config), connectionObserver, this.config.allowDropTrailersReadFromTransport());
                break;
            }
            default: {
                result = AlpnLBHttpConnectionFactory.unknownAlpnProtocol(protocol);
            }
        }
        return result.shareContextOnSubscribe();
    }

    private static void removeH1Handlers(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        for (Class<? extends ChannelHandler> handlerClass : HttpClientChannelInitializer.handlers()) {
            pipeline.remove(handlerClass);
        }
    }

    private static Throwable handleException(Throwable cause, Channel channel) {
        if (channel.isActive()) {
            ChannelCloseUtils.close(channel, cause);
        }
        if (cause instanceof SSLException) {
            return cause;
        }
        if (cause instanceof ClosedChannelException) {
            return new ProxyConnectChannelSingle.RetryableProxyConnectException(channel + " Connection is closed, either received a 'Connection: closed' header or closed by the proxy", cause);
        }
        if (!(cause instanceof ProxyConnectException)) {
            return new ProxyConnectChannelSingle.RetryableProxyConnectException(channel + " Unexpected exception during an attempt to connect to a proxy", cause);
        }
        return cause;
    }
}

