/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.netty.DeferredServerChannelBinder;
import io.servicetalk.http.netty.H2ServerParentConnectionContext;
import io.servicetalk.http.netty.NettyHttpServer;
import io.servicetalk.http.netty.OptionalSslChannelSingle;
import io.servicetalk.http.netty.ReadOnlyHttpServerConfig;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpServerConfig;
import io.servicetalk.tcp.netty.internal.TcpServerBinder;
import io.servicetalk.tcp.netty.internal.TcpServerChannelInitializer;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.EarlyConnectionAcceptor;
import io.servicetalk.transport.api.LateConnectionAcceptor;
import io.servicetalk.transport.api.ServerContext;
import io.servicetalk.transport.netty.internal.InfluencerConnectionAcceptor;
import io.servicetalk.transport.netty.internal.NettyConnectionContext;
import java.net.SocketAddress;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OptionalSslNegotiator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptionalSslNegotiator.class);

    private OptionalSslNegotiator() {
    }

    static Single<HttpServerContext> bind(HttpExecutionContext executionContext, ReadOnlyHttpServerConfig roConfig, ReadOnlyHttpServerConfig roConfigWithoutSsl, SocketAddress listenAddress, @Nullable InfluencerConnectionAcceptor connectionAcceptor, StreamingHttpService service, boolean drainRequestPayloadBody, @Nullable EarlyConnectionAcceptor earlyConnectionAcceptor, @Nullable LateConnectionAcceptor lateConnectionAcceptor) {
        BiFunction channelInit = (channel, connectionObserver) -> new OptionalSslChannelSingle((Channel)channel).flatMap(isTls -> {
            assert (channel.eventLoop().inEventLoop());
            if (isTls.booleanValue()) {
                ReadOnlyTcpServerConfig roTcpConfig = roConfig.tcpConfig();
                if (roTcpConfig.isAlpnConfigured()) {
                    return DeferredServerChannelBinder.alpnInitChannel(listenAddress, channel, roConfig, executionContext, service, drainRequestPayloadBody, connectionObserver);
                }
                if (roTcpConfig.sniMapping() != null) {
                    return DeferredServerChannelBinder.sniInitChannel(listenAddress, channel, roConfig, executionContext, service, drainRequestPayloadBody, connectionObserver);
                }
                if (roConfig.isH2PriorKnowledge()) {
                    return H2ServerParentConnectionContext.initChannel(listenAddress, channel, executionContext, roConfig, new TcpServerChannelInitializer(roTcpConfig, (ConnectionObserver)connectionObserver, executionContext), service, drainRequestPayloadBody, connectionObserver);
                }
                return NettyHttpServer.initChannel(channel, executionContext, roConfig, new TcpServerChannelInitializer(roTcpConfig, (ConnectionObserver)connectionObserver, executionContext), service, drainRequestPayloadBody, connectionObserver);
            }
            if (roConfigWithoutSsl.h2Config() != null) {
                return H2ServerParentConnectionContext.initChannel(listenAddress, channel, executionContext, roConfigWithoutSsl, new TcpServerChannelInitializer(roConfigWithoutSsl.tcpConfig(), (ConnectionObserver)connectionObserver, executionContext), service, drainRequestPayloadBody, connectionObserver);
            }
            return NettyHttpServer.initChannel(channel, executionContext, roConfigWithoutSsl, new TcpServerChannelInitializer(roConfigWithoutSsl.tcpConfig(), (ConnectionObserver)connectionObserver, executionContext), service, drainRequestPayloadBody, connectionObserver);
        });
        Consumer<NettyConnectionContext> connectionConsumer = serverConnection -> {
            if (serverConnection instanceof NettyHttpServer.NettyHttpServerConnection) {
                ((NettyHttpServer.NettyHttpServerConnection)serverConnection).process(true);
            }
        };
        return TcpServerBinder.bind(listenAddress, roConfig.tcpConfig(), executionContext, connectionAcceptor, channelInit, connectionConsumer, earlyConnectionAcceptor, lateConnectionAcceptor).map(delegate -> {
            LOGGER.debug("Started HTTP server with Optional TLS for address {}", (Object)delegate.listenAddress());
            return new NettyHttpServer.NettyHttpServerContext((ServerContext)delegate, service, executionContext);
        });
    }
}

