/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslHandler;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.http.netty.ChannelInitSingle;
import io.servicetalk.http.netty.NoopChannelInitializer;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OptionalSslChannelSingle
extends ChannelInitSingle<Boolean> {
    OptionalSslChannelSingle(Channel channel) {
        super(channel, NoopChannelInitializer.INSTANCE);
    }

    @Override
    protected ChannelHandler newChannelHandler(SingleSource.Subscriber<? super Boolean> subscriber) {
        return new OptionalSslHandler(subscriber);
    }

    private static final class OptionalSslHandler
    extends ByteToMessageDecoder {
        private static final Logger LOGGER = LoggerFactory.getLogger(OptionalSslHandler.class);
        private static final int SSL_RECORD_HEADER_LENGTH = 5;
        @Nullable
        SingleSource.Subscriber<? super Boolean> subscriber;

        OptionalSslHandler(SingleSource.Subscriber<? super Boolean> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            if (ctx.channel().isActive()) {
                ctx.read();
            }
            super.handlerAdded(ctx);
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.read();
            ctx.fireChannelActive();
        }

        @Override
        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
            if (in.readableBytes() < 5 || this.subscriber == null) {
                return;
            }
            boolean isEncrypted = SslHandler.isEncrypted(in);
            LOGGER.debug("{} Detected TLS for this connection: {}", (Object)ctx.channel(), (Object)isEncrypted);
            SingleSource.Subscriber<? super Boolean> subscriberCopy = this.subscriber;
            this.subscriber = null;
            subscriberCopy.onSuccess((Boolean)isEncrypted);
            assert (ctx.executor().inEventLoop());
            assert (ctx.pipeline().last() != this);
            ctx.pipeline().remove(this);
        }
    }
}

