/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.http.api.HttpProviders;
import io.servicetalk.http.api.HttpServerBuilder;
import io.servicetalk.http.netty.DefaultHttpServerBuilder;
import io.servicetalk.utils.internal.ServiceLoaderUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpServers {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpServers.class);
    private static final List<HttpProviders.HttpServerBuilderProvider> PROVIDERS;

    private HttpServers() {
    }

    private static HttpServerBuilder applyProviders(SocketAddress address, HttpServerBuilder builder) {
        for (HttpProviders.HttpServerBuilderProvider provider : PROVIDERS) {
            builder = provider.newBuilder(address, builder);
        }
        return builder;
    }

    public static HttpServerBuilder forPort(int port) {
        InetSocketAddress address = new InetSocketAddress(port);
        return HttpServers.applyProviders(address, new DefaultHttpServerBuilder(address));
    }

    public static HttpServerBuilder forAddress(SocketAddress address) {
        return HttpServers.applyProviders(address, new DefaultHttpServerBuilder(address));
    }

    static {
        ClassLoader classLoader = HttpServers.class.getClassLoader();
        PROVIDERS = ServiceLoaderUtils.loadProviders(HttpProviders.HttpServerBuilderProvider.class, classLoader, LOGGER);
    }
}

