/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.DelegatingConnectionFactory;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpLifecycleObserver;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.netty.HttpLifecycleObserverRequesterFilter;
import io.servicetalk.http.netty.NoopHttpLifecycleObserver;
import io.servicetalk.loadbalancer.RequestTracker;
import io.servicetalk.transport.api.ConnectionInfo;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.TransportObserver;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpRequestTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestTracker.class);

    private HttpRequestTracker() {
    }

    static <ResolvedAddress> ConnectionFactoryFilter<ResolvedAddress, FilterableStreamingHttpConnection> filter() {
        return new ConnectionFactoryFilterImpl();
    }

    private static FilterableStreamingHttpConnection transformConnection(FilterableStreamingHttpConnection connection, ContextMap context) {
        RequestTracker requestTracker = context.remove(RequestTracker.REQUEST_TRACKER_KEY);
        if (requestTracker == null) {
            LOGGER.debug("{} is not set in context. In order for {} to get access to the {}, health-monitor of this connection, the context must be properly wired.", RequestTracker.REQUEST_TRACKER_KEY.name(), HttpRequestTracker.class.getSimpleName(), RequestTracker.class.getSimpleName());
            return connection;
        }
        LOGGER.debug("Added request tracker to connection {}.", (Object)connection.connectionContext());
        HttpLifecycleObserverRequesterFilter filter = new HttpLifecycleObserverRequesterFilter(new Observer(requestTracker));
        return filter.create(connection);
    }

    @Nullable
    private static RequestTracker.ErrorClass classifyResponse(HttpResponseMetaData resp) {
        return resp.status().statusClass() == HttpResponseStatus.StatusClass.SERVER_ERROR_5XX || HttpResponseStatus.TOO_MANY_REQUESTS.equals(resp.status()) ? RequestTracker.ErrorClass.EXT_ORIGIN_REQUEST_FAILED : null;
    }

    private static RequestTracker.ErrorClass classifyThrowable(Throwable error) {
        return error instanceof TimeoutException ? RequestTracker.ErrorClass.EXT_ORIGIN_TIMEOUT : RequestTracker.ErrorClass.LOCAL_ORIGIN_REQUEST_FAILED;
    }

    private static class Observer
    implements HttpLifecycleObserver {
        private final RequestTracker tracker;

        Observer(RequestTracker tracker) {
            this.tracker = tracker;
        }

        @Override
        public HttpLifecycleObserver.HttpExchangeObserver onNewExchange() {
            return new RequestTrackerExchangeObserver(this.tracker);
        }

        private static final class RequestTrackerExchangeObserver
        implements HttpLifecycleObserver.HttpExchangeObserver,
        HttpLifecycleObserver.HttpResponseObserver {
            private static final AtomicLongFieldUpdater<RequestTrackerExchangeObserver> START_TIME_UPDATER = AtomicLongFieldUpdater.newUpdater(RequestTrackerExchangeObserver.class, "startTime");
            private final RequestTracker tracker;
            private volatile long startTime = Long.MIN_VALUE;

            RequestTrackerExchangeObserver(RequestTracker tracker) {
                this.tracker = tracker;
            }

            @Override
            public void onConnectionSelected(ConnectionInfo info) {
            }

            @Override
            public HttpLifecycleObserver.HttpRequestObserver onRequest(HttpRequestMetaData requestMetaData) {
                START_TIME_UPDATER.set(this, this.tracker.beforeRequestStart());
                return NoopHttpLifecycleObserver.NoopHttpRequestObserver.INSTANCE;
            }

            @Override
            public HttpLifecycleObserver.HttpResponseObserver onResponse(HttpResponseMetaData responseMetaData) {
                long startTime;
                RequestTracker.ErrorClass error = HttpRequestTracker.classifyResponse(responseMetaData);
                if (error != null && this.checkOnce(startTime = this.finish())) {
                    this.tracker.onRequestError(startTime, error);
                }
                return this;
            }

            @Override
            public void onExchangeFinally() {
            }

            @Override
            public void onResponseError(Throwable cause) {
                long startTime = this.finish();
                if (this.checkOnce(startTime)) {
                    this.tracker.onRequestError(startTime, HttpRequestTracker.classifyThrowable(cause));
                }
            }

            @Override
            public void onResponseCancel() {
                long startTime = this.finish();
                if (this.checkOnce(startTime)) {
                    this.tracker.onRequestError(startTime, RequestTracker.ErrorClass.CANCELLED);
                }
            }

            @Override
            public void onResponseData(Buffer data) {
            }

            @Override
            public void onResponseTrailers(HttpHeaders trailers) {
            }

            @Override
            public void onResponseComplete() {
                long startTime = this.finish();
                if (this.checkOnce(startTime)) {
                    this.tracker.onRequestSuccess(startTime);
                }
            }

            private long finish() {
                return START_TIME_UPDATER.getAndSet(this, Long.MAX_VALUE);
            }

            private boolean checkOnce(long startTime) {
                return startTime != Long.MAX_VALUE && startTime != Long.MIN_VALUE;
            }
        }
    }

    private static final class RequestTrackerConnectionFactory<ResolvedAddress>
    extends DelegatingConnectionFactory<ResolvedAddress, FilterableStreamingHttpConnection> {
        RequestTrackerConnectionFactory(ConnectionFactory<ResolvedAddress, FilterableStreamingHttpConnection> delegate) {
            super(delegate);
        }

        @Override
        public Single<FilterableStreamingHttpConnection> newConnection(ResolvedAddress resolvedAddress, @Nullable ContextMap context, @Nullable TransportObserver observer) {
            Single<FilterableStreamingHttpConnection> result = this.delegate().newConnection(resolvedAddress, context, observer);
            if (context == null) {
                LOGGER.debug("Context is null. In order for {} to get access to the {}, health-monitor of this connection, the context must not be null.", (Object)HttpRequestTracker.class.getSimpleName(), (Object)RequestTracker.class.getSimpleName());
            } else {
                result = result.map(connection -> HttpRequestTracker.transformConnection(connection, context));
            }
            return result;
        }
    }

    private static final class ConnectionFactoryFilterImpl<ResolvedAddress>
    implements ConnectionFactoryFilter<ResolvedAddress, FilterableStreamingHttpConnection> {
        private ConnectionFactoryFilterImpl() {
        }

        @Override
        public ConnectionFactory<ResolvedAddress, FilterableStreamingHttpConnection> create(ConnectionFactory<ResolvedAddress, FilterableStreamingHttpConnection> original) {
            return new RequestTrackerConnectionFactory<ResolvedAddress>(original);
        }

        @Override
        public ExecutionStrategy requiredOffloads() {
            return ExecutionStrategy.offloadNone();
        }
    }
}

