/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.netty.H1ProtocolConfig;
import io.servicetalk.http.netty.HttpRequestEncoder;
import io.servicetalk.http.netty.HttpResponseDecoder;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.transport.netty.internal.CopyByteBufHandlerChannelInitializer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class HttpClientChannelInitializer
implements ChannelInitializer {
    private static final List<Class<? extends ChannelHandler>> HANDLERS = Collections.unmodifiableList(Arrays.asList(HttpRequestEncoder.class, HttpResponseDecoder.class, CopyByteBufHandlerChannelInitializer.handlerClass()));
    private final ChannelInitializer delegate;

    HttpClientChannelInitializer(ByteBufAllocator alloc, H1ProtocolConfig config, CloseHandler closeHandler) {
        this.delegate = new CopyByteBufHandlerChannelInitializer(alloc).andThen(channel -> {
            int minPipelinedRequests = Math.min(8, config.maxPipelinedRequests());
            ArrayDeque<HttpRequestMethod> methodQueue = new ArrayDeque<HttpRequestMethod>(minPipelinedRequests);
            ArrayDeque<HttpResponseDecoder.Signal> signalsQueue = new ArrayDeque<HttpResponseDecoder.Signal>(minPipelinedRequests);
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.addLast(new HttpResponseDecoder(methodQueue, signalsQueue, alloc, config.headersFactory(), config.maxStartLineLength(), config.maxHeaderFieldLength(), config.specExceptions().allowPrematureClosureBeforePayloadBody(), config.specExceptions().allowLFWithoutCR(), closeHandler));
            pipeline.addLast(new HttpRequestEncoder(methodQueue, signalsQueue, config.headersEncodedSizeEstimate(), config.trailersEncodedSizeEstimate(), closeHandler));
        });
    }

    @Override
    public void init(Channel channel) {
        this.delegate.init(channel);
    }

    static List<Class<? extends ChannelHandler>> handlers() {
        return HANDLERS;
    }
}

