/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.http.api.Http2Settings;
import io.servicetalk.http.api.Http2SettingsBuilder;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.netty.H2HeadersFactory;
import io.servicetalk.http.netty.H2KeepAlivePolicies;
import io.servicetalk.http.netty.H2ProtocolConfig;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.logging.api.UserDataLoggerConfig;
import io.servicetalk.logging.slf4j.internal.DefaultUserDataLoggerConfig;
import io.servicetalk.utils.internal.NumberUtils;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;

public final class H2ProtocolConfigBuilder {
    private static final BiPredicate<CharSequence, CharSequence> DEFAULT_SENSITIVITY_DETECTOR = (name, value) -> false;
    private static final int INITIAL_FLOW_CONTROL_WINDOW = 0x100000;
    private static final int CONNECTION_STREAM_FLOW_CONTROL_INCREMENT = 0;
    private static final int DEFAULT_FLOW_CONTROL_QUANTUM = 16384;
    private Http2Settings h2Settings = new Http2SettingsBuilder().initialWindowSize(0x100000).maxHeaderListSize(8192L).build();
    private HttpHeadersFactory headersFactory = H2HeadersFactory.INSTANCE;
    private BiPredicate<CharSequence, CharSequence> headersSensitivityDetector = DEFAULT_SENSITIVITY_DETECTOR;
    @Nullable
    private UserDataLoggerConfig frameLoggerConfig;
    private H2ProtocolConfig.KeepAlivePolicy keepAlivePolicy = H2KeepAlivePolicies.disabled();
    private int flowControlQuantum = 16384;
    private int flowControlIncrement = 0;

    H2ProtocolConfigBuilder() {
    }

    public H2ProtocolConfigBuilder headersFactory(HttpHeadersFactory headersFactory) {
        this.headersFactory = Objects.requireNonNull(headersFactory);
        return this;
    }

    public H2ProtocolConfigBuilder headersSensitivityDetector(BiPredicate<CharSequence, CharSequence> headersSensitivityDetector) {
        this.headersSensitivityDetector = Objects.requireNonNull(headersSensitivityDetector);
        return this;
    }

    public H2ProtocolConfigBuilder enableFrameLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
        this.frameLoggerConfig = new DefaultUserDataLoggerConfig(loggerName, logLevel, logUserData);
        return this;
    }

    public H2ProtocolConfigBuilder keepAlivePolicy(H2ProtocolConfig.KeepAlivePolicy policy) {
        this.keepAlivePolicy = H2KeepAlivePolicies.validateKeepAlivePolicy(policy);
        return this;
    }

    public H2ProtocolConfigBuilder initialSettings(Http2Settings settings) {
        this.h2Settings = Objects.requireNonNull(settings);
        return this;
    }

    public H2ProtocolConfigBuilder flowControlQuantum(int flowControlQuantum) {
        this.flowControlQuantum = NumberUtils.ensurePositive(flowControlQuantum, "flowControlQuantum");
        return this;
    }

    public H2ProtocolConfigBuilder flowControlWindowIncrement(int connectionWindowIncrement) {
        this.flowControlIncrement = NumberUtils.ensurePositive(connectionWindowIncrement, "connectionWindowIncrement");
        return this;
    }

    public H2ProtocolConfig build() {
        return new DefaultH2ProtocolConfig(this.h2Settings, this.headersFactory, this.headersSensitivityDetector, this.frameLoggerConfig, this.keepAlivePolicy, this.flowControlQuantum, this.flowControlIncrement);
    }

    private static final class DefaultH2ProtocolConfig
    implements H2ProtocolConfig {
        private final Http2Settings h2Settings;
        private final HttpHeadersFactory headersFactory;
        private final BiPredicate<CharSequence, CharSequence> headersSensitivityDetector;
        @Nullable
        private final UserDataLoggerConfig frameLoggerConfig;
        private final H2ProtocolConfig.KeepAlivePolicy keepAlivePolicy;
        private final int flowControlQuantum;
        private final int flowControlIncrement;

        DefaultH2ProtocolConfig(Http2Settings h2Settings, HttpHeadersFactory headersFactory, BiPredicate<CharSequence, CharSequence> headersSensitivityDetector, @Nullable UserDataLoggerConfig frameLoggerConfig, H2ProtocolConfig.KeepAlivePolicy keepAlivePolicy, int flowControlQuantum, int flowControlIncrement) {
            this.h2Settings = h2Settings;
            this.headersFactory = headersFactory;
            this.headersSensitivityDetector = headersSensitivityDetector;
            this.frameLoggerConfig = frameLoggerConfig;
            this.keepAlivePolicy = keepAlivePolicy;
            this.flowControlQuantum = flowControlQuantum;
            this.flowControlIncrement = flowControlIncrement;
        }

        @Override
        public HttpHeadersFactory headersFactory() {
            return this.headersFactory;
        }

        @Override
        public BiPredicate<CharSequence, CharSequence> headersSensitivityDetector() {
            return this.headersSensitivityDetector;
        }

        @Override
        @Nullable
        public UserDataLoggerConfig frameLoggerConfig() {
            return this.frameLoggerConfig;
        }

        @Override
        public H2ProtocolConfig.KeepAlivePolicy keepAlivePolicy() {
            return this.keepAlivePolicy;
        }

        @Override
        public Http2Settings initialSettings() {
            return this.h2Settings;
        }

        @Override
        public int flowControlQuantum() {
            return this.flowControlQuantum;
        }

        @Override
        public int flowControlWindowIncrement() {
            return this.flowControlIncrement;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{alpnId=" + this.alpnId() + ", headersFactory=" + this.headersFactory + ", headersSensitivityDetector=" + (this.headersSensitivityDetector == DEFAULT_SENSITIVITY_DETECTOR ? "DEFAULT_SENSITIVITY_DETECTOR" : this.headersSensitivityDetector.toString()) + ", frameLoggerConfig=" + this.frameLoggerConfig + ", keepAlivePolicy=" + this.keepAlivePolicy + ", flowControlQuantum=" + this.flowControlQuantum + ", flowControlIncrement=" + this.flowControlIncrement + ", h2Settings=" + this.h2Settings + '}';
        }
    }
}

