/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.DefaultHttp2WindowUpdateFrame;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.servicetalk.http.netty.H2ProtocolConfig;
import io.servicetalk.http.netty.H2ServerParentChannelInitializer;
import io.servicetalk.http.netty.OptimizedHttp2FrameCodecBuilder;
import io.servicetalk.transport.netty.internal.ChannelInitializer;

final class H2ClientParentChannelInitializer
implements ChannelInitializer {
    private final H2ProtocolConfig config;
    private final Http2Settings nettySettings;

    H2ClientParentChannelInitializer(H2ProtocolConfig config) {
        this.config = config;
        this.nettySettings = H2ServerParentChannelInitializer.toNettySettings(config.initialSettings()).pushEnabled(false).maxConcurrentStreams(0L);
    }

    @Override
    public void init(Channel channel) {
        Http2FrameCodecBuilder multiplexCodecBuilder = new OptimizedHttp2FrameCodecBuilder(false, this.config.flowControlQuantum()).decoupleCloseAndGoAway(true).autoAckSettingsFrame(false).autoAckPingFrame(false).gracefulShutdownTimeoutMillis(-1L).initialSettings(this.nettySettings).validateHeaders(this.config.headersFactory().validateNames()).headerSensitivityDetector(this.config.headersSensitivityDetector()::test);
        H2ServerParentChannelInitializer.initFrameLogger(multiplexCodecBuilder, this.config.frameLoggerConfig());
        channel.pipeline().addLast(multiplexCodecBuilder.build(), new Http2MultiplexHandler(H2PushStreamHandler.INSTANCE));
        if (this.config.flowControlWindowIncrement() > 0) {
            channel.pipeline().addLast(new ChannelInboundHandlerAdapter(){

                @Override
                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                    if (evt instanceof Http2ConnectionPrefaceAndSettingsFrameWrittenEvent) {
                        ctx.write(new DefaultHttp2WindowUpdateFrame(H2ClientParentChannelInitializer.this.config.flowControlWindowIncrement()));
                        ctx.pipeline().remove(this);
                    }
                    ctx.fireUserEventTriggered(evt);
                }
            });
        }
    }

    @ChannelHandler.Sharable
    private static final class H2PushStreamHandler
    extends ChannelInboundHandlerAdapter {
        static final ChannelInboundHandlerAdapter INSTANCE = new H2PushStreamHandler();

        private H2PushStreamHandler() {
        }

        @Override
        public void channelRegistered(ChannelHandlerContext ctx) {
            ctx.writeAndFlush(new DefaultHttp2GoAwayFrame(Http2Error.PROTOCOL_ERROR, ByteBufUtil.writeAscii(ctx.alloc(), (CharSequence)"Server Push is not supported")));
        }
    }
}

