/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.ssl.SslContext;
import io.netty.util.NetUtil;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.DefaultServiceDiscovererEvent;
import io.servicetalk.client.api.DelegatingServiceDiscoverer;
import io.servicetalk.client.api.LoadBalancer;
import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Processors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.DefaultHttpLoadBalancerFactory;
import io.servicetalk.http.api.DefaultStreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.DelegatingHttpExecutionContext;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpLoadBalancedConnection;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpLoadBalancerFactory;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.ProxyConfig;
import io.servicetalk.http.api.SingleAddressHttpClientBuilder;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.netty.AbsoluteAddressHttpRequesterFilter;
import io.servicetalk.http.netty.AbstractLBHttpConnectionFactory;
import io.servicetalk.http.netty.AlpnLBHttpConnectionFactory;
import io.servicetalk.http.netty.ClientStrategyInfluencerChainBuilder;
import io.servicetalk.http.netty.FilterableClientToClient;
import io.servicetalk.http.netty.H1ProtocolConfig;
import io.servicetalk.http.netty.H2LBHttpConnectionFactory;
import io.servicetalk.http.netty.H2ProtocolConfig;
import io.servicetalk.http.netty.HttpClientConfig;
import io.servicetalk.http.netty.HttpClients;
import io.servicetalk.http.netty.HttpExecutionContextBuilder;
import io.servicetalk.http.netty.HttpMessageDiscardWatchdogClientFilter;
import io.servicetalk.http.netty.HttpRequestTracker;
import io.servicetalk.http.netty.LoadBalancedStreamingHttpClient;
import io.servicetalk.http.netty.PipelinedLBHttpConnectionFactory;
import io.servicetalk.http.netty.ProxyConnectConnectionFactoryFilter;
import io.servicetalk.http.netty.ProxyConnectLBHttpConnectionFactory;
import io.servicetalk.http.netty.ReadOnlyHttpClientConfig;
import io.servicetalk.http.netty.ReservableRequestConcurrencyControllers;
import io.servicetalk.http.netty.RetryingHttpRequesterFilter;
import io.servicetalk.http.netty.RetryingServiceDiscoverer;
import io.servicetalk.http.netty.StrategyInfluencerAwareConversions;
import io.servicetalk.http.utils.HostHeaderHttpRequesterFilter;
import io.servicetalk.http.utils.IdleTimeoutConnectionFilter;
import io.servicetalk.loadbalancer.RoundRobinLoadBalancers;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.api.IoExecutor;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultSingleAddressHttpClientBuilder<U, R>
implements SingleAddressHttpClientBuilder<U, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSingleAddressHttpClientBuilder.class);
    private static final RetryingHttpRequesterFilter DEFAULT_AUTO_RETRIES = new RetryingHttpRequesterFilter.Builder().build();
    private static final StreamingHttpConnectionFilterFactory DEFAULT_IDLE_TIMEOUT_FILTER = new IdleTimeoutConnectionFilter(Duration.ofMinutes(5L));
    private static final AtomicInteger CLIENT_ID = new AtomicInteger();
    private final U address;
    @Nullable
    private U proxyAddress;
    private final HttpClientConfig config;
    final HttpExecutionContextBuilder executionContextBuilder;
    private final ClientStrategyInfluencerChainBuilder strategyComputation;
    private HttpLoadBalancerFactory<R> loadBalancerFactory;
    private ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> serviceDiscoverer;
    private Function<U, CharSequence> hostToCharSequenceFunction = DefaultSingleAddressHttpClientBuilder::toAuthorityForm;
    private boolean addHostHeaderFallbackFilter = true;
    private boolean addIdleTimeoutConnectionFilter = true;
    @Nullable
    private BiIntFunction<Throwable, ? extends Completable> serviceDiscovererRetryStrategy;
    @Nullable
    private StreamingHttpConnectionFilterFactory connectionFilterFactory;
    @Nullable
    private ContextAwareStreamingHttpClientFilterFactory clientFilterFactory;
    private ConnectionFactoryFilter<R, FilterableStreamingHttpConnection> connectionFactoryFilter = ConnectionFactoryFilter.identity();
    @Nullable
    private RetryingHttpRequesterFilter retryingHttpRequesterFilter;

    DefaultSingleAddressHttpClientBuilder(U address, ServiceDiscoverer<U, R, ? extends ServiceDiscovererEvent<R>> serviceDiscoverer) {
        this.address = Objects.requireNonNull(address);
        this.config = new HttpClientConfig();
        this.executionContextBuilder = new HttpExecutionContextBuilder();
        this.strategyComputation = new ClientStrategyInfluencerChainBuilder();
        this.loadBalancerFactory = DefaultSingleAddressHttpClientBuilder.defaultLoadBalancer();
        this.serviceDiscoverer = new CastedServiceDiscoverer(serviceDiscoverer);
        this.clientFilterFactory = DefaultSingleAddressHttpClientBuilder.appendFilter(this.clientFilterFactory, HttpMessageDiscardWatchdogClientFilter.CLIENT_CLEANER);
    }

    private DefaultSingleAddressHttpClientBuilder(U address, DefaultSingleAddressHttpClientBuilder<U, R> from) {
        this.address = Objects.requireNonNull(address);
        this.proxyAddress = from.proxyAddress;
        this.config = new HttpClientConfig(from.config);
        this.executionContextBuilder = new HttpExecutionContextBuilder(from.executionContextBuilder);
        this.strategyComputation = from.strategyComputation.copy();
        this.loadBalancerFactory = from.loadBalancerFactory;
        this.serviceDiscoverer = from.serviceDiscoverer;
        this.serviceDiscovererRetryStrategy = from.serviceDiscovererRetryStrategy;
        this.clientFilterFactory = from.clientFilterFactory;
        this.connectionFilterFactory = from.connectionFilterFactory;
        this.hostToCharSequenceFunction = from.hostToCharSequenceFunction;
        this.addHostHeaderFallbackFilter = from.addHostHeaderFallbackFilter;
        this.addIdleTimeoutConnectionFilter = from.addIdleTimeoutConnectionFilter;
        this.connectionFactoryFilter = from.connectionFactoryFilter;
        this.retryingHttpRequesterFilter = from.retryingHttpRequesterFilter;
    }

    static <U, R> SingleAddressHttpClientBuilder<U, R> setExecutionContext(SingleAddressHttpClientBuilder<U, R> builder, HttpExecutionContext context) {
        return builder.ioExecutor(context.ioExecutor()).executor(context.executor()).bufferAllocator(context.bufferAllocator()).executionStrategy(context.executionStrategy());
    }

    @Override
    public StreamingHttpClient buildStreaming() {
        return DefaultSingleAddressHttpClientBuilder.buildStreaming(this.copyBuildCtx());
    }

    private static <U, R> StreamingHttpClient buildStreaming(HttpClientBuildContext<U, R> ctx) {
        String targetResource = DefaultSingleAddressHttpClientBuilder.targetResource(ctx);
        ReadOnlyHttpClientConfig roConfig = ctx.httpConfig().asReadOnly();
        HttpExecutionContext builderExecutionContext = ctx.builder.executionContextBuilder.build();
        final HttpExecutionStrategy computedStrategy = ctx.builder.strategyComputation.buildForClient(builderExecutionContext.executionStrategy());
        DelegatingHttpExecutionContext executionContext = new DelegatingHttpExecutionContext(builderExecutionContext){

            @Override
            public HttpExecutionStrategy executionStrategy() {
                return computedStrategy;
            }
        };
        SslContext sslContext = roConfig.tcpConfig().sslContext();
        CompositeCloseable closeOnException = AsyncCloseables.newCompositeCloseable();
        try {
            AbstractLBHttpConnectionFactory connectionFactory;
            Publisher<Collection<ServiceDiscovererEvent<R>>> sdEvents = ctx.serviceDiscoverer(targetResource, executionContext).discover(ctx.address());
            ConnectionFactoryFilter<Object, FilterableStreamingHttpConnection> connectionFactoryFilter = ctx.builder.connectionFactoryFilter;
            ExecutionStrategy connectionFactoryStrategy = ctx.builder.strategyComputation.buildForConnectionFactory();
            if (roConfig.hasProxy() && sslContext != null) {
                assert (roConfig.proxyConfig() != null);
                ProxyConnectConnectionFactoryFilter proxy = new ProxyConnectConnectionFactoryFilter(roConfig.proxyConfig().address());
                assert (!proxy.requiredOffloads().hasOffloads());
                connectionFactoryFilter = DefaultSingleAddressHttpClientBuilder.appendConnectionFilter(proxy, connectionFactoryFilter);
            }
            connectionFactoryFilter = DefaultSingleAddressHttpClientBuilder.appendConnectionFilter(HttpRequestTracker.filter(), connectionFactoryFilter);
            HttpExecutionStrategy builderStrategy = executionContext.executionStrategy();
            StreamingHttpRequestResponseFactory reqRespFactory = DefaultSingleAddressHttpClientBuilder.defaultReqRespFactory(roConfig, executionContext.bufferAllocator());
            StreamingHttpConnectionFilterFactory connectionFilterFactory = ctx.builder.addIdleTimeoutConnectionFilter ? DefaultSingleAddressHttpClientBuilder.appendConnectionFilter(ctx.builder.connectionFilterFactory, DEFAULT_IDLE_TIMEOUT_FILTER) : ctx.builder.connectionFilterFactory;
            connectionFilterFactory = DefaultSingleAddressHttpClientBuilder.appendConnectionFilter(connectionFilterFactory, HttpMessageDiscardWatchdogClientFilter.INSTANCE);
            if (roConfig.isH2PriorKnowledge() && (!roConfig.hasProxy() || sslContext == null)) {
                H2ProtocolConfig h2Config = roConfig.h2Config();
                assert (h2Config != null);
                connectionFactory = new H2LBHttpConnectionFactory<R>(roConfig, (HttpExecutionContext)executionContext, connectionFilterFactory, reqRespFactory, connectionFactoryStrategy, connectionFactoryFilter, ctx.builder.loadBalancerFactory::toLoadBalancedConnection);
            } else if (!roConfig.hasProxy() && roConfig.tcpConfig().preferredAlpnProtocol() != null) {
                H1ProtocolConfig h1Config = roConfig.h1Config();
                H2ProtocolConfig h2Config = roConfig.h2Config();
                connectionFactory = new AlpnLBHttpConnectionFactory<R>(roConfig, (HttpExecutionContext)executionContext, connectionFilterFactory, new AlpnReqRespFactoryFunc(executionContext.bufferAllocator(), h1Config == null ? null : h1Config.headersFactory(), h2Config == null ? null : h2Config.headersFactory()), connectionFactoryStrategy, connectionFactoryFilter, ctx.builder.loadBalancerFactory::toLoadBalancedConnection);
            } else {
                connectionFactory = roConfig.hasProxy() && sslContext != null ? new ProxyConnectLBHttpConnectionFactory<R>(roConfig, (HttpExecutionContext)executionContext, connectionFilterFactory, reqRespFactory, connectionFactoryStrategy, connectionFactoryFilter, ctx.builder.loadBalancerFactory::toLoadBalancedConnection) : new PipelinedLBHttpConnectionFactory<R>(roConfig, (HttpExecutionContext)executionContext, connectionFilterFactory, reqRespFactory, connectionFactoryStrategy, connectionFactoryFilter, ctx.builder.loadBalancerFactory::toLoadBalancedConnection);
            }
            LoadBalancer<FilterableStreamingHttpLoadBalancedConnection> lb = closeOnException.prepend(ctx.builder.loadBalancerFactory.newLoadBalancer(sdEvents, connectionFactory, targetResource));
            ContextAwareStreamingHttpClientFilterFactory currClientFilterFactory = ctx.builder.clientFilterFactory;
            if (roConfig.hasProxy() && sslContext == null) {
                currClientFilterFactory = DefaultSingleAddressHttpClientBuilder.appendFilter(currClientFilterFactory, super.proxyAbsoluteAddressFilterFactory());
            }
            if (ctx.builder.addHostHeaderFallbackFilter) {
                currClientFilterFactory = DefaultSingleAddressHttpClientBuilder.appendFilter(currClientFilterFactory, new HostHeaderHttpRequesterFilter(ctx.builder.hostToCharSequenceFunction.apply(ctx.builder.address)));
            }
            FilterableStreamingHttpClient lbClient = closeOnException.prepend(new LoadBalancedStreamingHttpClient(executionContext, lb, reqRespFactory));
            if (ctx.builder.retryingHttpRequesterFilter == null) {
                ctx.builder.retryingHttpRequesterFilter = DEFAULT_AUTO_RETRIES;
                currClientFilterFactory = DefaultSingleAddressHttpClientBuilder.appendFilter(currClientFilterFactory, ctx.builder.retryingHttpRequesterFilter);
            }
            currClientFilterFactory = DefaultSingleAddressHttpClientBuilder.appendFilter(currClientFilterFactory, ReservableRequestConcurrencyControllers.InternalRetryingHttpClientFilter.INSTANCE);
            StreamingHttpClientFilter wrappedClient = currClientFilterFactory.create(lbClient, lb.eventStream(), ((HttpClientBuildContext)ctx).sdStatus);
            if (builderStrategy != HttpExecutionStrategies.defaultStrategy() && builderStrategy.missing(computedStrategy) != HttpExecutionStrategies.offloadNone()) {
                LOGGER.info("Client for {} created with the builder strategy {} but resulting computed strategy is {}. One of the filters enforces additional offloading. To find out what filter is it, enable debug level logging for {}.", targetResource, builderStrategy, computedStrategy, ClientStrategyInfluencerChainBuilder.class);
            } else if (builderStrategy == computedStrategy) {
                LOGGER.debug("Client for {} created with the execution strategy {}.", (Object)targetResource, (Object)computedStrategy);
            } else {
                LOGGER.debug("Client for {} created with the builder strategy {}, resulting computed strategy is {}.", targetResource, builderStrategy, computedStrategy);
            }
            return new FilterableClientToClient(wrappedClient, executionContext);
        }
        catch (Throwable t) {
            closeOnException.closeAsync().subscribe();
            throw t;
        }
    }

    private static <R> ConnectionFactoryFilter<R, FilterableStreamingHttpConnection> appendConnectionFilter(ConnectionFactoryFilter<R, FilterableStreamingHttpConnection> first, ConnectionFactoryFilter<R, FilterableStreamingHttpConnection> second) {
        return first.append(second);
    }

    private static StreamingHttpRequestResponseFactory defaultReqRespFactory(ReadOnlyHttpClientConfig roConfig, BufferAllocator allocator) {
        if (roConfig.isH2PriorKnowledge()) {
            H2ProtocolConfig h2Config = roConfig.h2Config();
            assert (h2Config != null);
            return new DefaultStreamingHttpRequestResponseFactory(allocator, h2Config.headersFactory(), HttpProtocolVersion.HTTP_2_0);
        }
        if (roConfig.tcpConfig().preferredAlpnProtocol() != null) {
            H1ProtocolConfig h1Config = roConfig.h1Config();
            H2ProtocolConfig h2Config = roConfig.h2Config();
            String preferredAlpnProtocol = roConfig.tcpConfig().preferredAlpnProtocol();
            if ("h2".equals(preferredAlpnProtocol)) {
                assert (h2Config != null);
                return new DefaultStreamingHttpRequestResponseFactory(allocator, h2Config.headersFactory(), HttpProtocolVersion.HTTP_2_0);
            }
            if (h1Config == null) {
                throw new IllegalStateException(preferredAlpnProtocol + " is preferred ALPN protocol, falling back to " + HttpProtocolVersion.HTTP_1_1 + " but the " + HttpProtocolVersion.HTTP_1_1 + " protocol was not configured.");
            }
            return new DefaultStreamingHttpRequestResponseFactory(allocator, h1Config.headersFactory(), HttpProtocolVersion.HTTP_1_1);
        }
        H1ProtocolConfig h1Config = roConfig.h1Config();
        assert (h1Config != null);
        return new DefaultStreamingHttpRequestResponseFactory(allocator, h1Config.headersFactory(), HttpProtocolVersion.HTTP_1_1);
    }

    private static <U, R> String targetResource(HttpClientBuildContext<U, R> ctx) {
        String uniqueAddress = ctx.builder.address + "/" + CLIENT_ID.incrementAndGet();
        return ctx.builder.proxyAddress == null ? uniqueAddress : uniqueAddress + " (via " + ctx.builder.proxyAddress + ")";
    }

    private static ContextAwareStreamingHttpClientFilterFactory appendFilter(@Nullable ContextAwareStreamingHttpClientFilterFactory currClientFilterFactory, StreamingHttpClientFilterFactory appendClientFilterFactory) {
        if (appendClientFilterFactory instanceof RetryingHttpRequesterFilter) {
            if (currClientFilterFactory == null) {
                return (client, lbEventStream, sdStatus) -> {
                    RetryingHttpRequesterFilter.ContextAwareRetryingHttpClientFilter filter = (RetryingHttpRequesterFilter.ContextAwareRetryingHttpClientFilter)appendClientFilterFactory.create(client);
                    filter.inject(lbEventStream, sdStatus);
                    return filter;
                };
            }
            return (client, lbEventStream, sdStatus) -> {
                RetryingHttpRequesterFilter.ContextAwareRetryingHttpClientFilter filter = (RetryingHttpRequesterFilter.ContextAwareRetryingHttpClientFilter)appendClientFilterFactory.create(client);
                filter.inject(lbEventStream, sdStatus);
                return currClientFilterFactory.create(filter, lbEventStream, sdStatus);
            };
        }
        if (appendClientFilterFactory instanceof ContextAwareStreamingHttpClientFilterFactory) {
            if (currClientFilterFactory == null) {
                return (ContextAwareStreamingHttpClientFilterFactory)appendClientFilterFactory;
            }
            return (client, lbEventStream, sdError) -> currClientFilterFactory.create(((ContextAwareStreamingHttpClientFilterFactory)appendClientFilterFactory).create(client, lbEventStream, sdError), lbEventStream, sdError);
        }
        if (currClientFilterFactory == null) {
            return (client, lbEventStream, sdError) -> appendClientFilterFactory.create(client);
        }
        return (client, lbEventStream, sdError) -> currClientFilterFactory.create(appendClientFilterFactory.create(client), lbEventStream, sdError);
    }

    private HttpClientBuildContext<U, R> copyBuildCtx() {
        return new HttpClientBuildContext<U, R>(new DefaultSingleAddressHttpClientBuilder<U, R>(this.address, this), this.serviceDiscoverer, this.serviceDiscovererRetryStrategy);
    }

    private AbsoluteAddressHttpRequesterFilter proxyAbsoluteAddressFilterFactory() {
        return new AbsoluteAddressHttpRequesterFilter("http", this.hostToCharSequenceFunction.apply(this.address));
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> proxyConfig(ProxyConfig<U> proxyConfig) {
        this.proxyAddress = Objects.requireNonNull(proxyConfig.address());
        this.config.proxyConfig(this.hostToCharSequenceFunction.apply(this.address), proxyConfig);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> ioExecutor(IoExecutor ioExecutor) {
        this.executionContextBuilder.ioExecutor(ioExecutor);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> executor(Executor executor) {
        this.executionContextBuilder.executor(executor);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> executionStrategy(HttpExecutionStrategy strategy) {
        this.executionContextBuilder.executionStrategy(strategy);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> bufferAllocator(BufferAllocator allocator) {
        this.executionContextBuilder.bufferAllocator(allocator);
        return this;
    }

    @Override
    public <T> DefaultSingleAddressHttpClientBuilder<U, R> socketOption(SocketOption<T> option, T value) {
        this.config.tcpConfig().socketOption(option, value);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> enableWireLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
        this.config.tcpConfig().enableWireLogging(loggerName, logLevel, logUserData);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> protocols(HttpProtocolConfig ... protocols) {
        this.config.protocolConfigs().protocols(protocols);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> appendConnectionFilter(StreamingHttpConnectionFilterFactory factory) {
        Objects.requireNonNull(factory);
        this.connectionFilterFactory = DefaultSingleAddressHttpClientBuilder.appendConnectionFilter(this.connectionFilterFactory, factory);
        this.strategyComputation.add(factory);
        this.checkIfHostHeaderHttpRequesterFilter(factory);
        this.checkIfIdleTimeoutConnectionFilter(factory);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> appendConnectionFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpConnectionFilterFactory factory) {
        this.appendConnectionFilter(StrategyInfluencerAwareConversions.toConditionalConnectionFilterFactory(predicate, factory));
        this.checkIfHostHeaderHttpRequesterFilter(factory);
        this.checkIfIdleTimeoutConnectionFilter(factory);
        return this;
    }

    private void checkIfHostHeaderHttpRequesterFilter(Object filter) {
        if (filter instanceof HostHeaderHttpRequesterFilter) {
            this.addHostHeaderFallbackFilter = false;
        }
    }

    private void checkIfIdleTimeoutConnectionFilter(StreamingHttpConnectionFilterFactory factory) {
        if (factory instanceof IdleTimeoutConnectionFilter) {
            this.addIdleTimeoutConnectionFilter = false;
        }
    }

    private static StreamingHttpConnectionFilterFactory appendConnectionFilter(@Nullable StreamingHttpConnectionFilterFactory current, StreamingHttpConnectionFilterFactory next) {
        return current == null ? next : connection -> current.create(next.create(connection));
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> appendConnectionFactoryFilter(ConnectionFactoryFilter<R, FilterableStreamingHttpConnection> factory) {
        this.connectionFactoryFilter = DefaultSingleAddressHttpClientBuilder.appendConnectionFilter(this.connectionFactoryFilter, Objects.requireNonNull(factory));
        this.strategyComputation.add(factory);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> hostHeaderFallback(boolean enable) {
        this.addHostHeaderFallbackFilter = enable;
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> allowDropResponseTrailers(boolean allowDrop) {
        this.config.protocolConfigs().allowDropTrailersReadFromTransport(allowDrop);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> appendClientFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpClientFilterFactory factory) {
        this.checkIfRetryingHttpRequesterFilter(factory);
        this.appendClientFilter(StrategyInfluencerAwareConversions.toConditionalClientFilterFactory(predicate, factory));
        this.checkIfHostHeaderHttpRequesterFilter(factory);
        return this;
    }

    private void checkIfRetryingHttpRequesterFilter(StreamingHttpClientFilterFactory factory) {
        if (factory instanceof RetryingHttpRequesterFilter) {
            if (this.retryingHttpRequesterFilter != null) {
                throw new IllegalStateException("Retrying HTTP requester filter was already found in the filter chain, only a single instance of that is allowed.");
            }
            this.retryingHttpRequesterFilter = (RetryingHttpRequesterFilter)factory;
        }
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> unresolvedAddressToHost(Function<U, CharSequence> unresolvedAddressToHostFunction) {
        this.hostToCharSequenceFunction = Objects.requireNonNull(unresolvedAddressToHostFunction);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> appendClientFilter(StreamingHttpClientFilterFactory factory) {
        Objects.requireNonNull(factory);
        this.checkIfRetryingHttpRequesterFilter(factory);
        this.clientFilterFactory = DefaultSingleAddressHttpClientBuilder.appendFilter(this.clientFilterFactory, factory);
        this.strategyComputation.add(factory);
        this.checkIfHostHeaderHttpRequesterFilter(factory);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> serviceDiscoverer(ServiceDiscoverer<U, R, ? extends ServiceDiscovererEvent<R>> serviceDiscoverer) {
        this.serviceDiscoverer = new CastedServiceDiscoverer(serviceDiscoverer);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> retryServiceDiscoveryErrors(BiIntFunction<Throwable, ? extends Completable> retryStrategy) {
        this.serviceDiscovererRetryStrategy = Objects.requireNonNull(retryStrategy);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> loadBalancerFactory(HttpLoadBalancerFactory<R> loadBalancerFactory) {
        this.loadBalancerFactory = Objects.requireNonNull(loadBalancerFactory);
        this.strategyComputation.add(loadBalancerFactory);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> sslConfig(ClientSslConfig sslConfig) {
        this.setFallbackHostAndPort(this.config, this.address);
        this.config.tcpConfig().sslConfig(sslConfig);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> inferPeerHost(boolean shouldInfer) {
        this.config.inferPeerHost(shouldInfer);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> inferPeerPort(boolean shouldInfer) {
        this.config.inferPeerPort(shouldInfer);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> inferSniHostname(boolean shouldInfer) {
        this.config.inferSniHostname(shouldInfer);
        return this;
    }

    private static <U> CharSequence toAuthorityForm(U address) {
        if (address instanceof CharSequence) {
            return (CharSequence)address;
        }
        if (address instanceof HostAndPort) {
            HostAndPort hostAndPort = (HostAndPort)address;
            return NetUtil.toSocketAddressString(hostAndPort.hostName(), hostAndPort.port());
        }
        if (address instanceof InetSocketAddress) {
            return NetUtil.toSocketAddressString((InetSocketAddress)address);
        }
        return address.toString();
    }

    private void setFallbackHostAndPort(HttpClientConfig config, U address) {
        if (address instanceof HostAndPort) {
            HostAndPort hostAndPort = (HostAndPort)address;
            config.fallbackPeerHost(hostAndPort.hostName());
            config.fallbackPeerPort(hostAndPort.port());
        } else if (address instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
            config.fallbackPeerHost(inetSocketAddress.getHostString());
            config.fallbackPeerPort(inetSocketAddress.getPort());
        } else {
            CharSequence cs = this.hostToCharSequenceFunction.apply(address);
            if (cs == null) {
                config.fallbackPeerHost(null);
                config.fallbackPeerPort(-1);
            } else {
                int colon = CharSequences.indexOf(cs, ':', 0);
                if (colon < 0) {
                    config.fallbackPeerHost(cs.toString());
                    config.fallbackPeerPort(-1);
                } else if (cs.charAt(0) == '[') {
                    colon = CharSequences.indexOf(cs, ']', 1);
                    if (colon < 0) {
                        throw new IllegalArgumentException("unable to find end ']' of IPv6 address: " + cs);
                    }
                    config.fallbackPeerHost(cs.subSequence(1, colon).toString());
                    if (++colon >= cs.length()) {
                        config.fallbackPeerPort(-1);
                    } else {
                        if (cs.charAt(colon) != ':') {
                            throw new IllegalArgumentException("':' expected after ']' for IPv6 address: " + cs);
                        }
                        config.fallbackPeerPort(Integer.parseInt(cs.subSequence(colon + 1, cs.length()).toString()));
                    }
                } else {
                    config.fallbackPeerHost(cs.subSequence(0, colon).toString());
                    config.fallbackPeerPort(Integer.parseInt(cs.subSequence(colon + 1, cs.length()).toString()));
                }
            }
        }
    }

    private static <ResolvedAddress> HttpLoadBalancerFactory<ResolvedAddress> defaultLoadBalancer() {
        return new DefaultHttpLoadBalancerFactory(RoundRobinLoadBalancers.builder(DefaultHttpLoadBalancerFactory.class.getSimpleName()).build());
    }

    private static final class CastedServiceDiscoverer<U, R>
    implements ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> {
        private final ServiceDiscoverer<U, R, ? extends ServiceDiscovererEvent<R>> delegate;

        private CastedServiceDiscoverer(ServiceDiscoverer<U, R, ? extends ServiceDiscovererEvent<R>> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public Publisher<Collection<ServiceDiscovererEvent<R>>> discover(U address) {
            return this.delegate.discover(address).map(e -> e);
        }

        @Override
        public Completable closeAsync() {
            return this.delegate.closeAsync();
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.delegate.closeAsyncGracefully();
        }

        @Override
        public Completable onClose() {
            return this.delegate.onClose();
        }

        @Override
        public Completable onClosing() {
            return this.delegate.onClosing();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    @FunctionalInterface
    static interface ContextAwareStreamingHttpClientFilterFactory
    extends StreamingHttpClientFilterFactory {
        public StreamingHttpClientFilter create(FilterableStreamingHttpClient var1, @Nullable Publisher<Object> var2, @Nullable Completable var3);

        @Override
        default public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
            return this.create(client, null, null);
        }
    }

    private static final class AlpnReqRespFactoryFunc
    implements Function<HttpProtocolVersion, StreamingHttpRequestResponseFactory> {
        private final BufferAllocator allocator;
        @Nullable
        private final HttpHeadersFactory h1HeadersFactory;
        @Nullable
        private final HttpHeadersFactory h2HeadersFactory;
        @Nullable
        private StreamingHttpRequestResponseFactory h1Factory;
        @Nullable
        private StreamingHttpRequestResponseFactory h2Factory;

        AlpnReqRespFactoryFunc(BufferAllocator allocator, @Nullable HttpHeadersFactory h1HeadersFactory, @Nullable HttpHeadersFactory h2HeadersFactory) {
            this.allocator = allocator;
            this.h1HeadersFactory = h1HeadersFactory;
            this.h2HeadersFactory = h2HeadersFactory;
        }

        @Override
        public StreamingHttpRequestResponseFactory apply(HttpProtocolVersion version) {
            if (version == HttpProtocolVersion.HTTP_1_1) {
                if (this.h1Factory == null) {
                    this.h1Factory = new DefaultStreamingHttpRequestResponseFactory(this.allocator, AlpnReqRespFactoryFunc.headersFactory(this.h1HeadersFactory, HttpProtocolVersion.HTTP_1_1), HttpProtocolVersion.HTTP_1_1);
                }
                return this.h1Factory;
            }
            if (version == HttpProtocolVersion.HTTP_2_0) {
                if (this.h2Factory == null) {
                    this.h2Factory = new DefaultStreamingHttpRequestResponseFactory(this.allocator, AlpnReqRespFactoryFunc.headersFactory(this.h2HeadersFactory, HttpProtocolVersion.HTTP_2_0), HttpProtocolVersion.HTTP_2_0);
                }
                return this.h2Factory;
            }
            if (version.major() <= 1) {
                return new DefaultStreamingHttpRequestResponseFactory(this.allocator, AlpnReqRespFactoryFunc.headersFactory(this.h1HeadersFactory, version), version);
            }
            if (version.major() == 2) {
                return new DefaultStreamingHttpRequestResponseFactory(this.allocator, AlpnReqRespFactoryFunc.headersFactory(this.h2HeadersFactory, version), version);
            }
            throw new IllegalArgumentException("unsupported protocol: " + version);
        }

        private static HttpHeadersFactory headersFactory(@Nullable HttpHeadersFactory factory, HttpProtocolVersion version) {
            if (factory == null) {
                throw new IllegalStateException("HeadersFactory config not found for selected protocol: " + version);
            }
            return factory;
        }
    }

    private static final class StatusAwareServiceDiscoverer<U, R, E extends ServiceDiscovererEvent<R>>
    extends DelegatingServiceDiscoverer<U, R, E> {
        private static final Logger LOGGER = LoggerFactory.getLogger(StatusAwareServiceDiscoverer.class);
        private final SdStatusCompletable status;

        StatusAwareServiceDiscoverer(ServiceDiscoverer<U, R, E> delegate, SdStatusCompletable status) {
            super(delegate);
            this.status = status;
        }

        @Override
        public Publisher<Collection<E>> discover(U u) {
            return this.delegate().discover(u).beforeOnError(t -> {
                LOGGER.debug("Observed an error from {} while discovering '{}':", this.delegate(), u, t);
                this.status.nextError((Throwable)t);
            }).beforeOnNext(__ -> this.status.resetError());
        }
    }

    private static final class SdStatusCompletable
    extends Completable {
        private volatile CompletableSource.Processor processor = Processors.newCompletableProcessor();
        private boolean seenError;

        private SdStatusCompletable() {
        }

        @Override
        protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
            this.processor.subscribe(subscriber);
        }

        void nextError(Throwable t) {
            this.seenError = true;
            CompletableSource.Processor oldProcessor = this.processor;
            oldProcessor.onError(t);
            CompletableSource.Processor newProcessor = Processors.newCompletableProcessor();
            newProcessor.onError(t);
            this.processor = newProcessor;
        }

        void resetError() {
            if (this.seenError) {
                this.processor = Processors.newCompletableProcessor();
                this.seenError = false;
            }
        }
    }

    private static final class HttpClientBuildContext<U, R> {
        final DefaultSingleAddressHttpClientBuilder<U, R> builder;
        private final ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> sd;
        private final SdStatusCompletable sdStatus;
        @Nullable
        private final BiIntFunction<Throwable, ? extends Completable> serviceDiscovererRetryStrategy;

        HttpClientBuildContext(DefaultSingleAddressHttpClientBuilder<U, R> builder, ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> sd, @Nullable BiIntFunction<Throwable, ? extends Completable> serviceDiscovererRetryStrategy) {
            this.builder = builder;
            this.serviceDiscovererRetryStrategy = serviceDiscovererRetryStrategy;
            this.sd = sd;
            this.sdStatus = new SdStatusCompletable();
        }

        U address() {
            return (U)(((DefaultSingleAddressHttpClientBuilder)this.builder).proxyAddress != null ? ((DefaultSingleAddressHttpClientBuilder)this.builder).proxyAddress : ((DefaultSingleAddressHttpClientBuilder)this.builder).address);
        }

        HttpClientConfig httpConfig() {
            return ((DefaultSingleAddressHttpClientBuilder)this.builder).config;
        }

        ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> serviceDiscoverer(String targetResource, HttpExecutionContext executionContext) {
            BiIntFunction<Throwable, ? extends Completable> sdRetryStrategy = this.serviceDiscovererRetryStrategy;
            if (sdRetryStrategy == HttpClients.NoRetriesStrategy.INSTANCE) {
                return this.sd;
            }
            return new RetryingServiceDiscoverer<U, R, ServiceDiscovererEvent<R>>(targetResource, new StatusAwareServiceDiscoverer<U, R, ServiceDiscovererEvent<R>>(this.sd, this.sdStatus), sdRetryStrategy, executionContext, HttpClientBuildContext::makeUnavailable);
        }

        private static <R> ServiceDiscovererEvent<R> makeUnavailable(ServiceDiscovererEvent<R> event) {
            return new DefaultServiceDiscovererEvent<R>(event.address(), ServiceDiscovererEvent.Status.UNAVAILABLE);
        }
    }
}

