/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.codec.http.HttpScheme;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.client.api.ClientGroup;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.http.api.DefaultHttpHeadersFactory;
import io.servicetalk.http.api.DefaultStreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.EmptyHttpHeaders;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HttpContextKeys;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMetaDataFactory;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.MultiAddressHttpClientBuilder;
import io.servicetalk.http.api.RedirectConfig;
import io.servicetalk.http.api.SingleAddressHttpClientBuilder;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.netty.DefaultSingleAddressHttpClientBuilder;
import io.servicetalk.http.netty.FilterableClientToClient;
import io.servicetalk.http.netty.HttpExecutionContextBuilder;
import io.servicetalk.http.utils.RedirectingHttpRequesterFilter;
import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.api.ClientSslConfigBuilder;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.api.IoExecutor;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultMultiAddressUrlHttpClientBuilder
implements MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMultiAddressUrlHttpClientBuilder.class);
    private static final String HTTPS_SCHEME = HttpRequestMetaDataFactory.newRequestMetaData(HttpProtocolVersion.HTTP_1_1, HttpRequestMethod.GET, "https://invalid./", EmptyHttpHeaders.INSTANCE).scheme();
    private final Function<HostAndPort, SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress>> builderFactory;
    private final HttpExecutionContextBuilder executionContextBuilder = new HttpExecutionContextBuilder();
    @Nullable
    private HttpHeadersFactory headersFactory;
    @Nullable
    private RedirectConfig redirectConfig;
    private int defaultHttpPort = HttpScheme.HTTP.port();
    private int defaultHttpsPort = HttpScheme.HTTPS.port();
    @Nullable
    private MultiAddressHttpClientBuilder.SingleAddressInitializer<HostAndPort, InetSocketAddress> singleAddressInitializer;

    DefaultMultiAddressUrlHttpClientBuilder(Function<HostAndPort, SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress>> bFactory) {
        this.builderFactory = Objects.requireNonNull(bFactory);
    }

    @Override
    public StreamingHttpClient buildStreaming() {
        CompositeCloseable closeables = AsyncCloseables.newCompositeCloseable();
        try {
            HttpExecutionContext executionContext = this.executionContextBuilder.build();
            ClientFactory clientFactory = new ClientFactory(this.builderFactory, executionContext, this.singleAddressInitializer);
            UrlKeyFactory keyFactory = new UrlKeyFactory(this.defaultHttpPort, this.defaultHttpsPort);
            HttpHeadersFactory headersFactory = this.headersFactory;
            FilterableStreamingHttpClient urlClient = closeables.prepend(new StreamingUrlHttpClient(executionContext, keyFactory, clientFactory, new DefaultStreamingHttpRequestResponseFactory(executionContext.bufferAllocator(), headersFactory != null ? headersFactory : DefaultHttpHeadersFactory.INSTANCE, HttpProtocolVersion.HTTP_1_1)));
            urlClient = this.redirectConfig == null ? urlClient : new RedirectingHttpRequesterFilter(this.redirectConfig).create(urlClient);
            LOGGER.debug("Multi-address client created with base strategy {}", (Object)executionContext.executionStrategy());
            return new FilterableClientToClient(urlClient, executionContext);
        }
        catch (Throwable t) {
            closeables.closeAsync().subscribe();
            throw t;
        }
    }

    private static void singleClientStrategyUpdate(ContextMap context, HttpExecutionStrategy singleStrategy) {
        HttpExecutionStrategy useStrategy;
        HttpExecutionStrategy requestStrategy = context.getOrDefault(HttpContextKeys.HTTP_EXECUTION_STRATEGY_KEY, HttpExecutionStrategies.defaultStrategy());
        assert (requestStrategy != null) : "Request strategy unexpectedly null";
        HttpExecutionStrategy httpExecutionStrategy = HttpExecutionStrategies.defaultStrategy() == requestStrategy ? HttpExecutionStrategies.offloadAll() : (useStrategy = HttpExecutionStrategies.defaultStrategy() == singleStrategy || !singleStrategy.hasOffloads() ? requestStrategy : requestStrategy.merge(singleStrategy));
        if (useStrategy != requestStrategy) {
            LOGGER.debug("Request strategy {} changes to {}. SingleAddressClient strategy: {}", requestStrategy, useStrategy, singleStrategy);
            context.put(HttpContextKeys.HTTP_EXECUTION_STRATEGY_KEY, useStrategy);
        }
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> ioExecutor(IoExecutor ioExecutor) {
        this.executionContextBuilder.ioExecutor(ioExecutor);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> executor(Executor executor) {
        this.executionContextBuilder.executor(executor);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> bufferAllocator(BufferAllocator allocator) {
        this.executionContextBuilder.bufferAllocator(allocator);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> executionStrategy(HttpExecutionStrategy strategy) {
        this.executionContextBuilder.executionStrategy(strategy);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> headersFactory(HttpHeadersFactory headersFactory) {
        this.headersFactory = Objects.requireNonNull(headersFactory);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> initializer(MultiAddressHttpClientBuilder.SingleAddressInitializer<HostAndPort, InetSocketAddress> initializer) {
        this.singleAddressInitializer = Objects.requireNonNull(initializer);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> followRedirects(@Nullable RedirectConfig config) {
        this.redirectConfig = config;
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> defaultHttpPort(int port) {
        this.defaultHttpPort = DefaultMultiAddressUrlHttpClientBuilder.verifyPortRange(port);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> defaultHttpsPort(int port) {
        this.defaultHttpsPort = DefaultMultiAddressUrlHttpClientBuilder.verifyPortRange(port);
        return this;
    }

    private static int verifyPortRange(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Provided port number is out of range (between 1 and 65535): " + port);
        }
        return port;
    }

    private static final class StreamingUrlHttpClient
    implements FilterableStreamingHttpClient {
        private final HttpExecutionContext executionContext;
        private final StreamingHttpRequestResponseFactory reqRespFactory;
        private final ClientGroup<UrlKey, FilterableStreamingHttpClient> group;
        private final UrlKeyFactory keyFactory;

        StreamingUrlHttpClient(HttpExecutionContext executionContext, UrlKeyFactory keyFactory, ClientFactory clientFactory, StreamingHttpRequestResponseFactory reqRespFactory) {
            this.reqRespFactory = Objects.requireNonNull(reqRespFactory);
            this.group = ClientGroup.from(clientFactory);
            this.keyFactory = keyFactory;
            this.executionContext = Objects.requireNonNull(executionContext);
        }

        private FilterableStreamingHttpClient selectClient(HttpRequestMetaData metaData) throws MalformedURLException {
            return this.group.get(this.keyFactory.get(metaData));
        }

        @Override
        public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
            return Single.defer(() -> {
                try {
                    FilterableStreamingHttpClient singleClient = this.selectClient(metaData);
                    DefaultMultiAddressUrlHttpClientBuilder.singleClientStrategyUpdate(metaData.context(), singleClient.executionContext().executionStrategy());
                    return singleClient.reserveConnection(metaData).shareContextOnSubscribe();
                }
                catch (Throwable t) {
                    return Single.failed(t).shareContextOnSubscribe();
                }
            });
        }

        @Override
        public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
            return Single.defer(() -> {
                try {
                    return this.selectClient(request).request(request).shareContextOnSubscribe();
                }
                catch (Throwable t) {
                    return Single.failed(t).shareContextOnSubscribe();
                }
            });
        }

        @Override
        public HttpExecutionContext executionContext() {
            return this.executionContext;
        }

        @Override
        public StreamingHttpResponseFactory httpResponseFactory() {
            return this.reqRespFactory;
        }

        @Override
        public Completable onClose() {
            return this.group.onClose();
        }

        @Override
        public Completable onClosing() {
            return this.group.onClosing();
        }

        @Override
        public Completable closeAsync() {
            return this.group.closeAsync();
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.group.closeAsyncGracefully();
        }

        @Override
        public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return this.reqRespFactory.newRequest(method, requestTarget);
        }
    }

    private static final class HttpExecutionStrategyUpdater
    implements StreamingHttpClientFilterFactory {
        static final StreamingHttpClientFilterFactory INSTANCE = new HttpExecutionStrategyUpdater();

        private HttpExecutionStrategyUpdater() {
        }

        @Override
        public StreamingHttpClientFilter create(final FilterableStreamingHttpClient client) {
            return new StreamingHttpClientFilter(client){

                @Override
                protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
                    return Single.defer(() -> {
                        DefaultMultiAddressUrlHttpClientBuilder.singleClientStrategyUpdate(request.context(), client.executionContext().executionStrategy());
                        return delegate.request(request);
                    });
                }
            };
        }

        @Override
        public HttpExecutionStrategy requiredOffloads() {
            return HttpExecutionStrategies.offloadNone();
        }
    }

    private static final class ClientFactory
    implements Function<UrlKey, FilterableStreamingHttpClient> {
        private static final ClientSslConfig DEFAULT_CLIENT_SSL_CONFIG = new ClientSslConfigBuilder().build();
        private final Function<HostAndPort, SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress>> builderFactory;
        private final HttpExecutionContext executionContext;
        @Nullable
        private final MultiAddressHttpClientBuilder.SingleAddressInitializer<HostAndPort, InetSocketAddress> singleAddressInitializer;

        ClientFactory(Function<HostAndPort, SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress>> builderFactory, HttpExecutionContext executionContext, @Nullable MultiAddressHttpClientBuilder.SingleAddressInitializer<HostAndPort, InetSocketAddress> singleAddressInitializer) {
            this.builderFactory = builderFactory;
            this.executionContext = executionContext;
            this.singleAddressInitializer = singleAddressInitializer;
        }

        @Override
        public StreamingHttpClient apply(UrlKey urlKey) {
            HostAndPort hostAndPort = HostAndPort.of(urlKey.host, urlKey.port);
            SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> builder = Objects.requireNonNull(this.builderFactory.apply(hostAndPort));
            DefaultSingleAddressHttpClientBuilder.setExecutionContext(builder, this.executionContext);
            if (HTTPS_SCHEME.equals(urlKey.scheme)) {
                builder.sslConfig(DEFAULT_CLIENT_SSL_CONFIG);
            }
            builder.appendClientFilter(HttpExecutionStrategyUpdater.INSTANCE);
            if (this.singleAddressInitializer != null) {
                this.singleAddressInitializer.initialize(urlKey.scheme, hostAndPort, builder);
            }
            return builder.buildStreaming();
        }
    }

    private static final class UrlKey {
        final String scheme;
        final String host;
        final int port;
        private final int hashCode;

        UrlKey(String scheme, String host, int port) {
            this.scheme = scheme;
            this.host = host;
            this.port = port;
            this.hashCode = 31 * (CharSequences.caseInsensitiveHashCode(host) + port) + scheme.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UrlKey urlKey = (UrlKey)o;
            return this.port == urlKey.port && this.host.equalsIgnoreCase(urlKey.host) && this.scheme.equals(urlKey.scheme);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static final class UrlKeyFactory {
        private final int defaultHttpPort;
        private final int defaultHttpsPort;

        UrlKeyFactory(int defaultHttpPort, int defaultHttpsPort) {
            this.defaultHttpPort = defaultHttpPort;
            this.defaultHttpsPort = defaultHttpsPort;
        }

        UrlKey get(HttpRequestMetaData metaData) throws MalformedURLException {
            String scheme = UrlKeyFactory.ensureUrlComponentNonNull(metaData.scheme(), "scheme");
            assert (scheme.equals(scheme.toLowerCase(Locale.ENGLISH))) : "scheme must be in lowercase";
            String host = UrlKeyFactory.ensureUrlComponentNonNull(metaData.host(), "host");
            int parsedPort = metaData.port();
            int port = parsedPort >= 0 ? parsedPort : (HTTPS_SCHEME.equals(scheme) ? this.defaultHttpsPort : this.defaultHttpPort);
            UrlKeyFactory.setHostHeader(metaData, host, parsedPort);
            metaData.requestTarget(UrlKeyFactory.absoluteToRelativeFormRequestTarget(metaData.requestTarget(), scheme, host));
            return new UrlKey(scheme, host, port);
        }

        private static String ensureUrlComponentNonNull(@Nullable String value, String name) throws MalformedURLException {
            if (value == null) {
                throw new MalformedURLException("Request-target does not contain " + name + ", expected absolute-form URL (scheme://host/path)");
            }
            return value;
        }

        private static void setHostHeader(HttpRequestMetaData metaData, String host, int port) {
            if (metaData.version().compareTo(HttpProtocolVersion.HTTP_1_1) >= 0 && !metaData.headers().contains(HttpHeaderNames.HOST)) {
                String authority = host;
                if (port >= 0) {
                    authority = authority + ':' + port;
                }
                metaData.headers().add(HttpHeaderNames.HOST, (CharSequence)authority);
            }
        }

        private static String absoluteToRelativeFormRequestTarget(String requestTarget, String scheme, String host) {
            int fromIndex = scheme.length() + 3 + host.length();
            int relativeReferenceIdx = requestTarget.indexOf(47, fromIndex);
            if (relativeReferenceIdx >= 0) {
                return requestTarget.substring(relativeReferenceIdx);
            }
            int questionMarkIdx = requestTarget.indexOf(63, fromIndex);
            return questionMarkIdx < 0 ? "/" : '/' + requestTarget.substring(questionMarkIdx);
        }
    }
}

