/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.DefaultHttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.transport.api.ExecutionStrategy;

public interface HttpExecutionStrategy
extends ExecutionStrategy {
    @Override
    default public boolean hasOffloads() {
        return ExecutionStrategy.super.hasOffloads() || this.isEventOffloaded() || this.isRequestResponseOffloaded();
    }

    default public boolean isRequestResponseOffloaded() {
        return this.isSendOffloaded() || this.isMetadataReceiveOffloaded() || this.isDataReceiveOffloaded();
    }

    public boolean isMetadataReceiveOffloaded();

    public boolean isDataReceiveOffloaded();

    public boolean isSendOffloaded();

    public boolean isEventOffloaded();

    public HttpExecutionStrategy merge(HttpExecutionStrategy var1);

    default public HttpExecutionStrategy missing(HttpExecutionStrategy other) {
        if (this.equals(other) || !other.hasOffloads()) {
            return DefaultHttpExecutionStrategy.OFFLOAD_NONE_STRATEGY;
        }
        byte effectiveOffloads = 0;
        if (other.isSendOffloaded() && !this.isSendOffloaded()) {
            effectiveOffloads = (byte)(effectiveOffloads | HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND.mask());
        }
        if (other.isMetadataReceiveOffloaded() && !this.isMetadataReceiveOffloaded()) {
            effectiveOffloads = (byte)(effectiveOffloads | HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META.mask());
        }
        if (other.isDataReceiveOffloaded() && !this.isDataReceiveOffloaded()) {
            effectiveOffloads = (byte)(effectiveOffloads | HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA.mask());
        }
        if (other.isEventOffloaded() && !this.isEventOffloaded()) {
            effectiveOffloads = (byte)(effectiveOffloads | HttpExecutionStrategies.HttpOffload.OFFLOAD_EVENT.mask());
        }
        if (other.isCloseOffloaded() && !this.isCloseOffloaded()) {
            effectiveOffloads = (byte)(effectiveOffloads | HttpExecutionStrategies.HttpOffload.OFFLOAD_CLOSE.mask());
        }
        return DefaultHttpExecutionStrategy.fromMask(effectiveOffloads);
    }

    public static HttpExecutionStrategy from(ExecutionStrategy strategy) {
        return strategy instanceof HttpExecutionStrategy ? (HttpExecutionStrategy)strategy : (strategy.hasOffloads() ? HttpExecutionStrategies.offloadAll() : HttpExecutionStrategies.offloadNone());
    }
}

