/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.ByteProcessor;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.encoding.api.Identity;
import io.servicetalk.http.api.DefaultHttpCookiePair;
import io.servicetalk.http.api.DefaultHttpSetCookie;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpSetCookie;
import io.servicetalk.http.api.UnsupportedContentEncodingException;
import io.servicetalk.http.api.UriUtils;
import io.servicetalk.serialization.api.SerializationException;
import io.servicetalk.utils.internal.CharsetUtils;
import io.servicetalk.utils.internal.IllegalCharacterException;
import io.servicetalk.utils.internal.NetworkUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class HeaderUtils {
    static final int HASH_CODE_SEED = -1028477387;
    public static final BiFunction<? super CharSequence, ? super CharSequence, CharSequence> DEFAULT_HEADER_FILTER = (k, v) -> "<filtered>";
    private static final List<CharSequence> DEFAULT_DEBUG_HEADER_NAMES = Arrays.asList(HttpHeaderNames.CONTENT_TYPE, HttpHeaderNames.CONTENT_LENGTH, HttpHeaderNames.TRANSFER_ENCODING);
    static final BiFunction<? super CharSequence, ? super CharSequence, CharSequence> DEFAULT_DEBUG_HEADER_FILTER = (key, value) -> {
        for (CharSequence headerName : DEFAULT_DEBUG_HEADER_NAMES) {
            if (!CharSequences.contentEqualsIgnoreCase(key, headerName)) continue;
            return value;
        }
        return "<filtered>";
    };
    static final boolean COOKIE_STRICT_RFC_6265 = Boolean.parseBoolean(System.getProperty("io.servicetalk.http.api.headers.cookieParsingStrictRfc6265", "false"));
    private static final byte HT = 9;
    private static final byte DEL = 127;
    private static final byte CONTROL_CHARS_MASK = -32;
    private static final Pattern HAS_CHARSET_PATTERN = Pattern.compile(".+;\\s*charset=.+", 2);
    private static final Map<Charset, Pattern> CHARSET_PATTERNS = Collections.unmodifiableMap(CharsetUtils.standardCharsets().stream().collect(Collectors.toMap(Function.identity(), e -> HeaderUtils.compileCharsetRegex(e.name()))));

    private HeaderUtils() {
    }

    static String toString(HttpHeaders headers, BiFunction<? super CharSequence, ? super CharSequence, CharSequence> filter) {
        String simpleName = headers.getClass().getSimpleName();
        int size = headers.size();
        if (size == 0) {
            return simpleName + "[]";
        }
        StringBuilder sb = new StringBuilder(simpleName.length() + 2 + size * 20).append(simpleName).append('[');
        Iterator<Map.Entry<CharSequence, CharSequence>> itr = headers.iterator();
        if (itr.hasNext()) {
            while (true) {
                Map.Entry<CharSequence, CharSequence> e = itr.next();
                sb.append(e.getKey()).append(": ").append(filter.apply(e.getKey(), e.getValue()));
                if (!itr.hasNext()) break;
                sb.append(System.lineSeparator());
            }
        }
        return sb.append(']').toString();
    }

    public static boolean isTransferEncodingChunked(HttpHeaders headers) {
        return HeaderUtils.containsCommaSeparatedValueIgnoreCase(headers, HttpHeaderNames.TRANSFER_ENCODING, HttpHeaderValues.CHUNKED);
    }

    static boolean containsCommaSeparatedValueIgnoreCase(HttpHeaders headers, CharSequence name, CharSequence value) {
        Iterator<? extends CharSequence> values = headers.valuesIterator(name);
        while (values.hasNext()) {
            CharSequence next = values.next();
            if (!HeaderUtils.containsCommaSeparatedValueIgnoreCase(next, value)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCommaSeparatedValueIgnoreCase(CharSequence commaSeparatedValues, CharSequence needle) {
        int start = 0;
        int commaPos = CharSequences.indexOf(commaSeparatedValues, ',', 0);
        if (commaPos < 0) {
            return CharSequences.contentEqualsIgnoreCase(commaSeparatedValues, needle);
        }
        String commaSeparatedValuesStr = commaSeparatedValues.toString();
        while (commaPos >= 0) {
            String subvalue = commaSeparatedValuesStr.substring(start, commaPos).trim();
            if (CharSequences.contentEqualsIgnoreCase(subvalue, needle)) {
                return true;
            }
            start = commaPos + 1;
            commaPos = commaSeparatedValuesStr.indexOf(44, start);
        }
        return start > 0 && CharSequences.contentEqualsIgnoreCase(commaSeparatedValuesStr.substring(start).trim(), needle);
    }

    static boolean hasContentLength(HttpHeaders headers) {
        return headers.contains(HttpHeaderNames.CONTENT_LENGTH);
    }

    static void addContentEncoding(HttpHeaders headers, CharSequence encoding) {
        headers.add(HttpHeaderNames.CONTENT_ENCODING, encoding);
        headers.add(HttpHeaderNames.VARY, HttpHeaderNames.CONTENT_ENCODING);
    }

    static boolean hasContentEncoding(HttpHeaders headers) {
        return headers.contains(HttpHeaderNames.CONTENT_ENCODING);
    }

    static void setAcceptEncoding(HttpHeaders headers, @Nullable CharSequence encodings) {
        if (encodings != null && !headers.contains(HttpHeaderNames.ACCEPT_ENCODING)) {
            headers.set(HttpHeaderNames.ACCEPT_ENCODING, encodings);
        }
    }

    static void validateCookieNameAndValue(CharSequence cookieName, CharSequence cookieValue) {
        if (cookieName == null || cookieName.length() == 0) {
            throw new IllegalArgumentException("Null or empty cookie names are not allowed.");
        }
        if (cookieValue == null) {
            throw new IllegalArgumentException("Null cookie values are not allowed.");
        }
    }

    static void validateToken(CharSequence token, String what) {
        CharSequences.forEachByte(token, new TokenValidatingProcessor(token, what));
    }

    static void validateHeaderValue(CharSequence value) {
        CharSequences.forEachByte(value, HeaderUtils::validateHeaderValue);
    }

    public static boolean domainMatches(CharSequence requestDomain, @Nullable CharSequence cookieDomain) {
        if (cookieDomain == null || requestDomain.length() == 0) {
            return false;
        }
        int startIndex = cookieDomain.length() - requestDomain.length();
        if (startIndex == 0) {
            return CharSequences.contentEqualsIgnoreCase(cookieDomain, requestDomain);
        }
        boolean queryEndsInDot = requestDomain.charAt(requestDomain.length() - 1) == '.';
        return (queryEndsInDot && startIndex >= -1 && CharSequences.regionMatches(cookieDomain, true, startIndex + 1, requestDomain, 0, requestDomain.length() - 1) || !queryEndsInDot && startIndex > 0 && CharSequences.regionMatches(cookieDomain, true, startIndex, requestDomain, 0, requestDomain.length())) && !NetworkUtils.isValidIpV4Address(cookieDomain) && !NetworkUtils.isValidIpV6Address(cookieDomain);
    }

    public static boolean pathMatches(CharSequence requestPath, @Nullable CharSequence cookiePath) {
        if (cookiePath == null || cookiePath.length() == 0 || requestPath.length() == 0) {
            return false;
        }
        if (requestPath.length() == cookiePath.length()) {
            return CharSequences.contentEquals(requestPath, cookiePath);
        }
        boolean actualStartsWithSlash = cookiePath.charAt(0) == '/';
        int length = Math.min(actualStartsWithSlash ? cookiePath.length() - 1 : cookiePath.length(), requestPath.length());
        return CharSequences.regionMatches(requestPath, false, requestPath.charAt(0) == '/' && !actualStartsWithSlash ? 1 : 0, cookiePath, 0, length) && (requestPath.length() > cookiePath.length() || cookiePath.charAt(length) == '/');
    }

    public static boolean isSetCookieNameMatches(CharSequence setCookieString, CharSequence setCookieName) {
        int equalsIndex = CharSequences.indexOf(setCookieString, '=', 0);
        return equalsIndex > 0 && equalsIndex == setCookieName.length() && CharSequences.regionMatches(setCookieName, true, 0, setCookieString, 0, equalsIndex);
    }

    @Nullable
    public static HttpSetCookie parseSetCookie(CharSequence setCookieString, CharSequence setCookieName, boolean validate) {
        if (HeaderUtils.isSetCookieNameMatches(setCookieString, setCookieName)) {
            return DefaultHttpSetCookie.parseSetCookie(setCookieString, validate, setCookieString.subSequence(0, setCookieName.length()), setCookieName.length() + 1);
        }
        return null;
    }

    @Nullable
    public static HttpCookiePair parseCookiePair(CharSequence cookieString, CharSequence cookiePairName) {
        int equalsIndex;
        int start = 0;
        while ((equalsIndex = CharSequences.indexOf(cookieString, '=', start)) > 0 && cookieString.length() - 1 > equalsIndex) {
            int nameLen = equalsIndex - start;
            int semiIndex = HeaderUtils.nextCookieDelimiter(cookieString, equalsIndex + 1);
            if (nameLen == cookiePairName.length() && CharSequences.regionMatches(cookiePairName, true, 0, cookieString, start, nameLen)) {
                if (COOKIE_STRICT_RFC_6265 && semiIndex > 0 && cookieString.length() - 2 <= semiIndex) {
                    throw new IllegalArgumentException("cookie '" + cookiePairName + "': cookie is not allowed to end with ;");
                }
                return DefaultHttpCookiePair.parseCookiePair(cookieString, start, nameLen, semiIndex);
            }
            if (semiIndex < 0) break;
            if (COOKIE_STRICT_RFC_6265) {
                if (semiIndex + 1 < cookieString.length() && cookieString.charAt(semiIndex + 1) != ' ') {
                    throw new IllegalArgumentException("cookie " + cookieString.subSequence(start, equalsIndex) + " must have a space after ; in cookie attribute-value lists");
                }
                start = semiIndex + 2;
            } else {
                int n = start = semiIndex + 1 < cookieString.length() && cookieString.charAt(semiIndex + 1) == ' ' ? semiIndex + 2 : semiIndex + 1;
            }
            if (start >= 0 && start < cookieString.length()) continue;
            break;
        }
        return null;
    }

    @Nullable
    public static CharSequence removeCookiePairs(CharSequence cookieString, CharSequence cookiePairName) {
        int equalsIndex;
        int start = 0;
        int beginCopyIndex = 0;
        StringBuilder sb = null;
        while ((equalsIndex = CharSequences.indexOf(cookieString, '=', start)) > 0 && cookieString.length() - 1 > equalsIndex) {
            int nameLen = equalsIndex - start;
            int semiIndex = HeaderUtils.nextCookieDelimiter(cookieString, equalsIndex + 1);
            if (nameLen == cookiePairName.length() && CharSequences.regionMatches(cookiePairName, true, 0, cookieString, start, nameLen)) {
                if (beginCopyIndex != start) {
                    if (sb == null) {
                        sb = new StringBuilder(cookieString.length() - beginCopyIndex);
                    } else {
                        sb.append("; ");
                    }
                    sb.append(cookieString.subSequence(beginCopyIndex, start - 2));
                }
                if (semiIndex < 0 || cookieString.length() - 2 <= semiIndex) {
                    start = cookieString.length();
                    break;
                }
                beginCopyIndex = start = semiIndex + 2;
                continue;
            }
            if (semiIndex > 0) {
                if (cookieString.length() - 2 <= semiIndex) {
                    throw new IllegalArgumentException("cookie is not allowed to end with ;");
                }
                start = semiIndex + 2;
                continue;
            }
            if (beginCopyIndex == 0) break;
            if (sb == null) {
                sb = new StringBuilder(cookieString.length() - beginCopyIndex);
            } else {
                sb.append("; ");
            }
            sb.append(cookieString.subSequence(beginCopyIndex, cookieString.length()));
            break;
        }
        return sb == null ? (start == cookieString.length() ? "" : null) : sb.toString();
    }

    private static int nextCookieDelimiter(CharSequence cookieHeaderValue, int startIndex) {
        boolean inQuotes = false;
        int len = cookieHeaderValue.length();
        for (int i = startIndex; i < len; ++i) {
            char value = cookieHeaderValue.charAt(i);
            if (value == ';') {
                if (inQuotes) {
                    throw new IllegalArgumentException("The ; character cannot appear in quoted cookie values");
                }
                return i;
            }
            if (value != '\"') continue;
            inQuotes = !inQuotes;
        }
        return -1;
    }

    @Nullable
    @Deprecated
    static ContentCodec identifyContentEncodingOrNullIfIdentity(HttpHeaders headers, List<ContentCodec> allowedEncodings) {
        CharSequence encoding = headers.get(HttpHeaderNames.CONTENT_ENCODING);
        if (encoding == null) {
            return null;
        }
        ContentCodec enc = io.servicetalk.encoding.api.internal.HeaderUtils.encodingFor(allowedEncodings, encoding);
        if (enc == null) {
            throw new UnsupportedContentEncodingException(encoding.toString());
        }
        return Identity.identity().equals(enc) ? null : enc;
    }

    public static boolean hasContentType(HttpHeaders headers, CharSequence expectedContentType, @Nullable Charset expectedCharset) {
        Pattern pattern;
        CharSequence contentTypeHeader = headers.get(HttpHeaderNames.CONTENT_TYPE);
        if (contentTypeHeader == null || contentTypeHeader.length() == 0) {
            return false;
        }
        if (expectedCharset == null) {
            if (CharSequences.contentEqualsIgnoreCase(expectedContentType, contentTypeHeader)) {
                return true;
            }
            return CharSequences.regionMatches(contentTypeHeader, true, 0, expectedContentType, 0, expectedContentType.length());
        }
        if (!CharSequences.regionMatches(contentTypeHeader, true, 0, expectedContentType, 0, expectedContentType.length())) {
            return false;
        }
        if (StandardCharsets.UTF_8.equals(expectedCharset)) {
            if (contentTypeHeader.length() == expectedContentType.length()) {
                return true;
            }
            if (CharSequences.regionMatches(contentTypeHeader, true, expectedContentType.length(), "; charset=UTF-8", 0, 15)) {
                return true;
            }
            if (!HeaderUtils.hasCharset(contentTypeHeader)) {
                return true;
            }
        }
        if ((pattern = CHARSET_PATTERNS.get(expectedCharset)) == null) {
            pattern = HeaderUtils.compileCharsetRegex(expectedCharset.name());
        }
        return pattern.matcher(contentTypeHeader.subSequence(expectedContentType.length(), contentTypeHeader.length())).matches();
    }

    static void checkContentType(HttpHeaders headers, Predicate<HttpHeaders> contentTypePredicate) {
        if (!contentTypePredicate.test(headers)) {
            throw new SerializationException("Unexpected headers, can not deserialize. Headers: " + headers.toString(DEFAULT_DEBUG_HEADER_FILTER));
        }
    }

    static void deserializeCheckContentType(HttpHeaders headers, Predicate<HttpHeaders> contentTypePredicate) {
        if (!contentTypePredicate.test(headers)) {
            throw new io.servicetalk.serializer.api.SerializationException("Unexpected headers, can not deserialize. Headers: " + headers.toString(DEFAULT_DEBUG_HEADER_FILTER));
        }
    }

    private static Pattern compileCharsetRegex(String charsetName) {
        return Pattern.compile(".*;\\s*charset=\"?" + Pattern.quote(charsetName) + "\"?\\s*(;.*|$)", 2);
    }

    private static boolean hasCharset(CharSequence contentTypeHeader) {
        return HAS_CHARSET_PATTERN.matcher(contentTypeHeader).matches();
    }

    static boolean isTchar(byte value) {
        return UriUtils.isBitSet(value, UriUtils.TCHAR_LMASK, UriUtils.TCHAR_HMASK);
    }

    private static boolean validateHeaderValue(byte value) {
        if ((value & 0xFFFFFFE0) == 0 && value != 9 || value == 127) {
            throw new IllegalCharacterException(value, "(VCHAR / obs-text) [ 1*(SP / HTAB) (VCHAR / obs-text) ]");
        }
        return true;
    }

    private static final class TokenValidatingProcessor
    implements ByteProcessor {
        private static final String EXPECTED = "! / # / $ / % / & / ' / * / + / - / . / ^ / _ / ` / | / ~ / DIGIT / ALPHA";
        private final CharSequence token;
        private final String what;
        private int idx;

        TokenValidatingProcessor(CharSequence token, String what) {
            this.token = token;
            this.what = what;
        }

        @Override
        public boolean process(byte value) {
            if (!HeaderUtils.isTchar(value)) {
                throw new IllegalCharacterException(this.message(value));
            }
            ++this.idx;
            return true;
        }

        private String message(byte value) {
            int codePoint = value & 0xFF;
            int idx = this.idx;
            StringBuilder sb = new StringBuilder(40 + TokenValidatingProcessor.intToStringLength(idx) + this.what.length() + this.token.length() + EXPECTED.length()).append('\'').append((char)codePoint).append("' (0x").append(Integer.toHexString(0x100 | codePoint), 1, 3).append(") at index=").append(idx).append(" in ").append(this.what).append(' ').append('\'').append(this.token).append("', expected [").append(EXPECTED).append(']');
            return sb.toString();
        }

        private static int intToStringLength(int value) {
            assert (value >= 0);
            int length = 1;
            for (int test = 10; test <= value && test <= 1000000000; test *= 10) {
                ++length;
            }
            return length;
        }
    }

    public static abstract class CookiesByNameIterator
    implements Iterator<HttpCookiePair> {
        private final CharSequence cookiePairName;
        private int nextNextStart;
        @Nullable
        private HttpCookiePair next;

        protected CookiesByNameIterator(CharSequence cookiePairName) {
            this.cookiePairName = cookiePairName;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        @Override
        public final HttpCookiePair next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            HttpCookiePair current = this.next;
            CharSequence cookieHeaderValue = this.cookieHeaderValue();
            this.next = cookieHeaderValue == null ? null : this.findNext(cookieHeaderValue);
            return current;
        }

        @Nullable
        protected abstract CharSequence cookieHeaderValue();

        protected abstract void advanceCookieHeaderValue();

        protected final void initNext(CharSequence cookieHeaderValue) {
            this.next = this.findNext(cookieHeaderValue);
        }

        @Nullable
        private HttpCookiePair findNext(CharSequence cookieHeaderValue) {
            int equalsIndex;
            while ((equalsIndex = CharSequences.indexOf(cookieHeaderValue, '=', this.nextNextStart)) > 0 && cookieHeaderValue.length() - 1 > equalsIndex) {
                int nameLen = equalsIndex - this.nextNextStart;
                int semiIndex = HeaderUtils.nextCookieDelimiter(cookieHeaderValue, equalsIndex + 1);
                if (nameLen == this.cookiePairName.length() && CharSequences.regionMatches(this.cookiePairName, true, 0, cookieHeaderValue, this.nextNextStart, nameLen)) {
                    HttpCookiePair next = DefaultHttpCookiePair.parseCookiePair(cookieHeaderValue, this.nextNextStart, nameLen, semiIndex);
                    if (semiIndex > 0) {
                        if (cookieHeaderValue.length() - 2 <= semiIndex) {
                            this.advanceCookieHeaderValue();
                            this.nextNextStart = 0;
                        } else {
                            this.nextNextStart = semiIndex + 2;
                        }
                    } else {
                        this.advanceCookieHeaderValue();
                        this.nextNextStart = 0;
                    }
                    return next;
                }
                if (semiIndex > 0) {
                    if (cookieHeaderValue.length() - 2 <= semiIndex) {
                        throw new IllegalArgumentException("cookie is not allowed to end with ;");
                    }
                    this.nextNextStart = semiIndex + 2;
                    continue;
                }
                this.advanceCookieHeaderValue();
                cookieHeaderValue = this.cookieHeaderValue();
                if (cookieHeaderValue == null) break;
                this.nextNextStart = 0;
            }
            return null;
        }
    }

    public static abstract class CookiesIterator
    implements Iterator<HttpCookiePair> {
        @Nullable
        private HttpCookiePair next;
        private int nextNextStart;

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        @Override
        public final HttpCookiePair next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            HttpCookiePair current = this.next;
            CharSequence cookieHeaderValue = this.cookieHeaderValue();
            this.next = cookieHeaderValue == null ? null : this.findNext(cookieHeaderValue);
            return current;
        }

        @Nullable
        protected abstract CharSequence cookieHeaderValue();

        protected abstract void advanceCookieHeaderValue();

        protected final void initNext(CharSequence cookieHeaderValue) {
            this.next = this.findNext(cookieHeaderValue);
        }

        private HttpCookiePair findNext(CharSequence cookieHeaderValue) {
            int semiIndex = HeaderUtils.nextCookieDelimiter(cookieHeaderValue, this.nextNextStart);
            int nameLength = CharSequences.indexOf(cookieHeaderValue, '=', this.nextNextStart) - this.nextNextStart;
            if (nameLength < 0) {
                throw new IllegalArgumentException("no cookie value found after index " + this.nextNextStart + (this.next == null ? " (there was no previous cookie)" : " (found after parsing the '" + this.next.name() + "' cookie)"));
            }
            HttpCookiePair next = DefaultHttpCookiePair.parseCookiePair(cookieHeaderValue, this.nextNextStart, nameLength, semiIndex);
            if (semiIndex > 0) {
                if (cookieHeaderValue.length() - 2 <= semiIndex) {
                    if (COOKIE_STRICT_RFC_6265) {
                        throw new IllegalArgumentException("cookie '" + next.name() + "': cookie is not allowed to end with ;");
                    }
                    this.advanceCookieHeaderValue();
                    this.nextNextStart = 0;
                } else if (COOKIE_STRICT_RFC_6265) {
                    if (cookieHeaderValue.charAt(semiIndex + 1) != ' ') {
                        throw new IllegalArgumentException("cookie '" + next.name() + "': a space is required after ; in cookie attribute-value lists");
                    }
                    this.nextNextStart = semiIndex + 2;
                } else {
                    this.nextNextStart = semiIndex + (cookieHeaderValue.charAt(semiIndex + 1) == ' ' ? 2 : 1);
                }
            } else {
                this.advanceCookieHeaderValue();
                this.nextNextStart = 0;
            }
            return next;
        }
    }
}

