/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.http.api.UriUtils;
import io.servicetalk.serializer.api.SerializationException;
import io.servicetalk.serializer.api.SerializerDeserializer;
import io.servicetalk.utils.internal.CharsetUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class FormUrlEncodedSerializer
implements SerializerDeserializer<Map<String, List<String>>> {
    private static final Map<Charset, byte[]> CONTINUATIONS_SEPARATORS;
    private static final Map<Charset, byte[]> KEYVALUE_SEPARATORS;
    private final Charset charset;
    private final byte[] continuationSeparator;
    private final byte[] keyValueSeparator;

    FormUrlEncodedSerializer(Charset charset) {
        this.charset = charset;
        byte[] continuationSeparator = CONTINUATIONS_SEPARATORS.get(charset);
        if (continuationSeparator == null) {
            this.continuationSeparator = "&".getBytes(charset);
            this.keyValueSeparator = "=".getBytes(charset);
        } else {
            this.continuationSeparator = continuationSeparator;
            this.keyValueSeparator = KEYVALUE_SEPARATORS.get(charset);
        }
    }

    @Override
    public Map<String, List<String>> deserialize(Buffer serializedData, BufferAllocator allocator) {
        return FormUrlEncodedSerializer.deserialize(serializedData, this.charset);
    }

    @Override
    public Buffer serialize(Map<String, List<String>> toSerialize, BufferAllocator allocator) {
        Buffer buffer = allocator.newBuffer(toSerialize.size() * 10);
        this.serialize(toSerialize, allocator, buffer);
        return buffer;
    }

    @Override
    public void serialize(Map<String, List<String>> toSerialize, BufferAllocator allocator, Buffer buffer) {
        boolean needContinuation = false;
        for (Map.Entry<String, List<String>> entry : toSerialize.entrySet()) {
            String key = entry.getKey();
            if (key == null || key.isEmpty()) {
                throw new SerializationException("Null or empty keys are not supported for x-www-form-urlencoded params");
            }
            List<String> values = entry.getValue();
            if (values == null) continue;
            for (String value : values) {
                if (value == null) continue;
                if (needContinuation) {
                    buffer.writeBytes(this.continuationSeparator);
                } else {
                    needContinuation = true;
                }
                buffer.writeBytes(FormUrlEncodedSerializer.urlEncode(key, this.charset));
                buffer.writeBytes(this.keyValueSeparator);
                buffer.writeBytes(FormUrlEncodedSerializer.urlEncode(value, this.charset));
            }
        }
    }

    static Map<String, List<String>> deserialize(@Nullable Buffer buffer, Charset charset) {
        if (buffer == null || buffer.readableBytes() == 0) {
            return Collections.emptyMap();
        }
        return UriUtils.decodeQueryParams(buffer.toString(charset), charset, 1024, (value, charset2) -> {
            try {
                return URLDecoder.decode(value, charset2.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("URLDecoder failed to find Charset: " + charset2, e);
            }
        });
    }

    private static byte[] urlEncode(String value, Charset charset) {
        try {
            return URLEncoder.encode(value, charset.name()).getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("URLDecoder failed to find Charset: " + charset, e);
        }
    }

    static {
        Collection<Charset> charsets = CharsetUtils.standardCharsets();
        int size = charsets.size();
        CONTINUATIONS_SEPARATORS = new HashMap<Charset, byte[]>(size);
        KEYVALUE_SEPARATORS = new HashMap<Charset, byte[]>(size);
        for (Charset charset : charsets) {
            byte[] keyvalue;
            byte[] continuation;
            try {
                continuation = "&".getBytes(charset);
                keyvalue = "=".getBytes(charset);
            }
            catch (Throwable cause) {
                continue;
            }
            CONTINUATIONS_SEPARATORS.put(charset, continuation);
            KEYVALUE_SEPARATORS.put(charset, keyvalue);
        }
    }
}

