/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.LoadBalancer;
import io.servicetalk.client.api.LoadBalancerFactory;
import io.servicetalk.client.api.ReservableRequestConcurrencyController;
import io.servicetalk.client.api.ScoreSupplier;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpLoadBalancedConnection;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpLoadBalancerFactory;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;

public final class DefaultHttpLoadBalancerFactory<ResolvedAddress>
implements HttpLoadBalancerFactory<ResolvedAddress> {
    private final LoadBalancerFactory<ResolvedAddress, FilterableStreamingHttpLoadBalancedConnection> rawFactory;
    private final HttpExecutionStrategy strategy;

    public DefaultHttpLoadBalancerFactory(LoadBalancerFactory<ResolvedAddress, FilterableStreamingHttpLoadBalancedConnection> rawFactory) {
        this.rawFactory = rawFactory;
        this.strategy = HttpExecutionStrategy.from(rawFactory.requiredOffloads());
    }

    @Override
    public <T extends FilterableStreamingHttpLoadBalancedConnection> LoadBalancer<T> newLoadBalancer(String targetResource, Publisher<? extends Collection<? extends ServiceDiscovererEvent<ResolvedAddress>>> eventPublisher, ConnectionFactory<ResolvedAddress, T> connectionFactory) {
        return this.rawFactory.newLoadBalancer(targetResource, eventPublisher, connectionFactory);
    }

    @Override
    public LoadBalancer<FilterableStreamingHttpLoadBalancedConnection> newLoadBalancer(Publisher<? extends Collection<? extends ServiceDiscovererEvent<ResolvedAddress>>> eventPublisher, ConnectionFactory<ResolvedAddress, FilterableStreamingHttpLoadBalancedConnection> connectionFactory, String targetResource) {
        return this.rawFactory.newLoadBalancer(eventPublisher, connectionFactory, targetResource);
    }

    @Override
    public FilterableStreamingHttpLoadBalancedConnection toLoadBalancedConnection(FilterableStreamingHttpConnection connection) {
        return new DefaultFilterableStreamingHttpLoadBalancedConnection(connection);
    }

    @Override
    public FilterableStreamingHttpLoadBalancedConnection toLoadBalancedConnection(FilterableStreamingHttpConnection connection, ReservableRequestConcurrencyController concurrencyController, @Nullable ContextMap context) {
        return new HttpLoadBalancerFactory.DefaultFilterableStreamingHttpLoadBalancedConnection(connection, concurrencyController);
    }

    @Override
    public HttpExecutionStrategy requiredOffloads() {
        return this.strategy;
    }

    private static final class DefaultFilterableStreamingHttpLoadBalancedConnection
    implements FilterableStreamingHttpLoadBalancedConnection {
        private final FilterableStreamingHttpConnection delegate;

        DefaultFilterableStreamingHttpLoadBalancedConnection(FilterableStreamingHttpConnection delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public int score() {
            throw new UnsupportedOperationException(DefaultFilterableStreamingHttpLoadBalancedConnection.class.getName() + " doesn't support scoring. " + ScoreSupplier.class.getName() + " is only available through " + HttpLoadBalancerFactory.class.getSimpleName() + " implementations that support scoring.");
        }

        @Override
        public HttpConnectionContext connectionContext() {
            return this.delegate.connectionContext();
        }

        @Override
        public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
            return this.delegate.transportEventStream(eventKey);
        }

        @Override
        public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
            return this.delegate.request(request);
        }

        @Override
        public HttpExecutionContext executionContext() {
            return this.delegate.executionContext();
        }

        @Override
        public StreamingHttpResponseFactory httpResponseFactory() {
            return this.delegate.httpResponseFactory();
        }

        @Override
        public Completable onClose() {
            return this.delegate.onClose();
        }

        @Override
        public Completable onClosing() {
            return this.delegate.onClosing();
        }

        @Override
        public Completable closeAsync() {
            return this.delegate.closeAsync();
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.delegate.closeAsyncGracefully();
        }

        @Override
        public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return this.delegate.newRequest(method, requestTarget);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

