/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.ConcurrentSubscription;
import io.servicetalk.concurrent.internal.EmptySubscriptions;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.utils.internal.NumberUtils;
import javax.annotation.Nullable;

final class TakeNPublisher<T>
extends AbstractSynchronousPublisherOperator<T, T> {
    private static final PublisherSource.Subscription CANCELLED = EmptySubscriptions.newEmptySubscription();
    private final long numElements;

    TakeNPublisher(Publisher<T> original, long numElements) {
        super(original);
        this.numElements = NumberUtils.ensurePositive(numElements, "numElements");
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        return new TakeNSubscriber<T>(subscriber, this.numElements);
    }

    private static final class TakeNSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<? super T> subscriber;
        private final long numElements;
        @Nullable
        private PublisherSource.Subscription subscription;
        private long receivedElements;

        TakeNSubscriber(PublisherSource.Subscriber<? super T> subscriber, long numElements) {
            this.subscriber = subscriber;
            this.numElements = numElements;
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription s) {
            if (!SubscriberUtils.checkDuplicateSubscription(this.subscription, s)) {
                return;
            }
            this.subscription = new ConcurrentSubscription(s){
                private long num;
                {
                    super(x0);
                    this.num = numElements;
                }

                @Override
                public void request(long n) {
                    if (SubscriberUtils.isRequestNValid(n)) {
                        if (this.num == 0L) {
                            return;
                        }
                        if (n >= this.num) {
                            n = this.num;
                            this.num = 0L;
                        } else {
                            this.num -= n;
                        }
                    }
                    super.request(n);
                }
            };
            this.subscriber.onSubscribe(this.subscription);
        }

        @Override
        public void onNext(T t) {
            PublisherSource.Subscription subscription = this.subscription;
            assert (subscription != null) : "Subscription can not be null.";
            this.subscriber.onNext(t);
            if (++this.receivedElements >= this.numElements || this.receivedElements <= 0L) {
                this.subscription = CANCELLED;
                subscription.cancel();
                this.subscriber.onComplete();
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.subscription != CANCELLED) {
                this.subscriber.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (this.subscription != CANCELLED) {
                this.subscriber.onComplete();
            }
        }
    }
}

